

static const char *GetGrayColour    ( bool_t abBackground, int d1, int d2 );
static const char *GetAnsiColourG1  ( bool_t abBackground, int aGreen, int aBlue );

const char *ColourRGB( descriptor_t *apDescriptor, const char *apRGB )
{
   protocol_t *pProtocol = apDescriptor ? apDescriptor->pProtocol : NULL;

   if ( pProtocol && pProtocol->pVariables[eMSDP_ANSI_COLORS]->ValueInt )
   {
      if ( IsValidColour(apRGB) )
      {
          if(tolower(apRGB[1]) == 'g')
          {
             bool_t bBackground = (tolower(apRGB[0]) == 'b');
             int Green = apRGB[2] - '0';
             int Blue = apRGB[3] - '0';

             if ( pProtocol->pVariables[eMSDP_XTERM_256_COLORS]->ValueInt )
                return GetGrayColour( bBackground, Green, Blue );
             else /* Use regular ANSI colour */
                    return GetAnsiColourG1( bBackground, Green, Blue );
          }
          else
          {
             bool_t bBackground = (tolower(apRGB[0]) == 'b');
             int Red = apRGB[1] - '0';
             int Green = apRGB[2] - '0';
             int Blue = apRGB[3] - '0';

             if ( pProtocol->pVariables[eMSDP_XTERM_256_COLORS]->ValueInt )
                return GetRGBColour( bBackground, Red, Green, Blue );
             else /* Use regular ANSI colour */
                return GetAnsiColour( bBackground, Red, Green, Blue );
          }
      }
      else /* Invalid colour - use this to clear any existing colour. */
      {
         return s_Clean;
      }
   }
   else /* Don't send any colour, not even clear */
   {
      return "";
   }
}


//standard grayscale conversion
static const char *GetAnsiColourG1( bool_t abBackground, int aGreen, int aBlue )
{
   if (aGreen == 0 && aBlue <= 8)
        return abBackground ? s_BackBlack : s_BoldBlack;
   else if ((aGreen == 0 && aBlue == 9) || (aGreen == 1 && aBlue <= 6))
        return abBackground ? s_BackWhite : s_DarkWhite;
   else if ((aGreen == 1 && aBlue >= 7) || (aGreen == 2 && aBlue <= 4))
        return abBackground ? s_BackWhite : s_BoldWhite;
    else
        return abBackground ? s_BackWhite : s_DarkWhite;
}

static const char *GetGrayColour( bool_t abBackground, int d1, int d2 )
{
   static char Result[16];
    int num = 0;

    num = d1 * 10;
    num += 231;
    num += d2;

   sprintf(Result, "\033[0;00m\033[%c8;5;%dm", 
      '3'+abBackground,      /* Background */
      num);

   return Result;
}

