/* ************************************************************************
*   File: constants.c                                   Part of CircleMUD *
*  Usage: Numeric and string contants used by the MUD                     *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "interpreter.h"	/* alias_data */
#include "spells.h"

cpp_extern const char *circlemud_version =
	"  v5.0.1  01.09.2013.";

int HORSE_VNUM = 3610;
int HORSE_COST = 100;
int START_SWORD = 112;
int START_CLUB  = 121;
int START_KNIFE = 122;
int START_SCROLL= 115;
int START_BREAD = 125;
int CREATE_LIGHT= 126;
int START_LIGHT = 127;
int START_ARMOR = 113;
int START_BOTTLE= 114;
int START_BOW   = 109;
int START_WRUNE = 223;
int START_ERUNE = 222;
int START_ARUNE = 225;
int START_FRUNE = 224;

/* strings corresponding to ordinals/bitvectors in structs.h ***********/



/* (Note: strings for class definitions in class.c instead of here) */
//   
//		- 0
//	- 1
//		- 2
//	- 3
//	- 4
//		- 5

const int ClasStat[][6] = {
	{ 12, 12, 12, 12, 12, 12},
	{ 10, 10, 10, 14, 16, 13},
	{ 14, 14, 14, 11, 9,  11},
	{ 16, 9,  16, 11, 11, 10},
	{ 13, 16, 10, 12, 9,  13},
	{ 11, 10, 9,  16, 14, 13},
	{ 16, 14, 13, 10, 9,  11},
	{ 13, 13, 11, 9,  14, 13}
};



//   
extern const int material_value [] =
{ 100,
  5,
  50,
  35,
  30,
  20,
  35,
  75,
  45,
  40,
  65,
  80,
  55,
  50,
  70,
  60,
  90,
  90,
  10
};

/* cardinal directions */
const char *dirs1[] =
{ 
  " ",
  " ",
  " ",
  " ",
  "",
  "",
  "\n"
};

const char *dirs[] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "\n"
};


const char *dirs2[] =
{
  " ",
  " ",
  " ",
  " ",
  "",
  "",
  "\n"
};

// (       )
const char *no_bits[] =
{ "!", // 
  "!", //  
  "!",
  "!",
  "!",
  "!",
  "!",
  "!",
  "!",
  "!", //
  "!",
  "!",
  "! ",
  "!",
  "!",
  "\n",
  "\n",
  "\n"
};


// ITEM_ANTI
 const char *anti_bits[] =
 { "!", //  - 
   "!", //  
   "!",
   "!",
   "!",
   "!",
   "!",
   "!",
   "!",
   "!",//
   "!",
   "!",
   "! ",
   "!",
   "!",
   "-",
   "!",
   "\n",
   "\n",
   "\n"
};




/* ROOM_x */
const char *room_bits[] = {
  "",
  "",
  "!",
  "  ",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
  "",
  " - ",
  "OLC",
  "*",				/* BFS MARK */
  " ",
  " ",
  " ",
  " ",
  " ",
  " ",
  " ", //
  " ",
  " ",
  " ",
  " ", //    !!! !!! 
  " ",
  " ",
  "",
  "\n",
  "!",
  "!",
  "!",
  "",
  " ",
  "  ",
  " ",
  " ",
  "\n",
  "\n",
  "\n"
};


/* EX_x */
const char *exit_bits[] = {
  "",
  "",
  "",
  " ",
  " ",
  "\n"
};


/* SECT_ */
const char *sector_types[] = {
  " ",
  "",
  "",
  "",
  "",
  "",
  " ( )",
  " ( )",
  "  ,  ",
  "  ",
  "",
   "\n"
};


/*
 * SEX_x
 * Not used in sprinttype() so no \n.
 */
const char *genders[] =
{
  "",
  "",
  "",
  "",
  "\n"
};


/* POS_x */
const char *position_types[] = {
  "",
  " ",
  "  ",
  "",
  "",
  "",
  "",
  "",
  "",
  "\n"
};


/* PLR_x */
const char *player_bits[] = {
  "",
  "",
  "FROZEN",
  "DONTSET",
  "",
  " ",
  "CSH",
  "SITEOK",
  "",
  "",
  "",
  "LOADRM",
  "!WIZL",
  "!",
  "INVST",
  "CRYO",
  " ",
  ".",
  "",
  "",
  "",
  "",
  "",
  "!",
  "!",
  "",
  "",
  "",
  "",
  "FREE",
  "",
  "\n",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "\n",
  "\n",
  "\n"
};


/* MOB_x */
const char *action_bits[] =
{ "",
  "!",
  "",
  "",
  "!",
  "",
  "",
  "",
  ".",
  ".",
  ".",
  "",
  "",
  "!",
  "!",
  "!",
  "!",
  "!",
  "",
  "!",
  "!",
  ".",
  ".",
  "!",
  "!",
  "",
  "",
  "!",
  "",
  "",
  "\n",
  "",
  "",
  "  ",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  ".",
  "!",
  " ",
  "",
  "",
  " ",
  " ",
  " ",
  " ",
  " ",
  " ",
  "\n",
  "\n",
  "\n"
};

const char *special_bits[] =
{   "!",
	"!",
	"!",
	"!",
	"!",
	"!",
	"  ",
	"  ",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"!",
	" ",
	"*",
	"*",
	".",
	".",
	".",
    ".",
	" ",
	"_",
	"_",
	"__",
	"\n",
	"",
	"",
	"",
	" ",
        "\n",
	"\n",
	"\n"
};

/* PRF_x */
const char *preference_bits[] = {
  "",
  "",
  "",
  "",
  "_",
  " ",
  "",
  "",
  "!",
  "",
  "",
  "!",
  "", //12
  "1",
  "2",
  "!",
  "L1",
  "L2",
  "!",
  "!",
  "!",
  " ",
  "",
  "",
  "!",		//24
  "",
  "",
  "_",
  ".",
  " ",
  "",//30
  "\n"
};


/* AFF_x */
const char *affected_bits[] =
{
  "",
  "",
  " ",
  " ",
  " ",
  " ",
  " ",
  "",
  "",
  "",
  "",
  "",
  "  ",
  "  ",
  " ",
  " ",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
  "",
  "",
  "",
  "",
  "   ",
  " ",
  "",
  "\n",
  "",                 // 00
  "",
  " ",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
  "",
  " ",
  " ",
  " ",
  " ",
  " ",
  "",
  " ",
  "",
  "",
  " ",
  " ",
  " ",
  " ",
  "",
  " ",
  " ",
  "\n",
  "\n",
  "\n"
};

/*
 * WEAR_x - for eq list
 * Not use in sprinttype() so no \n.
 */
 //     
const char *where[] = {
  " < >        ",
  " <  >             ",
  " <  >              ",
  " <  >                 ",
  " <  >                  ",
  " <  >                ",
  " <  >              ",
  " < >                    ",
  " <  >               ",
  " <  >           ",
  " <  >              ",
  " <  >               ",
  " <  >           ",
  " <  >            ",
  " <   >          ",
  " <    >  ",
  " <    >   ",
  " <  >               ",
  " <  >       ",
  " <  >         ",
  " <  >                ",
  " <  >                 ",
  " <  >                "
};


/* WEAR_x - for stat */
const char *equipment_types[] = {
  "          ",
  "           ",
  "            ",
  "     ",
  "     ",
  "                      ",
  "                    ",
  "                      ",
  "              ",
  "                    ",
  "                     ",
  "                ",
  "                  ",
  "                     ",
  "            ",
  "             ",
  "                       ",
  "                        ",
  "                       ",
  "\n"
};


/* ITEM_x (ordinal object types) */
const char *item_types[] = {
  "",
  " ",
  "",
  " ",
  " ",
  "",
  "FIRE WEAPON",
  "MISSILE",
  "",
  "",
  " ",
  "",
  " ",
  "",
  "TRAP",
  "",
  "",
  "  ",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
  "",
  "\n"
};

const char *ingradient_bits[] =
{ "",
  ".",
  ".",
  ".",
  "",
  "\n"
};

/* ITEM_WEAR_ (wear bitvector) */
const char *wear_bits[] = {
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  "\n"
};


// ITEM_x (extra bits)      07.04.2007.
const char *extra_bits[] = {
  "",
  "",
  "!",
  "!",
  "!",
  "",
  "",
  "!",
  "",
  "!",
  "",
  "  ",
  "!",
  "!",
  "",
  "",
  "",
  " ",
  " ",
  " ",
  " ",
  " ",
  " ",
  " ",
  "",
  "",
  " ",
  " ",
  "",
  "",
  //"!",-       ,   !!!
  "\n",
  "",
  "!",
  "!",//    ,       . 
  "\n",
  "\n",
  "\n"
};
 

// APPLY_x 
const char *apply_negative[] = 
{		"",
        "",		// SAVING_WILL
        "",	// SAVING_CRITICAL
        "",	// SAVING_STABILITY
        "",	// SAVING_REFLEX
        "\n"
};

const char *apply_types[] = 
{ "NONE", 				// 0
  "",				// STR
  "",				// DEX
  "",				// INT
  "",				// WIS
  "",				// CON
  "",				// CHA
  "",				// CLASS
  "",				// LEVEL
  "",				// AGE
  "",				// CHAR_WEIGHT 10
  "",				// CHAR_HEIGHT
  " ",			// MAXMANA
  " ",			// MAXHIT
  " ",		        // MAXMOVE
  "",				// GOLD
  "",				// EXP
  "",				// AC
  "",				// HITROLL
  "",			// DAMROLL
  "",				// APPLY_SAVING_WILL
  "  ",	        // APPLY_RESIST_FIRE
  "  ",	// APPLY_RESIST_AIR
  "",				// APPLY_SAVING_CRITICAL
  "",				// APPLY_SAVING_STABILITY
  " ",		        // HITREG
  " ",		// MOVEREG
  " 1",
  " 2",
  " 3",
  " 4",				// 30
  " 5",
  " 6",
  " 7",
  " 8",
  " 9",
  "",
  "",
  "",
  "", 				// SAVING_REFLEX
  " ", 			// 40
  "",
  "",
  "",
  "",
  "",				// // APPLY_LIKES -   ,    .
  "  ",
  "  ",
  "",
  "  ",
  "",
  "  .",
  "  .",
  "\n"
}; 

// MAT_
const char *material_name [] =
{ "",
  "",
  "",
  "",
  "",
  ".",
  ".",
  "",
  "",
  ".",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  ".",
  "\n"
};
/* CONT_x */
const char *container_bits[] = {
  "CLOSEABLE",
  "PICKPROOF",
  "CLOSED",
  "LOCKED",
  "\n",
};


/* LIQ_x */
const char *drinks[] =
{
  "",
  "",
  "",
  " ",
  " ",
  "",
  "",
  "",
  " ",
  " ",
  "",
  "",
  "",
  "",
  " ",
  " ",
  "\n"
};


/* other constants for liquids ******************************************/
/*   */

/* one-word alias for each drink *//*  */
const char *drinknames[] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  " ",
  " ",
  "\n"
};

const char *weapon_affects[] =
{ "",
  "",
  ".",
  ".",
  ".",
  ".",
  "",
  "",
  "",
  "",
  "",
  " ",
  "",
 // "..",
 // "..",
  "",
  ".",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  ".",
  "",
  "",
  "",
  ".",
  "",
  "",
  "\n",
  ".",
  "\n",
  "\n",
  "\n"
};
/* effect of drinks on hunger, thirst, and drunkenness -- see values.doc */
int drink_aff[][3] = {
  {0, 1, 10},
  {3, 2, 5},
  {5, 2, 5},
  {2, 2, 5},
  {1, 2, 5},
  {6, 1, 4},
  {0, 1, 8},
  {10, 0, 0},
  {3, 3, 3},
  {0, 4, -8},
  {0, 3, 6},
  {0, 1, 6},
  {0, 1, 6},
  {0, 2, -1},
  {0, 1, -2},
  {0, 0, 13}
};


/* color of the various drinks */
const char *color_liquid[] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "-",
  "",
  "",
  "-",
  "-",
  "",
  " ",
  "\n"
};


/*
 * level of fullness for drink containers
 * Not used in sprinttype() so no \n.
 */
const char *fullness[] =
{
  "   ",
  "  ",
  "   ",
  ""
};

struct gods_celebrate_type gods_celebrate[] =
/* Unique,Name,Day,Month,Duration,Religion */
{{1," ",1,1,1,0x0002},
 {2," ",6,1,1,0x0002},
 {3," ",2,2,1,0x0002},
 {4," ",-50,DAY_EASTER,1,0x0002},
 {5," ",-49,DAY_EASTER,7,0x0002},	
 {6," ",-42,DAY_EASTER,1,0x0002},		
 {7,"   ",24,2,1,0x0002},		
 {8,"",-8,DAY_EASTER,0x0002},
 {9," ",-7,DAY_EASTER,1,0x0002},
 {10,"  ",0,DAY_EASTER,1,0x0002},
 {11,"  ",7,DAY_EASTER,1,0x0002},
 {12,"",9,DAY_EASTER,1,0x0002},	
 {13," .  ()",23,4,1,0x0002},	
 {14,"   ",25,DAY_EASTER,1,0x0002},			
 {15,"    ",8,	5,1,0x0002},	
 {16,"    ()",9,5,1,0x0002},
 {17,"",40,DAY_EASTER,1,0x0002},
 {18,"  ",48,DAY_EASTER,1,0x0002},	
 {19," , 1 ",49,DAY_EASTER,1,0x0002},
 {20," ,   ",50,DAY_EASTER,1,0x0002},
 {21," , 3 ",51,DAY_EASTER,1,0x0002},
 {22,"    ",25,5,1,0x0002},
 {23,"    ",24,6,1,0x0002},
 {24,"    ",29,6,1,0x0002},	
 {25,"  ",20,7,1,0x0002},
 {26,"   ",	1,8,1,0x0002},			
 {27," ",6,8,1,0x0002},
 {28,"   ",15,8,1,0x0002},	
 {29,"   ",29,8,1,0x0002},
 {30,"  ",8,9,1,0x0002},	
 {31,"  ",14,9,1,0x0002},
 {32,"  ",26,9,1,0x0002},	
 {33,"  ",6,10,1,0x0002},
 {34,"   ",13,11,1,0x0002},	
 {35,"    ",21,11,1,0x0002},		
 {36,"   ",30,11,1,0x0002},			
 {37,"   ",6,12,1,0x0002},
 {38," ",25,12,1,0x0002},	
	
 {100,"",5,1,1,0x0002},
 {101,"",29,8,1,0x0002},
 {102,"",27,9,1,0x0002},
 {103,"",28,11,30,0x0002},
 {104,"",1,1,7,0x0002},
 {105,"",-49,DAY_EASTER,49,0x0002},
 {106,"",14,8,28,0x0002},

 {1001," ",1,1,7,0x0001},
 {1002,"   ",6,1,1,0x0001},
 {1003," ",27,2,1,0x0001},
 {1004," ",29,2,1,0x0001},
 {1005," ",1,3,1,0x0001},	
 {1006," ",14,3,1,0x0001},
 {1007," ",7,4,1,0x0001},
 {1008," ",4,5,1,0x0001},	
 {1009," ",6,5,1,0x0001},
 {1010," ",22,5,1,0x0001},
 {1011," ",31,5,1,0x0001},
 {1012," ",21,6,1,0x0001},
 {1013," ",1,7,7,0x0001},
 {1014,"",9,7,1,0x0001},
 {1015,"  ",27,7,1,0x0001},	
 {1016," ",4,8,1,0x0001},	
 {1017," ",8,8,1,0x0001},
 {1018," ",21,8,1,0x0001},
 {1019," ",28,8,1,0x0001},
 {1020,"  ",14,9,1,0x0001},
 {1021," ",29,10,1,0x0001},
 {1022," ",10,11,1,0x0001},	
 {1023,"   ",26,11,1,0x0001},
 {1024,"   ",9,12,1,0x0001},
 {1025," ",25,12,1,0x0001},
 {0,0,0,0,0,0}
};

struct gods_celebrate_apply_type gods_apply[] =
//  Unique,Type,What,Modi,Next
{//{1," ",1,1,1,0x0002},
 //{2," ",6,1,1,0x0002},
 //{3," ",2,2,1,0x0002},
 //{4," ",-50,DAY_EASTER,1,0x0002},
 //{5," ",-49,DAY_EASTER,7,0x0002},	
 //{6," ",-42,DAY_EASTER,1,0x0002},		
 //{7,"   ",24,2,1,0x0002},		
 //{8,"",-8,DAY_EASTER,0x0002},
 //{9," ",-7,DAY_EASTER,1,0x0002},
 //{10,"  ",0,DAY_EASTER,1,0x0002},
 {10,GAPPLY_MODIFIER,APPLY_HITREG,20,0},
 {10,GAPPLY_MODIFIER,APPLY_MOVEREG,20,0},
 {10,GAPPLY_MODIFIER,APPLY_MANAREG,20,0},
 //{11," ",7,DAY_EASTER,1,0x0002},
 //{12,"",9,DAY_EASTER,1,0x0002},	
 //{13,".  ()",23,4,1,0x0002},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_BASH,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_KICK,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_BACKSTAB,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_STUPOR,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_MIGHTHIT,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_ADDSHOT,10,0},
 {13,GAPPLY_SKILL_SUCCESS,SKILL_PUNCTUAL,10,0},
 //{14,"  ",25,DAY_EASTER,1,0x0002},			
 //{15,"   ",8,	5,1,0x0002},	
 //{16,"   ()",9,5,1,0x0002},
 //{17,"",40,DAY_EASTER,1,0x0002},
 //{18,"  ",48,DAY_EASTER,1,0x0002},	
 //{19," , 1 ",49,DAY_EASTER,1,0x0002},
 //{20," ,   ",50,DAY_EASTER,1,0x0002},
 //{21," , 3 ",51,DAY_EASTER,1,0x0002},
 //{22,"    ",25,5,1,0x0002},
 //{23,"   ",24,6,1,0x0002},
 //{24,"   ",29,6,1,0x0002},	
 //{25," ",20,7,1,0x0002},
 //{26,"   ",	1,8,1,0x0002},			
 //{27," ",6,8,1,0x0002},
 //{28,"   ",15,8,1,0x0002},	
 //{29,"   ",29,8,1,0x0002},
 //{30,"  ",8,9,1,0x0002},	
 //{31,"  ",14,9,1,0x0002},
 //{32,"  ",26,9,1,0x0002},	
 //{33," ",6,10,1,0x0002},
 //{34,"  ",13,11,1,0x0002},	
 //{35,"    ",21,11,1,0x0002},		
 //{36,"  ",30,11,1,0x0002},			
 //{37,"  ",6,12,1,0x0002},
 //{38," ",25,12,1,0x0002},	
	
 //{100,"",5,1,1,0x0002},
 {100,GAPPLY_MODIFIER,APPLY_HITREG,-10,0},
 {100,GAPPLY_MODIFIER,APPLY_MOVEREG,-10,0},
 {100,GAPPLY_MODIFIER,APPLY_MANAREG,-10,0},
 //{101,"",29,8,1,0x0002},
 //{102,"",27,9,1,0x0002},
 //{103,"",28,11,30,0x0002},
 //{104,"",1,1,7,0x0002},
 //{105,"",-49,DAY_EASTER,49,0x0002},
 //{106,"",14,8,28,0x0002},

 //{1001," ",1,1,7,0x0001},
 //{1002,"   ",6,1,1,0x0001},
 //{1003," ",27,2,1,0x0001},
 //{1004," ",29,2,1,0x0001},
 //{1005," ",1,3,1,0x0001},	
 //{1006," ",14,3,1,0x0001},
 //{1007," ",7,4,1,0x0001},
 //{1008," ",4,5,1,0x0001},	
 //{1009," ",6,5,1,0x0001},
 //{1010," ",22,5,1,0x0001},
 //{1011," ",31,5,1,0x0001},
 //{1012," ",21,6,1,0x0001},
 //{1013," ",1,7,7,0x0001},
 //{1014,"",9,7,1,0x0001},
 //{1015,"  ",27,7,1,0x0001},	
 //{1016," ",4,8,1,0x0001},
 {1016,GAPPLY_SPELL_EFFECT,SPELL_CALL_LIGHTNING,125,0},
 {1016,GAPPLY_SPELL_EFFECT,SPELL_CHAIN_LIGHTNING,125,0},
 {1016,GAPPLY_SPELL_EFFECT,SPELL_MAGIC_MISSILE,125,0},
 {1016,GAPPLY_SPELL_EFFECT,SPELL_LIGHTNING_BOLT,125,0},
 //{1017," ",8,8,1,0x0001},
 //{1018," ",21,8,1,0x0001},
 //{1019," ",28,8,1,0x0001},
 //{1020,"  ",14,9,1,0x0001},
 //{1021," ",29,10,1,0x0001},
 {1021,GAPPLY_MODIFIER,APPLY_HITREG,15,0},
 {1021,GAPPLY_MODIFIER,APPLY_MOVEREG,15,0},
 {1021,GAPPLY_MODIFIER,APPLY_MANAREG,15,0},
 //{1022," ",10,11,1,0x0001},	
 {1022,GAPPLY_MODIFIER,APPLY_MORALE,1,0},
 //{1023,"   ",26,11,1,0x0001},
 //{1024,"   ",9,12,1,0x0001},
 //{1025," ",25,12,1,0x0001},

 {0,0,0,0,0}
};

// 
cpp_extern const struct int_app_type int_app[] = {
//Ackn  SkUse  SpLv     SpCnt Impr Obser Maxkrug
  {0,   -10,	0,			10,	1,	-5,	400},		// int = 0 
  {1,	-10,	1,			14,	1,	-5,	400},	
  {2,	-9,		2,			18,	1,	-5,	400},
  {8,	-9,		8,			20,	1,	-4,	400},
  {16,	-9,		16,			21,	1,	-4,	400},
  {24,	-8,		24,			22,	1,	-3, 400},	
  {31,	-8,		31,			23,	1,	-2,	400},
  {38,	-7,		38,			24,	1,	-2,	400},
  {45,	-7,		45,			25,	2,	-1,	400},
  {51,	-6,		51,			28,	3,	-1,	300},
  {56,	-6,		56,			32,	5,	0,	200},		// int = 10
  {60,	-5,		60,			33,	7,	0,	150},
  {64,	-5,		63,			34,	10,	0,	120},
  {68,	-4,		65,			36,	14,	0,	100},
  {72,	-3,		67,			38,	19,	0,	85},
  {75,	-2,		69,			40,	24,	1,	74},	
  {77,	-1,		71,			45,	29,	1,	65},
  {78,	0,		73,			50,	34,	2,	59},
  {79,  0,		75,			60,	39,	2,	54},		
  {80,	1,		77,			70,	44,	3,	50},
  {81,	1,		79,			76,	50,	3,	46},		// int = 20 
  {82,	2,		81,			80,	50,	3,	42},
  {83,	3,		83,			82,	50,	4,	40},
  {84,	3,		85,			86,	50,	4,	38},
  {86,	4,		88,			90, 51,	4,	36},
  {88,	5,		91,			94,	51,	5,	34},		
  {90,	6,		95,			98,	51,	5,	33},
  {92,	6,		99,			99,	51,	5,	32},
  {95,	6,		104,		100,52,	6,  31},
  {98,	7,		109,		100,53,	6,	29},
  {101,	7,		115,		100,54,	7,	28},        // int = 30
  {104,	7,		121,		100,55,	7,	27},
  {107,	8,		127,		100,56,	7,	26},
  {110,	8,		134,		100,57,	7,	25},
  {113,	8,		141,		100,58,	7,	24},
  {116,	9,		149,		100,59,	8,	23},     
  {119,	9,		160,		100,60,	8,	22},
  {122,	9,		160,		100,61,	8,	21},
  {125,	9,		160,		100,62,	8,	20},
  {128,	10,		160,		100,63,	8,	19},
  {131,	10,		165,		100,64,	9,	18},        // int = 40
  {133,	10,		165,		100,65,	9,	17},
  {137,	10,		170,		100,66,	9,	16},
  {140,	11,		170,		100,67,	9,	15},
  {145,	11,		175,		100,68,	9,	14},
  {150,	11,		175,		100,69,	10,	13},     
  {155,	12,		180,		100,70,	11,	12},
  {160,	12,		180,		100,71,	12, 12},
  {165,	12,		190,		100,72,	13, 12},
  {170,	12,		190,		100,73,	14, 12},
  {180,	12,		200,		100,75,	15, 12}         // int = 50
};

/* str, int, wis, dex, con applies size************************************/
cpp_extern const struct weapon_app_type weapon_app[] = {
// Sho   Bash  Parrying
  {1 ,  -5,		-10},   /* ww = 0 */
  {1 ,	-4,		-10},	/* ww = 1 */
  {1 ,	-3,		-8},
  {1 ,	-2,		-6},
  {1 ,	-1,		-4},
  {1 ,	 0,		-2},	/* ww = 5 */
  {1 ,	 1, 		0},
  {1 ,	 2,		2},
  {1 ,	 3,		4},
  {1 ,	 4,		6},
  {1 ,	 5,		8},     /* ww = 10 */
  {1 ,	 6,		10},
  {1 ,	 7,		11},
  {2 ,	 8,		12},
  {2 ,	 9,		13},
  {3 ,	10,		15},	/* ww = 15 */
  {3 ,	12,		16},
  {4 ,	14,		17},
  {5 ,  16,		18},	/* ww = 18 */
  {6,	18,		19},
  {8,	20,		20},	/* ww = 20 */
  {10,	21,		21},
  {12,	22,		22},
  {14,	23,		23},
  {16,	24,		24},
  {18,	25,		25},	/* ww = 25 */
  {20,	26,		26},
  {21,	27,		27},
  {22,	28,		28},
  {23,	29,		29},
  {24,	30,		30},   	/* ww = 30 */
  {25,	31,		31},
  {26,	32,		32},
  {27,	33,		33},
  {28,	34,		34},
  {29,	35,		35},   	/* ww = 35 */
  {30,	36,		36},
  {31,	37,		37},
  {32,	38,		38},
  {33,	39,		39},
  {34,	40,		40},   	/* ww = 40 */
  {35,	41,		41},
  {36,	42,		42},
  {37,	43,		43},
  {38,	44,		44},
  {39,	45,		45},   	/* ww = 45 */
  {40,	46,		46},
  {41,	47,		47},
  {42,	48,		48},
  {43,	49,		49},
  {50,	50,		50}     	/* ww = 50 */
};

cpp_extern const struct size_app_type size_app[] = {
// AC inter init shoc
  {-5,	-100,5,	1},		/* size = 0 */
  {-5,  -80, 5,	1},		/* size = 1 */
  {-5, 	-62, 5,	1},
  {-5, 	-48, 4,	1},
  {-4, 	-39, 4,	2},
  {-4, 	-30, 4,	2},		/* size = 5 */
  {-4, 	-23, 4,	2},
  {-4, 	-17, 4,	2},
  {-3, 	-12, 3,	2},
  {-3, 	-9,  3,	3},
  {-3, 	-6,  3,	4},		/* size = 10 */
  {-3, 	-3,  3,	5},
  {-2, 	-1,  3,	6},
  {-2, 	 0,  2,	7},
  {-2, 	 0,  2,	8},
  {-1, 	 1,  2,	10},		/* size = 15 */
  {-1, 	 2,  2,	12},
  {-1, 	 3,  2, 14},
  {0, 	 4,  1,	16},		
  {0, 	 5,  1,	18},
  {0, 	 6,  1,	20},		/* size = 20 */
  {0, 	 7,  1,	22},
  {0, 	 9,  1,	23},
  {0, 	10,  0,	24},
  {0,  	11,  0,	24},
  {0,  	12,  0,	25},		/* size = 25 */
  {0,   14,  0,	25},	
  {0,   16,  0,	26},		
  {0,   18, -1,	26},		
  {0,   20, -1,	27},		
  {0,   22, -1,	27},		/* size = 30 */
  {1,   24, -1,	28},		
  {1,   26, -1,	28},		
  {1,   28, -2,	29},		
  {1,   30, -2,	29},		
  {1,   32, -2,	30},		/* size = 35 */
  {2,   34, -2,	30},	
  {2,   36, -2,	31},		
  {2,   38, -3,	31},		
  {3,   40, -3,	32},		
  {3,   43, -3,	32},		/* size = 40 */
  {3,   46, -3,	33},		
  {4,   49, -3,	33},		
  {4,   52, -4,	33},		
  {4,   55, -4,	34},		
  {5,   58, -4,	34},		/* size = 45 */
  {5,   61, -4,	34},	
  {5,   64, -4,	35},		
  {6,   67, -5,	35},		
  {6,   70, -5,	35},		
  {6,   73, -5,	36},		/* size = 50 */
  {7,   76, -5,	36},		
  {7,   79, -6,	36},		
  {7,   82, -6,	37},		
  {8,   85, -6,	37},		
  {8,   88, -7,	37},		/* size = 55 */
  {9,   91, -7,	38},	
  {9,   94, -7,	38},		
  {10,  97, -7,	39},		
  {10, 100, -8,	40},		
  {11, 105, -8,	41},		/* size = 60 */
  {11, 110, -8,	42},		
  {12, 115, -8,	43},		
  {12, 120, -9,	44},		
  {13, 125, -9,	45},		
  {14, 130, -9,	46},		/* size = 65 */
  {15, 135, -9,	47},	
  {16, 140, -9,	48},		
  {17, 145,-10,	49},		
  {18, 150,-10,	50},		
  {20, 150,-10,	50}		    /* size = 70 */
};
/* [ch] strength apply (all) */
/*    *///  12- +1  18  24 +2  +3 
cpp_extern const struct str_app_type str_app[] =
//  ToHit	ToDam	CarryW 	Wield	Held
{ {-10,		-20,		0,		0,		0},	/* str = 0 */
  {-10,		-10,		3,  	1, 		0},	
  {-10,		-7,			3,		2,		1},
  {-8,		-5, 		10,		3,		1},
  {-7,	 	-3,			25,		4,		2},
  {-6,		-2,			55,		5,		2},	/* str = 5 */
  {-5,		-1, 		80,   	6,		3},
  {-4,		-1,			90,		7,		3},
  {-3,		0,			100,	8,		4},
  {-2,		0,			100,	9,		4},
  {-1,		0,			115,	10,		6},	/* str = 10 */
  { 0,		0,			115,   	11,		6},
  { 0,		0, 			140,   	12,		7},
  { 1,		1,			140,	13,		7},
  {	1, 		1,			170,	14,		8},
  {	2, 		2,			170,   	15,		8},	/* str = 15 */
  {	2,		2, 			195,   	16,		9},
  {	3, 		3, 			220,   	17,		9},
  { 4,		4, 			255,   	18,		10},
  { 4, 		5, 			640,   	19,		11},
  { 6, 	    6,			700,   	20,		11},/* str = 20 */
  { 7, 		7,			810,   	21,		12},
  { 8, 		7,	 		970,  	22,		12},
  { 8, 		8,  		1130, 	23,		13},
  { 9, 		9,  		1440, 	24,		14},
  {10, 		11,  		1500, 	25,		14}, /* str = 25 */
  {12,  	13, 		1550, 	26,		15},
  {12, 		14, 		1600, 	27,		15},
  {13, 		15, 		1650, 	28,		16},
  {14, 		16, 		1700, 	29,		16},
  {14, 		18, 		1750, 	30,		17}, /* str = 30 */
  {15, 		20, 		1800, 	31,		18},
  {16, 		22, 		1820, 	32,		18},
  {17, 		23, 		1840, 	33,		19},
  {18, 		24, 		1860, 	34,		20},
  {18, 		26, 		1880, 	35,		21}, /* str = 35 */
  {19, 		28, 		1900, 	36,		22},
  {22, 		29, 		1920, 	37,		23},
  {24, 		31, 		1940, 	38,		24},
  {26, 		33, 		1960, 	39,		25},
  {28, 		34, 		1980, 	40,		26}, /* str = 40 */
  {30, 		35, 		2000, 	41,		27},
  {32, 		37, 		2020, 	42,		28},
  {34,  	39, 		2040, 	43,		29},
  {36, 		40, 		2060, 	44,		30},
  {38, 		44, 		2080, 	45,		31}, /* str = 45 */
  {40,		48, 		2090, 	46,		32},
  {42, 		52, 		2100, 	47,		33},
  {44, 		56, 		2130, 	48,		34},
  {46, 		60, 		2150, 	49,		35},
  {48, 		65, 		2200, 	50,		36}  /* str = 50 */
};



/* [dex]   (  ) */
cpp_extern const struct dex_skill_type dex_app_skill[] = {
  {-99, -99, -90, -99, -60},	/* dex = 0 */
  {-90, -90, -60, -90, -50},	/* dex = 1 */
  {-80, -80, -40, -80, -45},
  {-70, -70, -30, -70, -40},
  {-60, -60, -30, -60, -35},
  {-50, -50, -20, -50, -30},	/* dex = 5 */
  {-40, -40, -20, -40, -25},
  {-30, -30, -15, -30, -20},
  {-20, -20, -15, -20, -15},
  {-15, -10, -10, -20, -10},
  {-10, -5, -10, -15, -5},	/* dex = 10 */
  {-5, 0, -5, -10, 0},
  {0, 0, 0, -5, 0},
  {0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0},		/* dex = 15 */
  {0, 5, 0, 0, 0},
  {5, 10, 0, 5, 5},
  {10, 15, 5, 10, 10},		/* dex = 18 */
  {15, 20, 10, 15, 15},
  {15, 20, 10, 15, 15},		/* dex = 20 */
  {20, 25, 10, 15, 20},
  {20, 25, 15, 20, 20},
  {25, 25, 15, 20, 20},
  {26, 30, 15, 25, 25},
  {27, 30, 15, 26, 26},		/* dex = 25 */
  {28, 33, 18, 28, 28},
  {30, 35, 20, 30, 30},
  {32, 37, 22, 32, 32},
  {34, 39, 24, 34, 34},
  {36, 41, 26, 36, 36},
  {38, 43, 28, 38, 38},
  {40, 45, 30, 40, 40},
  {42, 47, 32, 42, 42},
  {44, 49, 34, 44, 44},
  {46, 51, 36, 46, 46},
  {48, 53, 38, 48, 48},
  {50, 55, 40, 50, 50},
  {52, 57, 42, 52, 52},
  {54, 59, 44, 54, 54},
  {56, 61, 46, 56, 56},
  {58, 63, 48, 58, 58},
  {60, 65, 50, 60, 60},
  {62, 67, 52, 62, 62},
  {64, 69, 54, 64, 64},
  {66, 71, 56, 66, 66},
  {68, 73, 58, 68, 68},
  {70, 75, 60, 70, 70},
  {72, 77, 62, 72, 72},
  {74, 79, 64, 74, 74},
  {80, 80, 65, 75, 78}		/* dex = 50 */

};



/* [dex] apply (all) *///  12  17  3,  21  2   1 
cpp_extern const struct dex_app_type dex_app[] = {
  {-7, -7, 6},		/* dex = 0 */
  {-6, -6, 5},		/* dex = 1 */
  {-4, -4, 5},
  {-3, -3, 4},
  {-2, -2, 3},
  {-1, -1, 2},		/* dex = 5 */
  {0,  0,  1},
  {0,  0,  0},
  {0,  0,  0},
  {0,  0,  0},
  {0,  0,  0},		/* dex = 10 */
  {0,  0,  0},
  {1,  1, -1},
  {1,  1, -1},
  {2,  1, -1},
  {2,  2, -2},		/* dex = 15 */
  {3,  2, -2},
  {4,  2, -2},
  {5,  3, -3},		/* dex = 18 */
  {7,  3, -3},
  {9,  4, -4},		/* dex = 20 */
  {11, 4, -4},
  {13, 5, -5},
  {15, 5, -5},
  {18, 6, -6},
  {21, 7, -7},		/* dex = 25 */
  {24, 8, -8},
  {27, 9, -9},		/* dex = 27 */
  {30, 10,-10},		/* dex = 28 */
  {33, 11,-11},
  {36, 12,-12},
  {39, 13,-13},
  {42, 14,-14},
  {45, 15,-15},		/* dex = 33 */
  {48, 16,-16},
  {51, 17,-17},		/* dex = 35 */
  {54, 18,-18},
  {57, 19,-19},		/* dex = 37 */
  {60, 20,-20},		/* dex = 38 */
  {63, 21,-21},
  {66, 22,-22},
  {69, 23,-23},
  {72, 24,-24},
  {75, 25,-25},		/* dex = 43 */
  {78, 26,-26},
  {81, 27,-27},		/* dex = 45 */
  {84, 28,-28},
  {87, 29,-29},
  {90, 30,-30},		/* dex = 48 */
  {95, 32,-32},
  {100,35,-35}		/* dex = 50 */
};


//* [con] apply (all) *///  -  12  , 18-23  +2   +3 
cpp_extern const struct con_app_type con_app[] =
// Hitp addhit AfSav    PsS CrS  Ress
{ {-4,	1 , 	4,		 5,	 1,	100	},		/* con = 0 */
  {-3,	2 , 	4,		 5,	 1,	100 },		/* con = 1 */
  {-3, 	5 ,	 	3,		 5,	 1, 90  },
  {-3, 	7 ,	 	3,		 5,	 1, 90  },
  {-3, 	7,	 	3,		 4,	 1, 80  },
  {-3, 	7,	 	2,		 4,	 1, 80  },		/* con = 5 */
  {-2, 	8,	 	2,		 3,	 1, 80  },
  {-2, 	8,	 	2,		 3,	 1, 75  },
  {-2, 	8,	 	1,		 2,	 1, 75  },
  {-2, 	9,	 	1,		 2,	 1, 60  },
  {-2, 	9,	 	0,		 1,	 1, 60  },		/* con = 10 */
  {-1, 	10,	 	0,		 1,	 1, 58  },
  {-1, 	10,	 	0,		 1,	 1, 56  },
  {-1, 	11,	 	0,		 0,	 2, 55  },
  {-1, 	12,	 	0,		 0,	 2, 53  },
  {1,  	13,	 	0,		 0,	 3, 51  },		/* con = 15 */
  {1,  	14,		-1,		 0,	 3, 50  },
  {1,  	15,		-1,		-1,	 4, 50  },
  {2,  	16,		-1,		-1,	 5, 50  },		/* con = 18 */
  {2,  	17,		-1,		-2,	 6, 48  },
  {3,  	19,		-2,		-3,	 8, 47  },		/* con = 20 */
  {3,  	21,		-2,		-4,	10, 47  },
  {3,  	23,		-2,		-5,	12, 47  },
  {3,  	25,		-2,		-6,	15, 46  },
  {4,  	27,		-3,		-7,	18, 46  },
  {4,  	29,		-3,		-8,	21, 45  },		/* con = 25 */
  {4,  	32,		-3,		-10,24, 45  },
  {4,  	35,		-4,		-12,27, 44  },
  {5,  	38,		-4,		-14,30, 44  },
  {5,  	41,		-4,		-17,33, 43  },
  {5,  	44,		-5,		-20,36, 43  },		/* con = 30 */
  {5,  	47,		-6,		-23,40, 42  },
  {5,  	50,		-7,		-26,44, 42  },
  {5,  	53,		-8,		-30,48, 41  },
  {5,  	56,		-9,		-34,52, 41  },
  {5,  	59,		-10,	-38,56, 40  },		/* con = 35 */
  {5,  	62,		-10,	-42,60, 39  },
  {5,  	65,		-10,	-46,65, 39  },
  {5,  	68,		-10,	-50,70, 38  },
  {5,  	71,		-10,	-55,75, 38  },
  {6,  	74,		-11,	-60,80, 37  },		/* con = 40 */
  {6,  	77,		-11,	-65,85, 37  },
  {6,  	80,		-11,	-70,90, 36  },
  {6,  	83,		-11,	-75,95, 36  },
  {6,  	86,		-11,	-80,100,35  },
  {6,  	89,		-12,	-85,110,35  },		/* con = 45 */
  {6,  	92,		-13,	-90,120,34  },
  {6,  	95,		-13,	-95,135,33  },
  {6,  	98,		-14,	-97,150,32  },
  {6,  	100,	-14,	-98,170,31  },
  {6,  	100,	-15,	-99,200,30  }		/* con = 50 */
};	

cpp_extern const struct weapon_affect_types weapon_affect[] =
{ 	{(0 | (1 << 0)),	0      	  ,SPELL_BLINDNESS},
  	{(0 | (1 << 1)),	AFF_INVISIBLE      	,0},
  	{(0 | (1 << 2)),	AFF_DETECT_ALIGN  	,0},
  	{(0 | (1 << 3)),	AFF_DETECT_INVIS	,0},
	{(0 | (1 << 4)),	AFF_DETECT_MAGIC	,0},
	{(0 | (1 << 5)),	AFF_SENSE_LIFE		,0},
	{(0 | (1 << 6)),	AFF_WATERWALK		,0},
	{(0 | (1 << 7)),	AFF_SANCTUARY		,0},
	{(0 | (1 << 8)),	AFF_CURSE		,0},
	{(0 | (1 << 9)),	AFF_INFRAVISION		,0},
	{(0 | (1 << 10)),	0	     ,SPELL_POISON},
	{(0 | (1 << 11)),	AFF_WATERBREATH		,0},
        {(0 | (1 << 12)),	0	      ,SPELL_ARMOR},
 	{(0 | (1 << 13)),	0	      ,SPELL_SLEEP},
	{(0 | (1 << 14)),	AFF_NOTRACK		,0},
	{(0 | (1 << 15)),	AFF_BLESS		,0},
	{(0 | (1 << 16)),	AFF_SNEAK		,0},
	{(0 | (1 << 17)),	AFF_HIDE		,0},
	{(0 | (1 << 18)),	0	        ,SPELL_HOLD},
	{(0 | (1 << 19)),	AFF_FLY			,0},
	{(0 | (1 << 20)),	AFF_SIELENCE		,0},
	{(0 | (1 << 21)),	AFF_AWARNESS		,0},
	{(0 | (1 << 22)),	AFF_BLINK		,0},
    	{(0 | (1 << 23)),	AFF_NOFLEE		,0},
    	{(0 | (1 << 24)),	AFF_SINGLELIGHT		,0},
	{(0 | (1 << 25)),	AFF_HOLYLIGHT		,0},
	{(0 | (1 << 26)),	AFF_HOLYDARK		,0},
	{(0 | (1 << 27)),	AFF_DETECT_POISON	,0},
	{(0 | (1 << 28)),	AFF_SLOW            	,0},
	{(0 | (1 << 29)),	AFF_HASTE           	,0},
  	{-1, -1, -1}    // Always last
};

struct extra_affects_type ClericAffects[] = //
{{-1,-1}};
struct obj_affected_type ClericModifiers[] =
{{APPLY_HITREG,50},
 {-1,-1}
};
struct extra_affects_type MageAffects[] = //
{{-1,-1}};
struct obj_affected_type MageModifiers[] =
{{APPLY_MANAREG,20},
 {-1,-1}
};
struct extra_affects_type ThiefAffects[] = //
{{-1,-1}};
struct obj_affected_type ThiefModifiers[] =
{{APPLY_HITROLL,1},
 {-1,-1}
};
struct extra_affects_type WarriorAffects[] = //
{{-1,-1}};
struct obj_affected_type WarriorModifiers[] =
{{-1,-1}};
struct extra_affects_type AssasineAffects[] = //
{{-1,-1}};
struct obj_affected_type AssasineModifiers[] =
{{APPLY_CAST_SUCCESS,25},
{-1,-1}};

struct extra_affects_type GuardAffects[] =  
{{-1,-1}};
struct obj_affected_type GuardModifiers[] =
{{APPLY_HITROLL,1},
 {-1,-1}
};
struct extra_affects_type DefenderAffects[] =
{{-1,-1}};
struct obj_affected_type DefenderModifiers[] =
{{APPLY_INT,1},
 {-1,-1}
};
struct extra_affects_type CharmerAffects[] = //
{{-1,-1}};
struct obj_affected_type CharmerModifiers[] =
{{-1,-1}};
struct extra_affects_type WedmakAffects[] = //
{{AFF_INFRAVISION,1},
 {AFF_SENSE_LIFE,1},
 {-1,-1}};
struct obj_affected_type WedmakModifiers[] =
{{APPLY_MANAREG,25},
 {-1,-1}
};

struct extra_affects_type PaladineAffects[] = //
{{-1,-1}};
struct obj_affected_type PaladineModifiers[] =
{{APPLY_MORALE,5},
 {APPLY_CAST_SUCCESS,25},
 {-1,-1}
};
struct extra_affects_type RangerAffects[] = //
{{-1,-1}};
struct obj_affected_type RangerModifiers[] =
{{APPLY_MOVEREG,50},
 {APPLY_DAMROLL,1},
{APPLY_HITROLL,1},
 {-1,-1}
};
struct extra_affects_type SmithAffects[] = //
{{-1,-1}};
struct obj_affected_type SmithModifiers[] =
{{APPLY_DAMROLL,2},
{-1,-1}};
struct extra_affects_type MerchantAffects[] =
{{-1,-1}};
struct obj_affected_type MerchantModifiers[] =
{{APPLY_MOVEREG,50},
 {APPLY_CAST_SUCCESS,15},
 {APPLY_HITREG,25},
 {-1,-1}
};
struct extra_affects_type DruidAffects[] = //
{{-1,-1}};
struct obj_affected_type DruidModifiers[] =
{{APPLY_HITREG,25},
 {APPLY_MOVEREG,25},
 {-1,-1}
};

cpp_extern const struct class_app_type class_app[NUM_CLASSES] =
{	{3,40,10,8,20,(struct extra_affects_type *)&ClericAffects,(struct obj_affected_type *)&ClericModifiers},	    //
	{3,33,10,5,20,(struct extra_affects_type *)&MageAffects,(struct obj_affected_type *)&MageModifiers},		    //	
	{4,50,10,12,25,(struct extra_affects_type *)&ThiefAffects,(struct obj_affected_type *)&ThiefModifiers},		    //
	{2,100,10,18,30,(struct extra_affects_type *)&WarriorAffects,(struct obj_affected_type *)&WarriorModifiers},    //		
	{3,50,10,12,25,(struct extra_affects_type *)&AssasineAffects,(struct obj_affected_type *)&AssasineModifiers},   //
	{2,100,10,16,28,(struct extra_affects_type *)&PaladineAffects,(struct obj_affected_type *)&PaladineModifiers},  //
	{1,100,10,16,28,(struct extra_affects_type *)&RangerAffects,(struct obj_affected_type *)&RangerModifiers},		//
	{3,33,10,8,20,(struct extra_affects_type *)&DruidAffects,(struct obj_affected_type *)&DruidModifiers},			//
	{3,75,10,14,26,(struct extra_affects_type *)&CharmerAffects,(struct obj_affected_type *)&CharmerModifiers},     //
	{2,100,10,16,28,(struct extra_affects_type *)&SmithAffects,(struct obj_affected_type *)&SmithModifiers},		//
	{3,33,10,5,20,(struct extra_affects_type *)&WedmakAffects,(struct obj_affected_type *)&WedmakModifiers}			//
 
 // {2,100,10,17,30,(struct extra_affects_type *)&GuardAffects,(struct obj_affected_type *)&GuardModifiers},
 // {5,33,10,5,20,(struct extra_affects_type *)&DefenderAffects,(struct obj_affected_type *)&DefenderModifiers},
  /*{2,100,10,16,28,(struct extra_affects_type *)&RangerAffects,(struct obj_affected_type *)&RangerModifiers},
	{2,100,10,16,28,(struct extra_affects_type *)&SmithAffects,(struct obj_affected_type *)&SmithModifiers},
	{3,50,10,15,25,(struct extra_affects_type *)&MerchantAffects,(struct obj_affected_type *)&MerchantModifiers},
  */
};

struct extra_affects_type HumanAffects[] =
{{-1,-1}};
struct obj_affected_type HumanModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type ElfAffects[] =
{{-1,-1}};
struct obj_affected_type ElfModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type GnomeAffects[] =
{{AFF_INFRAVISION,1},
 {-1,-1}};
struct obj_affected_type GnomeModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type DwarfAffects[] =
{{-1,-1}};
struct obj_affected_type DwarfModifiers[] =
{{-1,-1}};
struct extra_affects_type HobbitAffects[] =
{{-1,-1}};
struct obj_affected_type HobbitModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type PoluelfAffects[] =
{{-1,-1}};
struct obj_affected_type PoluelfModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type OgrAffects[] = //
{{-1,-1}};
struct obj_affected_type OgrModifiers[] =
{{-1,-1},
{-1,-1}};
struct extra_affects_type LesElfAffects[] =
{{AFF_INFRAVISION,1},
 {-1,-1}};
struct obj_affected_type LesElfModifiers[] =
{{-1,-1},
{-1,-1}};

//  (       )
cpp_extern const struct race_app_type race_app[NUM_RACES] =
{ {(struct extra_affects_type *)&HumanAffects,(struct obj_affected_type *)&HumanModifiers},
  {(struct extra_affects_type *)&ElfAffects,(struct obj_affected_type *)&ElfModifiers},
  {(struct extra_affects_type *)&GnomeAffects,(struct obj_affected_type *)&GnomeModifiers},
  {(struct extra_affects_type *)&DwarfAffects,(struct obj_affected_type *)&DwarfModifiers},
  {(struct extra_affects_type *)&HobbitAffects,(struct obj_affected_type *)&HobbitModifiers},
  {(struct extra_affects_type *)&PoluelfAffects,(struct obj_affected_type *)&PoluelfModifiers},
{(struct extra_affects_type *)&OgrAffects,(struct obj_affected_type *)&OgrModifiers},
  {(struct extra_affects_type *)&LesElfAffects,(struct obj_affected_type *)&LesElfModifiers}
};


cpp_extern const struct cha_app_type cha_app[] = {
// Lead Chrm Mr Illu
  {-6,50, 	0,-6},		/* size = 0 */
  {-6,70,	0,-6},		/* size = 1 */
  {-6,90,	0,-6},
  {-6,100,  0,-5},
  {-5,120,  1,-5},
  {-4,140,  1,-4},		/* size = 5 */
  {-3,160,  1,-4},
  {-2,180,  1,-4},
  {-1,200,  2,-3},
  { 0,220,  2,-3},
  { 0,260,  2,-2},		/* size = 10 */
  { 1,300,  3,-2},
  { 2,340,  3,-1},
  { 3,380,  3,-1},
  { 4,420,  4,	0},
  { 5,460,  4,	0},		/* size = 15 */
  { 5,500,  5,	1},
  { 6,550,  5,	3},
  { 6,600,  6,	5},		
  { 7,650,  7,	7},
  { 7,700,  8,	9},		/* size = 20 */
  {	8,800,  9,11},
  {	8,840,  11,12},
  {	9,880,  13,13},
  {	9,920,  15,14},
  {10,960,  17,15},		/* size = 25 */
  {11,1000,  20,16},	
  {12,1200,  23,17},		
  {13,1400,  26,18},		
  {14,1600,  29,19},		
  {15,1800,  32,20},		/* size = 30 */
  {16,2000,  35,21},		
  {17,2100,  39,22},		
  {18,2200,  43,23},		
  {19,2300,  47,24},		
  {20,2400,  51,25},		/* size = 35 */
  {21,2500,  55,26},	
  {22,2600,  59,27},		
  {23,2700,  63,28},		
  {24,2800,  67,29},		
  {25,2900,  71,30},		/* size = 40 */
  {26,3000,  75,31},		
  {27,3100,  79,32},		
  {28,3200,  83,33},		
  {29,3300,  87,34},		
  {30,3400,  91,35},		/* size = 45 */
  {32,3500,  95,36},	
  {34,3600,  99,37},		
  {36,3700,  103,38},		
  {38,3900,  107,39},		
  {48,4000,  110,40}		/* size = 50 */
};

cpp_extern const struct wis_app_type wis_app[] = {

 //	M20  SpScss      ChSav   MxSk
  {0,	-50,		3,	1,	0,	-100},	 /* wis = 0 */
  {20,	-40,		3,	2,	0,	-100},  /* wis = 1 */
  {24,	-34,		3,	3,	0,	-100},
  {28,	-28,		3,	4,	0,	-100},
  {32,	-23,		3,	5,	0,	-100},
  {36,	-19,		2,	6,	0,	-100},  /* wis = 5 */
  {40,	-15,		2,	7,	0,	-90},
  {45,	-12,		2,	8,	0,	-80},
  {50,	-9,		1,	9,	0,	-71},
  {55,	-6,		1,	10,	0,	-63},
  {65,	-3,		1,	11,	0,	-56},  /* wis = 10 */
  {67,	0,		0,	12,	0,	-50},
  {69,	2,		0,	13,	0,	-45},
  {71,	4,		0,	14,	0,	-40},
  {73,	6,		-1,	15,	1,	-30},
  {75,	8,		-1,	16,	1,	-15},  /* wis = 15 */
  {77,	10,		-2,	16,	2,	0},
  {79,	12,		-2,	17,	3,	2},
  {81,	15,		-3,	17,	5,	5},  /* wis = 18 */
  {83,	18,		-3,	18,	7,	9},
  {85,	21,		-4,	18,	9,	14},  /* wis = 20 */
  {87,	24,		-5,	19,	12,	20},
  {89,	28,		-7,	19,	16,	27},
  {91,	32,		-10,	20,	21,	35},
  {93,	36,		-13,	20,	26,	44},
  {95,  40,		-17,	21,	32,	54},  /* wis = 25 */
  {97,  44,		-21,	22,	38,	65},
  {99,  48,		-25,	23,	45,	76},
  {100, 52,		-29,	24,	53,	88},
  {100, 56,		-33,	25,	61,	100},
  {100, 60,		-37,	26,	70,	100}, /* wis = 30 */
  {100, 64,		-41,	26,	80,	100},
  {100, 68,		-45,	27,	90,	100},
  {100, 72,		-49,	27,	100,	100},
  {100, 76,		-43,	28,	115,	100},
  {100, 80,		-47,	28,	130,	100}, /* wis = 35 */
  {100, 84,		-51,	29,	150,	100},
  {100, 88,		-55,	29,	155,	100},
  {100, 92,		-60,	30,	160,	100},
  {100, 96,		-65,	30,	165,	100},
  {100, 100,		-70,	31,	170,	100}, /* wis = 40 */
  {100, 105,		-75,	31,	175,	100},
  {100, 110,		-80,	32,	180,	100},
  {100, 115,		-85,	32,	185,	100},
  {100, 120,		-90,	33,	190,	100},
  {100, 125,		-95,	33,	195,	100}, /* wis = 45 */
  {100, 130,		-100,	34,	196,	100},
  {100, 135,		-105,	34,	197,	100},
  {100, 140,		-110,	35,	198,	100},
  {100, 145,		-115,	35,	199,	100},
  {100, 150,		-120,	36,	200,	100} /* wis = 50 */
};


const char *spell_wear_off_msg[LAST_USED_SPELL+1] = {
  "RESERVED DB.C",														// 0 
  "    .",	
  "!!",
  "    .",
  " !", 
  "! !",														// 5 
  "! .", 
  "    .",
  " ,      .",
  "!!",
  "! ,      !",
  "! !",
  "! !",
  "! !",
  "! !",
  "! !",											// 15 
  "! !",
  "   .",
  "     .",
  "     .",
  "     .",						// 20 
  "     .",
  "! !",
  "!!",
  "! !",
  "!!",															// 25 
  "! !",
  "!!",
  "!!",
  "   .", 
  "! !",														// 30 
  "!!",
  "! !",
  "      .",
  "      .",
  "! !",													// 35 
  "     .",
  "! !",
  "    .",
  "    .",
  "!!",															// 40
  "!Ventriloquate!",
  "!!",
  "! !",
  "     .",
  "! !",	
  "!!",
  "! !",
  "! !",
  "! !",
  "      .",								// 50 
  "      .",
  "!SPELL CURE SERIOUS!",
  "!SPELL GROUP STRENGTH!",
  "   .",
  "   .",
  "!SPELL MASS HOLD!",
  "   .",
  "   .",
  "      .",
  "!SPELL CREATE LIGHT!",												// 60 
  "   .",
  "     .",
  "     .",
  "    .",
  "   .", 
  "!SPELL CHAIN LIGHTNING!",
  "!SPELL FIREBLAST!",
  "!SPELL IMPLOSION!",
  "   .",
  "!SPELL GROUP INVISIBLE!",											// 70 
  "     .",
  "!SPELL ACID!",
  "!SPELL REPAIR!",
  "   .",
  "!SPELL FEAR!",                 
  "!SPELL SACRIFICE!",
  " ,  , .",
  "  .",
  "!SPELL REMOVE HOLD!",
  "      .",								// 80 
  " !",
  "!SPELL MASS BLINDNESS!",
  "!SPELL POWER SIELENCE!",
  "!SPELL EXTRA HITS!",
  "!SPELL RESSURECTION!", 
  "!SPELL PROLONGATION!",
  "!SPELL FORBIDDEN!",
  "!SPELL MASS SIELENCE!",
  "!SPELL REMOVE SIELENCE!",
  "!SPELL DAMAGE LIGHT!",												// 90 
  "!SPELL DAMAGE SERIOUS!",
  "!SPELL DAMAGE CRITIC!",
  "!SPELL MASS CURSE!",
  "!SPELL ARMAGEDDON!",
  "!SPELL GROUP FLY!",
   "    .",
 // "!SPELL GROUP BLESS!",
  "!SPELL REFRESH!",
  "!SPELL STUNNING!",
  "   .",
  "   .",									// 100 
  "      -   .",
  " -,  !",
  "!SPELL FULL!",
  "!CONE OF HOLD!",
  "     .", 
  "   .",
  "   .",//
  "    .",
  " .",
  "   .",										// 110 
  "!SPELL MASS SLOW!",
   "   .", 
// "!SPELL MASS HASTE!",
  "     .",
  "   .",
  "!SPELL CURE PLAQUE!",					
  "   .",
  "   .",
  "    .", 
  "!PORTAL!",
  "!DISPELL MAGIC!",													// 120 					
  "!SUMMON KEEPER!",	
  "   .",
  "!CREATE WEAPON!",
  "     .",
  "!RELOCATE!", 	
  "!SUMMON FIREKEEPER!",
  "     .",
  "!ICESTORM!",
  "    .",
  "!SHINE LIGHT!",														// 130 
  "   .",
  "      .",
  "  c .",
  "!VACUUM!",
  "!METEOR STORM!",
  "     .",
  "  .",
  "    .",
  "   .",
  "    .",									// 140
  "    .",
  "    .",
  "   .",
  "   .",
  "     .",
  "      .",
  "      .",
  "   .",
  "   !",
  "    !",										// 150  
  "!SPELL_GROUP_REFRESH",
  "    .",
  "      ."
  };



const char *npc_class_types[] = {
  "", 
  "",
  "",
  "",
  "",
  "",
  " ",
  "-",
  "-",
  "-",
  "-",
  "-",
  "-",
  "- ",
  "-",
  "-",
  "-",
  "-",
  "-",
  "-",
  "- ",
  
  "\n"
};

const char *npc_race_types[] = {
  " ",
  "",
  " ",
  ""
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "\n"
};


int rev_dir[] =
{
  2,
  3,
  0,
  1,
  5,
  4
};


int movement_loss[] =
{
  1,	/*       */
  1,	/*         */
  2,	/*  */
  3,	/* 		    */
  4,	/*         */
  6,	/* 		    */
  4,	/*         */
  1,	/* Unswimable   */
  1,    /* 		*/
  5,	/*      */
  1,    /*      */ 
  0,0,0,0,0,0,0,0,0,
  3,    /* Field snow */
  4,    /* Field water */
  4,    /* Forest snow */
  5,    /* Forest water */
  5,    /* Hills snow */
  6,    /* Hills water */
  8,    /* Mountains snow */
  2,    /* THIN ice */
  2,    /* NORMAL ice */
  2
};

const char *weekdays[] = {
  " ",
  " ",
  " ",
  " ",
  " ",
  "  ",
  " "
};


/* Not used in sprinttype(). */
const char *month_name[] = {
  " ",		/* 0 */
  "  ",
  "  ",
  "  ",
  "  ",
  " ",
  " ",
  "  ",
  " ",
  " ",
  " ",
  "  ",
  "  ",
  " ",
  "  ",
  "  ",
  "  "
};

const char *weekdays_poly[] =
{ "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  ""
};

const char *month_name_poly[] =
{ " -      ",		
  " -    ",
  " -   ",
  " -    ",
  " -  ",
  " -    ",
  " -  ",
  " -   ",
  " -   "
};
