# -*- coding: windows-1251

#copyright (C) 2016Aleksey Sadovoy <lex@progger.ru>

"""      .
       :
#action {^*       ANYKEY  ENTER} {#autologging.start}
#action {^} {#autologging.start}
#action {^     ,     !} {#autologging.start}
#action {^    .} {#autologging.stop}

    #autologging.start    ,      .
"""

import os
import time
from lyntin import exported
from lyntin.modules import modutils

commands = {}
def start_cmd(ses, args, input):
    """      logs/---.log
       name,       .
    :
    #autologging.start 
        logs/-2016-01-11.log
    category: commands
    """
    if args['name']:
        s = args['name']
    else:
        s = ses.getName()
    s += "-%s.log" % time.strftime("%Y-%m-%d")
    try:
        if not os.path.isdir('logs'):
            os.makedirs('logs')
    except Exception, e:
        exported.write_error("    : %s" % e, ses)
        return
    lm = exported.get_manager("logger")
    loggerdata = lm.getLogData(ses)
    if loggerdata.isLogging() == 1:
        exported.write_error("  .")
        return
    logfile = os.path.join('logs', s)
    loggerdata.openLogFile(logfile, 1, '')
    loggerdata.log("Logging started at %s\n" % time.asctime())
    exported.write_message("   %s" % logfile)
commands['autologging.start'] = (start_cmd, 'name=')

def stop_cmd(ses, args, input):
    """   .
    category: commands
    """
    lm = exported.get_manager("logger")
    loggerdata = lm.getLogData(ses)
    if loggerdata.isLogging() != 1:
        exported.write_error("    .")
        return
    loggerdata.closeLogFile()
    exported.write_message("  .")
commands['autologging.stop'] = (stop_cmd, "")

def load():
    modutils.load_commands(commands)

def unload():
    modutils.unload_commands(commands)
