/* Autoconf patching by David Hedbor, neotron@lysator.liu.se */
/*********************************************************************/
/* file: misc.c - misc commands                                      */
/*                             TINTIN III                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*********************************************************************/
#include "stdafx.h"
#include "ttcoreex.h"
#include "tintin.h"
#include "JmcObj.h"


//-------------------------



/****************************/
/* the cr command           */
/****************************/
void cr_command(void)
{
    write_line_mud("\n");
}

/****************************/
/* the verbatim command,    */
/* used as a toggle         */
/****************************/
void verbatim_command(char * arg)
{
    char flag[BUFFER_SIZE];

    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        verbatim=!verbatim;
    else {
        if ( !strcmpi(flag, "on" ) )
            verbatim = TRUE;
        else 
            verbatim = FALSE;
    }

    if (verbatim) 
        tintin_puts2(rs::rs(1095));
    else 
        tintin_puts2(rs::rs(1096)); 
}


/*********************/
/* the #bell command */
/*********************/
void bell_command(void)
{
    MessageBeep(MB_OK);
}



/*********************/
/* the #char command */
/*********************/
void char_command(char *arg)
{
    char strng[80];
    get_arg_in_braces(arg, arg,1);
/*  if(ispunct(*arg)) {
    cCommandChar= *arg;
    sprintf(strng, rs::rs(1098), cCommandChar);
    tintin_puts2(strng);
  }
  else
    tintin_puts2("#SPECIFY A PROPER COMMAND-CHAR! SOMETHING LIKE # OR /!");
*/
    cCommandChar= *arg;
    sprintf(strng, rs::rs(1098), cCommandChar);
    tintin_puts2(strng);
}


/*********************/
/* the #echo command */
/*********************/
void echo_command(char* arg)
{
    char flag[BUFFER_SIZE];
    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        echo=!echo;
    else {
        if ( !strcmpi(flag, "on" ) )
            echo= TRUE;
        else 
            echo= FALSE;
    }
  
    if(echo)
        tintin_puts2(rs::rs(1099));
    else
        tintin_puts2(rs::rs(1100));
}


/***********************/
/* the #ignore command */
/***********************/
void ignore_command(char* arg)
{
    char flag[BUFFER_SIZE];
    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        ignore=!ignore;
    else {
        if ( !strcmpi(flag, "on" ) )
            ignore = TRUE;
        else 
            ignore = FALSE;
    }

    if(ignore)
      tintin_puts2(rs::rs(1101));
    else
      tintin_puts2(rs::rs(1102));
}

/**********************/
/* the #presub command*/
/**********************/
void presub_command(char* arg)
{
    char flag[BUFFER_SIZE];
    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        presub=!presub;
    else {
        if ( !strcmpi(flag, "on" ) )
            presub= TRUE;
        else 
            presub= FALSE;
    }
  
    if(presub)
        tintin_puts2(rs::rs(1103));
    else
        tintin_puts2(rs::rs(1104));
}

/**************************/
/* the #togglesubs command*/
/**************************/
void togglesubs_command(char* arg)
{
    char flag[BUFFER_SIZE];
    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        togglesubs=!togglesubs;
    else {
        if ( !strcmpi(flag, "on" ) )
            togglesubs = TRUE;
        else 
            togglesubs = FALSE;
    }
    
    if(togglesubs)
        tintin_puts2(rs::rs(1105));
    else 
        tintin_puts2(rs::rs(1106));
}

/***********************/
/* the #showme command */
/***********************/
void showme_command(char *arg)
{ 
    char left[BUFFER_SIZE], right[BUFFER_SIZE];
    char result[BUFFER_SIZE], strng[BUFFER_SIZE];
    
    arg=get_arg_in_braces(arg, left, 1);
    arg=get_arg_in_braces(arg, right, 1);

    if ( !right[0] ) {  // no colors
        prepare_actionalias(left,strng); 
    } else {
        prepare_actionalias(right,result); 
        add_codes(result, strng, left);
    }
    
    tintin_puts2(strng);
}
/***********************/
/* the #loop command   */
/***********************/
void loop_command(char* arg)
{
  char left[BUFFER_SIZE],right[BUFFER_SIZE];
  char result[BUFFER_SIZE];
  int flag, bound1, bound2, counter;
  arg=get_arg_in_braces(arg,left,0);
  arg=get_arg_in_braces(arg,right,1);
  flag =1;
  if (sscanf(left,"%d,%d",&bound1,&bound2)!=2) 
    tintin_puts2(rs::rs(1107));
  else {
    flag=1;
    counter=bound1;
    while(flag==1) {
      sprintf(vars[0], "%d", counter);
      substitute_vars(right,result);
      parse_input(result);
      if (bound1<bound2) {
        counter++;
        if (counter>bound2)
          flag=0;
      }
      else {
        counter--;
        if (counter<bound2)
          flag=0;
      }
    } 
  }  
}
/************************/
/* the #message command */
/************************/
void message_command(char *arg)
{
  int mestype;
  char ms[8][20], tpstr[80];
    char type[BUFFER_SIZE], flag[BUFFER_SIZE];

  arg = get_arg_in_braces(arg,type,0);
  arg = get_arg_in_braces(arg,flag,0);


  sscanf("aliases actions substitutes antisubstitutes highlights variables groups hotkeys",
    "%s %s %s %s %s %s %s %s",ms[0],ms[1],ms[2],ms[3],ms[4],ms[5],ms[6], ms[7]);
  
  
  mestype=0;
  while (!is_abrev(type,ms[mestype]) && mestype< sizeof(mesvar)/sizeof(int) ) 
    mestype++;
  if (mestype==sizeof(mesvar)/sizeof(int))
    tintin_puts2(rs::rs(1108));
  else {
      if ( !*flag ) 
            mesvar[mestype]=!mesvar[mestype];
      else 
          if ( !strcmp(flag , "on" ) )
              mesvar[mestype]=1;
          else 
              mesvar[mestype]=0;
    char* t1 = new char[16];
    strcpy(t1, mesvar[mestype] ? rs::rs(1125) : rs::rs(1126));
    
    sprintf(tpstr,rs::rs(1109),
        ms[mestype],t1);
    delete[]t1;
    tintin_puts2(tpstr);
  }
}

/**************************/
/* the #speedwalk command */
/**************************/
void speedwalk_command(char* arg)
{
    char flag[BUFFER_SIZE];
    arg = get_arg_in_braces(arg,flag,STOP_SPACES);

    if ( *flag == 0 ) 
        speedwalk=!speedwalk;
    else {
        if ( !strcmpi(flag, "on" ) )
            speedwalk = TRUE;
        else 
            speedwalk = FALSE;
    }
    
    if(speedwalk)
        tintin_puts2(rs::rs(1112));
    else
        tintin_puts2(rs::rs(1113));
}


/********************/
/* the #zap command */
/********************/
void zap_command(void)
{
    if ( WaitForSingleObject(hConnThread , 0 ) == WAIT_TIMEOUT ) {
        TerminateThread(hConnThread, 0);
        CloseHandle(hConnThread);
        tintin_puts2(rs::rs(1114));
        MUDSocket = NULL;
        return;
    }
    if ( MUDSocket == NULL ) {
        tintin_puts2(rs::rs(1115));
        return;
    }
    
    cleanup_session();
  
    tintin_puts2(rs::rs(1116));
    pJmcObj->Fire_Disconnected();
    // newactive_session();
    return ;
}


void display_info(void)
{
     char buf[BUFFER_SIZE];
     int actions=0;
     int aliases=0;
     int vars=0;
     int subs=0;
     int antisubs=0;
     // int ignore;

    actions=ActionList.size();
    aliases=AliasList.size();
    subs=count_list(common_subs);
    antisubs=count_list(common_antisubs);
    vars=VarList.size ();
    

    tintin_puts2(rs::rs(1117));
    sprintf(buf,rs::rs(1118), actions);
    tintin_puts2(buf);
    sprintf(buf,rs::rs(1119), aliases);
    tintin_puts2(buf);
    sprintf(buf,rs::rs(1120), subs);
    tintin_puts2(buf);
    sprintf(buf,rs::rs(1121),antisubs);
    tintin_puts2(buf);
    sprintf(buf,rs::rs(1122), vars);
    tintin_puts2(buf);
    sprintf(buf,rs::rs(1123), HlightList.size());
    tintin_puts2(buf);
    char* t1 = new char[16];
    char* t2 = new char[16];
    strcpy(t1, echo ? rs::rs(1125) : rs::rs(1126));
    strcpy(t2, speedwalk ? rs::rs(1125) : rs::rs(1126));
    sprintf(buf,rs::rs(1124), t1 , t2);
    tintin_puts2(buf);
    
    char* t3 = new char[16];
    strcpy(t1, togglesubs ? rs::rs(1125) : rs::rs(1126));
    strcpy(t2, ignore ? rs::rs(1125) : rs::rs(1126));
    strcpy(t3, presub ? rs::rs(1125) : rs::rs(1126));
    sprintf(buf,rs::rs(1129), t1, t2, t3);
    tintin_puts2(buf);
    delete[]t1;
    delete[]t2;
    delete[]t3;
}

// format #status N {text} [{color}]
void status_command(char* arg)
{
    char left[BUFFER_SIZE], right[BUFFER_SIZE], color[BUFFER_SIZE];
    
    arg=get_arg_in_braces(arg, left, 0);
    arg=get_arg_in_braces(arg, right, 1);
    arg=get_arg_in_braces(arg, color, 1);

    if ( !*left || !isdigit(*left) ) {
        tintin_puts2(rs::rs(1136));
        return;
    }

    int statNum = atoi(left);
    if ( statNum < 1 || statNum > 3 ) {
        tintin_puts2(rs::rs(1137));
        return;
    }

    char* dest = strInfo1;
    switch ( statNum ) {
    case 1:
        dest = strInfo1;
        break;
    case 2:
        dest = strInfo2;
        break;
    case 3:
        dest = strInfo3;
        break;
    default:
        break;
    };

    char buff[BUFFER_SIZE];
    substitute_myvars (right, buff);

    EnterCriticalSection(&secStatusSection);
    if ( *color ) {
        add_codes(buff, dest, color, FALSE);
        strcat(dest, buff);
    } else 
        strcpy(dest, buff);
    LeaveCriticalSection(&secStatusSection);
}

void tabadd_command(char* arg)
{
    char word[BUFFER_SIZE];
    get_arg_in_braces(arg, word, STOP_SPACES);
    if ( !*word ) {
        tintin_puts2(rs::rs(1138));
        return;
    }

    HGLOBAL hg = GlobalAlloc(GHND, strlen(word)+2);
    char* p = (char*)GlobalLock(hg);
    strcpy(p, word);
    GlobalUnlock (hg);

    PostMessage(hwndMAIN, WM_USER+200, 0, (LPARAM)hg);
    char msg[BUFFER_SIZE];
    sprintf(msg,rs::rs(1139), word);
    tintin_puts(msg);

}

void tabdel_command(char* arg)
{
    char word[BUFFER_SIZE];
    get_arg_in_braces(arg, word, STOP_SPACES);
    if ( !*word ) {
        tintin_puts2(rs::rs(1140));
        return;
    }

    HGLOBAL hg = GlobalAlloc(GHND, strlen(word)+2);
    char* p = (char*)GlobalLock(hg);
    strcpy(p, word);
    GlobalUnlock (hg);

    PostMessage(hwndMAIN, WM_USER+201, 0, (LPARAM)hg);
    char msg[BUFFER_SIZE];
    sprintf(msg,rs::rs(1141), word);
    tintin_puts(msg);
}

