/* Autoconf patching by David Hedbor, neotron@lysator.liu.se */

/*********************************************************************/
/* file: text.c  - funtions for logfile and reading/writing comfiles */
/*                             TINTIN + +                            */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                     coded by peter unold 1992                     */
/*                    New code by Joann Ellsworth                    */
/*********************************************************************/
#include "stdafx.h"
#include "tintin.h"

extern char *get_arg_in_braces();
/**********************************/
/* load a file for input to mud.  */
/**********************************/
void read_file(char *arg)
{
  FILE *myfile;
  char buffer[BUFFER_SIZE], *cptr;
  get_arg_in_braces(arg, arg, 1);

  if ( !arg || !*arg ) {
	  tintin_puts2(rs::rs(1173));
	  return;
  }


  if((myfile=fopen(arg, "r"))==NULL) {
    char buff[MAX_PATH];
    sprintf (buff, rs::rs(1174), arg);
    tintin_puts2(buff);
    return;
  }
  while(fgets(buffer, sizeof(buffer), myfile)) {
    for(cptr=buffer; *cptr && *cptr!='\n'; cptr++);
    *cptr='\0';
    write_line_mud(buffer);
  }
  fclose(myfile);
  tintin_puts2(rs::rs(1175));
}
