/**
\file do_offtop.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 23.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"
#include "gameplay/communication/offtop.h"
#include "gameplay/communication/spam.h"
#include "engine/ui/color.h"
#include "gameplay/communication/remember.h"

void do_offtop(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() || GetRealLevel(ch) >= kLvlImmortal || ch->IsFlagged(EPrf::kStopOfftop)) {
		SendMsgToChar("?\r\n", ch);
		return;
	}

	if (ch->IsFlagged(EPlrFlag::kDumbed) || ch->IsFlagged(EPlrFlag::kMuted)) {
		SendMsgToChar("     !\r\n", ch);
		return;
	}
	//if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kSoundproof) || ROOM_FLAGGED(ch->in_room, ERoomFlag::kTribune))
	if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kSoundproof)) {
		SendMsgToChar(SOUNDPROOF, ch);
		return;
	}
	if (GetRealLevel(ch) < offtop_system::kMinOfftopLvl && !GetRealRemort(ch)) {
		SendMsgToChar(ch, "     %d ,    .\r\n",
					  offtop_system::kMinOfftopLvl);
		return;
	}
	if (!ch->IsFlagged(EPrf::kOfftopMode)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	skip_spaces(&argument);
	if (!*argument) {
		SendMsgToChar(ch, "  ,    .");
		return;
	}
	utils::ConvertToLow(argument);
	if (!strcmp(ch->get_last_tell().c_str(), argument)) {
		SendMsgToChar("      !?!\r\n", ch);
		return;
	}
	//             
	if (!antispam::check(ch, antispam::kOfftopMode)) {
		return;
	}
	ch->set_last_tell(argument);
	if (ch->IsFlagged(EPlrFlag::kSpamer)) //   ,   :)
		return;
	snprintf(buf, kMaxStringLength, "[] %s : '%s'\r\n", GET_NAME(ch), argument);
	snprintf(buf1, kMaxStringLength, "&c%s&n", buf);
	for (DescriptorData *i = descriptor_list; i; i = i->next) {
		//           ...
		//   ,  ?   34-!    -  ...
		if (STATE(i) == CON_PLAYING
			&& i->character
//   , 
//			&& (GetRealLevel(i->character) < kLvlImmortal || IS_IMPL(i->character))
			&& i->character->IsFlagged(EPrf::kOfftopMode)
			&& !i->character->IsFlagged(EPrf::kStopOfftop)
			&& !ignores(i->character.get(), ch, EIgnore::kOfftop)) {
			SendMsgToChar(i->character.get(), "%s%s%s", kColorCyn, buf, kColorNrm);
			i->character->remember_add(buf1, Remember::ALL);
		}
	}
	ch->remember_add(buf1, Remember::OFFTOP);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
