/**
\file do_stand.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 24.09.2024.
\brief Brief description.
\detail Detail description.
*/

#include "engine/entities/char_data.h"

void do_stand(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->GetPosition() > EPosition::kSleep && AFF_FLAGGED(ch, EAffect::kSleep)) {
		SendMsgToChar("       .\r\n", ch);
		act("$n  $a  $a   .", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
		ch->SetPosition(EPosition::kSleep);
	}

	if (ch->IsOnHorse()) {
		act(" ,     $N1.", false, ch, nullptr, ch->get_horse(), kToChar);
		return;
	}
	switch (ch->GetPosition()) {
		case EPosition::kStand: SendMsgToChar("   .\r\n", ch);
			break;
		case EPosition::kSit: SendMsgToChar(" .\r\n", ch);
			act("$n $u.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			// Will be sitting after a successful bash and may still be fighting.
			ch->GetEnemy() ? ch->SetPosition(EPosition::kFight) : ch->SetPosition(EPosition::kStand);
			break;
		case EPosition::kRest: SendMsgToChar("    .\r\n", ch);
			act("$n $g   $u.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->GetEnemy() ? ch->SetPosition(EPosition::kFight) : ch->SetPosition(EPosition::kStand);
			break;
		case EPosition::kSleep: SendMsgToChar(",   !\r\n", ch);
			break;
		case EPosition::kFight: SendMsgToChar("  ?  - .\r\n", ch);
			break;
		default: SendMsgToChar("       .\r\n", ch);
			act("$n $u  .", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
			ch->SetPosition(EPosition::kStand);
			break;
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
