//
// Created by Sventovit on 07.09.2024.
//

#include "engine/entities/char_data.h"
#include "gameplay/clans/house.h"

extern int nameserver_is_slow; //config.cpp
const char *BoolToOnOffStr(bool value);

void do_toggle(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc())
		return;
	if (GET_WIMP_LEV(ch) == 0)
		strcpy(buf2, "");
	else
		sprintf(buf2, "%-3d", GET_WIMP_LEV(ch));

	if (GetRealLevel(ch) >= kLvlImmortal || ch->IsFlagged(EPrf::kCoderinfo)) {
		snprintf(buf, kMaxStringLength,
				 "       : %-3s     "
				 "   : %-3s     "
				 "    : %-3s \r\n"
				 "   : %-3s     "
				 "     : %-3s     "
				 "          : %-3s \r\n"
				 "       : %-3s \r\n",
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kNohassle)),
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kHolylight)),
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kRoomFlags)),
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kNoWiz)),
				 BoolToOnOffStr(nameserver_is_slow),
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kCoderinfo)),
				 BoolToOnOffStr(ch->IsFlagged(EPrf::kShowUnread)));
		SendMsgToChar(buf, ch);
	}

	snprintf(buf, kMaxStringLength,
			 "     : %-3s     "
			 "   : %-3s     "
			 "    : %-3s \r\n"
			 "   : %-3s     "
			 "      : %-3s     "
			 " -        : %-6s  "
			 "        : %-3s     "
			 "          : %-3s \r\n"
			 "        : %-3s     "
			 "          : %-3s     "
			 " : %-3s \r\n"
			 "         : %-3s     "
			 " : %-3s     "
			 "  ()  : %-7s \r\n"
			 "   : %-3s     "
			 "     : %-3s     "
			 "      : %-3s \r\n"
			 "     : %-7s "
			 "      : %-3s     "
			 "          : %-3s \r\n"
			 "       : %-3s     "
			 "   : %-3d     "
			 "   : %-3d \r\n"
			 "         : %-6s  "
			 "  () : %-5s   "
			 "          : %-3s \r\n"
			 "      : %-8s"
			 "         : %-3s     "
			 "       : %-3s \r\n"
			 "       : %-6s  "
			 "     : %-8s"
			 "         : %-3s \r\n"
			 "    : %-3s     "
			 "    : %-3s     "
			 "      : %-3u \r\n",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutoexit)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kBrief)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kCompact)),
			 (ch->IsFlagged(EPrf::kNoRepeat) ? "NO" : "YES"),
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoTell)),
			 ch->IsFlagged(EPrf::kNoInvistell) ? "" : "",
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoGossip)),
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoHoller)),
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoAuction)),
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoExchange)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutomem)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::KSummonable)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kGoAhead)),
			 ch->IsFlagged(EPrf::kShowGroup) ? "" : "",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kNoClones)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutoassist)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutosplit)),
			 ch->IsFlagged(EPrf::kAutoloot) ? ch->IsFlagged(EPrf::kNoIngrLoot) ? "NO-INGR" : "ALL    " : "OFF    ",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutomoney)),
			 BoolToOnOffStr(!ch->IsFlagged(EPrf::kNoArena)),
			 buf2,
			 STRING_LENGTH(ch),
			 STRING_WIDTH(ch),
#if defined(HAVE_ZLIB)
			 ch->desc->deflate == nullptr ? "" : (ch->desc->mccp_version == 2 ? "MCCPv2" : "MCCPv1"),
#else
		"N/A",
#endif
			 ch->IsFlagged(EPrf::kNewsMode) ? "" : "",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kBoardMode)),
			 GetChestMode(ch).c_str(),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kPklMode)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kPolitMode)),
			 ch->IsFlagged(EPrf::kPkFormatMode) ? "" : "",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kClanmembersMode)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kOfftopMode)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAntiDcMode)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kNoIngrMode)),
			 ch->remember_get_num());
	SendMsgToChar(buf, ch);
	if (NOTIFY_EXCH_PRICE(ch) > 0) {
		sprintf(buf, "    : %-7ld ", NOTIFY_EXCH_PRICE(ch));
	} else {
		sprintf(buf, "    : %-7s ", "");
	}
	SendMsgToChar(buf, ch);
	snprintf(buf, kMaxStringLength,
			 "          : %-3s     "
			 "      : %-3s   \r\n"
			 "  () : %-8s"
			 "     : %-5s   "
			 "         : %-3s   \r\n"
			 "  IP   : %-6s  ",
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kDrawMap)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kShowZoneNameOnEnter)),
			 (ch->IsFlagged(EPrf::kBriefShields) ? "" : ""),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kAutonosummon)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kMapper)),
			 BoolToOnOffStr(ch->IsFlagged(EPrf::kIpControl)));
	SendMsgToChar(buf, ch);
	if (GET_GOD_FLAG(ch, EGf::kAllowTesterMode))
		sprintf(buf, "         : %-3s\r\n", BoolToOnOffStr(ch->IsFlagged(EPrf::kTester)));
	else
		sprintf(buf, "\r\n");
	SendMsgToChar(buf, ch);
}

const char *BoolToOnOffStr(bool value) {
	return (value ? "ON" : "OFF");
}