//
// Created by Sventovit on 08.09.2024.
//

#include "do_wake.h"
#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

void do_wake(CharData *ch, char *argument, int/* cmd*/, int subcmd) {
	CharData *vict;
	int self = 0;

	one_argument(argument, arg);

	if (subcmd == kScmdWakeUp) {
		if (!(*arg)) {
			SendMsgToChar("   ???\r\n", ch);
			return;
		}
	} else {
		*arg = 0;
	}

	if (*arg) {
		if (ch->GetPosition() == EPosition::kSleep)
			SendMsgToChar("    ?\r\n", ch);
		else if ((vict = get_char_vis(ch, arg, EFind::kCharInRoom)) == nullptr)
			SendMsgToChar(NOPERSON, ch);
		else if (vict == ch)
			self = 1;
		else if (AWAKE(vict))
			act("$E   $G.", false, ch, nullptr, vict, kToChar);
		else if (vict->GetPosition() < EPosition::kSleep)
			act("$M  !  $S  !", false, ch, nullptr, vict, kToChar);
		else {
			act(" $S .", false, ch, nullptr, vict, kToChar);
			act("$n $g .", false, ch, nullptr, vict, kToVict | kToSleep);
			vict->SetPosition(EPosition::kSit);
		}
		if (!self)
			return;
	}
	if (AFF_FLAGGED(ch, EAffect::kSleep))
		SendMsgToChar("   !\r\n", ch);
	else if (ch->GetPosition() > EPosition::kSleep)
		SendMsgToChar("    ...\r\n", ch);
	else {
		SendMsgToChar("   .\r\n", ch);
		act("$n $u.", true, ch, nullptr, nullptr, kToRoom | kToArenaListen);
		ch->SetPosition(EPosition::kSit);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :