/**
\file do_proxy.cpp - a part of the Bylins engine.
\authors Created by Sventovit.
\date 14.09.2024.
\brief   .      proxy.
*/

#include "administration/proxy.h"

#include "engine/entities/char_data.h"
#include "engine/ui/modify.h"

#include <third_party_libs/fmt/include/fmt/format.h>

void do_proxy(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	std::string buffer = argument, buffer2;
	GetOneParam(buffer, buffer2);

	if (CompareParam(buffer2, "list") || CompareParam(buffer2, "")) {
		std::ostringstream out;
		out << " : IP | IP2 |   | \r\n";

		for (const auto &it : proxy_list) {
			out << fmt::format(" {:<15}   {:<15}   {:<2}   {}\r\n",
							   it.second->textIp, it.second->textIp2, it.second->num, it.second->text);
		}
		page_string(ch->desc, out.str());

	} else if (CompareParam(buffer2, "add") || CompareParam(buffer2, "")) {
		GetOneParam(buffer, buffer2);
		if (buffer2.empty()) {
			SendMsgToChar("  IP    mask|.\r\n", ch);
			return;
		}
		//    
		std::string textIp, textIp2;
		if (CompareParam(buffer2, "mask") || CompareParam(buffer2, "")) {
			GetOneParam(buffer, buffer2);
			if (buffer2.empty()) {
				SendMsgToChar("  .\r\n", ch);
				return;
			}
			textIp = buffer2;
			//    
			GetOneParam(buffer, buffer2);
			if (buffer2.empty()) {
				SendMsgToChar("  .\r\n", ch);
				return;
			}
			textIp2 = buffer2;
		} else {//         -    
			textIp = buffer2;
		}

		GetOneParam(buffer, buffer2);
		if (buffer2.empty()) {
			SendMsgToChar("  - .\r\n", ch);
			return;
		}
		int num = atoi(buffer2.c_str());
		if (num < 2 || num > kMaxProxyConnect) {
			SendMsgToChar(ch, "   (2-%d).\r\n", kMaxProxyConnect);
			return;
		}

		utils::TrimIf(buffer, " \'");
		if (buffer.empty()) {
			SendMsgToChar("  .\r\n", ch);
			return;
		}
		char timeBuf[11];
		time_t now = time(nullptr);
		strftime(timeBuf, sizeof(timeBuf), "%d/%m/%Y", localtime(&now));

		ProxyIpPtr tempIp(new ProxyIp);
		tempIp->text = buffer + " [" + GET_NAME(ch) + " " + timeBuf + "]";
		tempIp->num = num;
		tempIp->textIp = textIp;
		tempIp->textIp2 = textIp2;
		unsigned long ip = TxtToIp(textIp);
		unsigned long ip2 = TxtToIp(textIp2);
		if (ip2 && ((ip2 - ip) > 65535)) {
			SendMsgToChar("  . ( x.x.0.0.  x.x.255.255).\r\n", ch);
			return;
		}
		tempIp->ip2 = ip2;
		proxy_list[ip] = tempIp;
		SaveProxyList();
		SendMsgToChar(" .\r\n", ch);

	} else if (CompareParam(buffer2, "remove") || CompareParam(buffer2, "")) {
		GetOneParam(buffer, buffer2);
		if (buffer2.empty()) {
			SendMsgToChar("  IP    .\r\n", ch);
			return;
		}
		unsigned long ip = TxtToIp(buffer2);
		auto it = proxy_list.find(ip);
		if (it == proxy_list.end()) {
			SendMsgToChar(" IP/    .\r\n", ch);
			return;
		}
		proxy_list.erase(it);
		SaveProxyList();
		SendMsgToChar(" .\r\n", ch);

	} else
		SendMsgToChar(": proxy <list|>\r\n"
					  "        proxy <add|> ip < > \r\n"
					  "        proxy <add|> <mask|> < > < > < > \r\n"
					  "        proxy <remove|> ip\r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
