#include "engine/entities/char_data.h"

bool ignores(CharData *who, CharData *whom, unsigned int flag) {
	if (who->IsNpc()) return false;

	long ign_id;

	if (IS_IMMORTAL(whom)) {
		return false;
	}

//       
	if (whom->IsNpc()
		&& AFF_FLAGGED(whom, EAffect::kCharmed)) {
		return ignores(who, whom->get_master(), flag);
	}

	ign_id = GET_UID(whom);
	for (const auto &ignore : who->get_ignores()) {
		if ((ignore->id == ign_id || ignore->id == -1)
			&& IS_SET(ignore->mode, flag)) {
			return true;
		}
	}
	return false;
}

char *text_ignore_modes(unsigned long mode, char *buf) {
	buf[0] = 0;

	if (IS_SET(mode, EIgnore::kTell))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kSay))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kWhisper))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kAsk))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kEmote))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kShout))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kGossip))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kHoller))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kGroup))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kClan))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kAlliance))
		strcat(buf, " ");
	if (IS_SET(mode, EIgnore::kOfftop))
		strcat(buf, " ");
	return buf;
}

int ign_find_id(char *name, long *id) {
	for (auto &i : player_table) {
		if (!str_cmp(name, i.name())) {
			if (i.level >= kLvlImmortal) {
				return 0;
			}

			*id = i.uid();
			return 1;
		}
	}
	return -1;
}

const char *ign_find_name(long id) {
	for (const auto &i : player_table) {
		if (id == i.uid()) {
			return i.name();
		}
	}

	return "-";
}

/* vim: set ts=4 sw=4 tw=0 noet syntax=cpp :*/
