#include "engine/entities/char_data.h"
#include "engine/db/world_objects.h"
#include "engine/core/handler.h"
#include "gameplay/mechanics/meat_maker.h"
#include "engine/core/utils_char_obj.inl"

void do_fry(CharData *ch, char *argument, int/* cmd*/, int /*subcmd*/) {
	ObjData *meet;
	one_argument(argument, arg);
	if (!*arg) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}
	if (ch->GetEnemy()) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (!(meet = get_obj_in_list_vis(ch, arg, ch->carrying))) {
		snprintf(buf, kMaxStringLength, "   '%s'.\r\n", arg);
		SendMsgToChar(buf, ch);
		return;
	}
	if (!world[ch->in_room]->fires) {
		SendMsgToChar(ch, "    ,   !\r\n");
		return;
	}
	if (world[ch->in_room]->fires > 2) {
		SendMsgToChar(ch, "  , !\r\n");
		return;
	}

	const auto meet_vnum = GET_OBJ_VNUM(meet);
	if (!meat_mapping.has(meet_vnum)) //    
	{
		SendMsgToChar(ch, "%s    .\r\n", GET_OBJ_PNAME(meet, 0).c_str());
		return;
	}

	act("      $o3.", false, ch, meet, nullptr, kToChar);
	act("$n $g    $g $o3.",
		true, ch, meet, nullptr, kToRoom | kToArenaListen);
	const auto tobj = world_objects.create_from_prototype_by_vnum(meat_mapping.get(meet_vnum));
	if (tobj) {
		can_carry_obj(ch, tobj.get());
		ExtractObjFromWorld(meet);
		SetWaitState(ch, 1 * kBattleRound);
	} else {
		mudlog("     do_fry!", NRM, kLvlGreatGod, ERRLOG, true);
	}
}

