// Part of Bylins http://www.mud.ru

#ifndef _FIGHT_HIT_HPP_
#define _FIGHT_HIT_HPP_

#include "fight_constants.h"
#include "gameplay/affects/affect_handler.h"
#include "utils/utils.h"
#include "engine/core/conf.h"
#include "engine/core/sysdep.h"
#include "engine/structs/structs.h"

struct HitData {
	HitData() : weapon(fight::kMainHand), wielded(nullptr), weapon_pos(EEquipPos::kWield), weap_skill(ESkill::kUndefined),
				weap_skill_is(0), skill_num(ESkill::kUndefined), hit_type(0), hit_no_parry(false),
				ch_start_pos(EPosition::kUndefined), victim_start_pos(EPosition::kUndefined), victim_ac(0), calc_thaco(0),
				dam(0), dam_critic(0) {
		diceroll = number(100, 2099) / 100;
	};

	// hit
	void init(CharData *ch, CharData *victim);
	void calc_base_hr(CharData *ch);
	void calc_rand_hr(CharData *ch, CharData *victim);
	void calc_stat_hr(CharData *ch);
	void calc_ac(CharData *victim);
	void add_weapon_damage(CharData *ch, bool need_dice = true);
	void add_hand_damage(CharData *ch, bool need_dice = true);
	void check_defense_skills(CharData *ch, CharData *victim);
	void calc_crit_chance(CharData *ch);
	int calc_damage(CharData *ch, bool need_dice = true);
	double crit_backstab_multiplier(CharData *ch, CharData *victim);

	// extdamage
	int extdamage(CharData *ch, CharData *victim);
	void try_mighthit_dam(CharData *ch, CharData *victim);
	void try_stupor_dam(CharData *ch, CharData *victim);
	void compute_critical(CharData *ch, CharData *victim);

	// init()
	// 1 -      (RIGHT_WEAPON),
	// 2 -    (LEFT_WEAPON)
	fight::AttackType weapon;
	// ,      
	ObjData *wielded;
	//   (NUM_WEARS) 
	int weapon_pos;
	//  ,      
	ESkill weap_skill;
	//   weap_skill  ,   train_skill (  )
	int weap_skill_is;
	//      
	int diceroll;
	//  ,    hit(),   kUndefined
	//    < 0 - ,     hit_type
	//  >= 0 - ,   
	ESkill skill_num;
	//      (attack_hit_text[])
	//       skill_num
	int hit_type;
	// true -   / /   ..
	bool hit_no_parry;
	//     
	EPosition ch_start_pos;
	//     
	EPosition victim_start_pos;

	//    
	//     
	int victim_ac;
	//     
	int calc_thaco;
	//  
	int dam;
	// flags[CRIT_HIT] = true, dam_critic = 0 -  
	// flags[CRIT_HIT] = true, dam_critic > 0 -   
	int dam_critic;

 public:
	using HitFlags = std::bitset<fight::kHitFlagsNum>;

	const HitFlags &get_flags() const { return m_flags; }
	void set_flag(const size_t flag) { m_flags.set(flag); }
	void reset_flag(const size_t flag) { m_flags.reset(flag); }
	static void CheckWeapFeats(const CharData *ch, ESkill weap_skill, int &calc_thaco, int &dam);
 private:
	// -  ,     damage()
	HitFlags m_flags;
};

int compute_armor_class(CharData *ch);

int check_agro_follower(CharData *ch, CharData *victim);
void set_battle_pos(CharData *ch);

void gain_battle_exp(CharData *ch, CharData *victim, int dam);
void perform_group_gain(CharData *ch, CharData *victim, int members, int koef);
void group_gain(CharData *ch, CharData *victim);

char *replace_string(const char *str, const char *weapon_singular, const char *weapon_plural);
bool check_valid_chars(CharData *ch, CharData *victim, const char *fname, int line);

void exthit(CharData *ch, CharData *victim, ESkill type, fight::AttackType weapon);
void hit(CharData *ch, CharData *victim, ESkill type, fight::AttackType weapon);

void appear(CharData *ch);

int GetRealDamroll(CharData *ch);
int GetAutoattackDamroll(CharData *ch, int weapon_skill);

#endif // _FIGHT_HIT_HPP_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
