#include "fit.h"

#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

void DoFit(CharData *ch, char *argument, int/* cmd*/, int subcmd) {
	ObjData *obj;
	CharData *vict;
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];

	if (GetRealLevel(ch) < kLvlImmortal) {
		SendMsgToChar("   .", ch);
		return;
	};

	if ((subcmd == kScmdDoAdapt) && !CanUseFeat(ch, EFeat::kToFitItem)) {
		SendMsgToChar("   .", ch);
		return;
	};
	if ((subcmd == kScmdMakeOver) && !CanUseFeat(ch, EFeat::kToFitClotches)) {
		SendMsgToChar("   .", ch);
		return;
	};

	argument = one_argument(argument, arg1);

	if (!*arg1) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	};

	if (!(obj = get_obj_in_list_vis(ch, arg1, ch->carrying))) {
		sprintf(buf, "   \'%s\'.\r\n", arg1);
		SendMsgToChar(buf, ch);
		return;
	};

	argument = one_argument(argument, arg2);
	if (!(vict = get_char_vis(ch, arg2, EFind::kCharInRoom))) {
		SendMsgToChar("      ?\r\n     !\r\n", ch);
		return;
	};

	if (GET_OBJ_OWNER(obj)) {
		SendMsgToChar("     .\r\n", ch);
		return;

	};

	if ((GET_OBJ_WEAR(obj) <= 1) || obj->has_flag(EObjFlag::KSetItem)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	switch (subcmd) {
		case kScmdDoAdapt:
			if (GET_OBJ_MATER(obj) != EObjMaterial::kMaterialUndefined
				&& GET_OBJ_MATER(obj) != EObjMaterial::kBulat
				&& GET_OBJ_MATER(obj) != EObjMaterial::kBronze
				&& GET_OBJ_MATER(obj) != EObjMaterial::kIron
				&& GET_OBJ_MATER(obj) != EObjMaterial::kSteel
				&& GET_OBJ_MATER(obj) != EObjMaterial::kForgedSteel
				&& GET_OBJ_MATER(obj) != EObjMaterial::kPreciousMetel
				&& GET_OBJ_MATER(obj) != EObjMaterial::kWood
				&& GET_OBJ_MATER(obj) != EObjMaterial::kHardWood
				&& GET_OBJ_MATER(obj) != EObjMaterial::kGlass) {
				sprintf(buf, "  %s %s   .\r\n",
						GET_OBJ_PNAME(obj, 0).c_str(), GET_OBJ_SUF_6(obj));
				SendMsgToChar(buf, ch);
				return;
			}
			break;
		case kScmdMakeOver:
			if (GET_OBJ_MATER(obj) != EObjMaterial::kBone
				&& GET_OBJ_MATER(obj) != EObjMaterial::kCloth
				&& GET_OBJ_MATER(obj) != EObjMaterial::kSkin
				&& GET_OBJ_MATER(obj) != EObjMaterial::kOrganic) {
				sprintf(buf, "  %s %s   .\r\n",
						GET_OBJ_PNAME(obj, 0).c_str(), GET_OBJ_SUF_6(obj));
				SendMsgToChar(buf, ch);
				return;
			}
			break;
		default:
			SendMsgToChar(" - ...\r\n", ch);
			return;
	};
	obj->set_owner(GET_UID(vict));
	sprintf(buf, "    ,     .\r\n");
	sprintf(buf + strlen(buf), "     10000  .\r\n");
	sprintf(buf + strlen(buf), " -  %s    %s.\r\n",
			GET_OBJ_PNAME(obj, 3).c_str(), GET_PAD(vict, 1));

	SendMsgToChar(buf, ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
