#include "ironwind.h"

#include "gameplay/fight/pk.h"
#include "gameplay/fight/common.h"
#include "gameplay/fight/fight.h"
#include "gameplay/fight/fight_hit.h"
#include "parry.h"

void go_iron_wind(CharData *ch, CharData *victim) {
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (ch->GetPosition() < EPosition::kFight) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (ch->IsFlagged(EPrf::kIronWind)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (ch->GetEnemy() && (ch->GetEnemy() != victim)) {
		act("$N    ,   $S.", false, ch, nullptr, victim, kToChar);
		return;
	}

	parry_override(ch);

	act("   ,     $N3!\r\n", false, ch, nullptr, victim, kToChar);
	ObjData *weapon;
	if ((weapon = GET_EQ(ch, EEquipPos::kWield)) || (weapon = GET_EQ(ch, EEquipPos::kBoths))) {
		strcpy(buf, "$n $g  $u  $N3,   $o4!");
		strcpy(buf2, "$N $G  $U  ,   $o4!");
	} else {
		strcpy(buf, "$n  $g  $u  $N3!");
		strcpy(buf2, "$N  $G  $U  !");
	};
	act(buf, false, ch, weapon, victim, kToNotVict | kToArenaListen);
	act(buf2, false, victim, weapon, ch, kToChar);

	if (!ch->GetEnemy()) {
		ch->SetFlag(EPrf::kIronWind);
		SET_AF_BATTLE(ch, kEafIronWind);
		hit(ch, victim, ESkill::kUndefined, fight::kMainHand);
		SetWait(ch, 2, true);
		//ch->setSkillCooldown(ESkill::kGlobalCooldown, 2);
		//ch->setSkillCooldown(ESkill::kIronwind, 2);
	} else {
		ch->SetFlag(EPrf::kIronWind);
		SET_AF_BATTLE(ch, kEafIronWind);
	}
}

void do_iron_wind(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() || !ch->GetSkill(ESkill::kIronwind)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};
	if (ch->HasCooldown(ESkill::kIronwind)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};
	if (GET_AF_BATTLE(ch, kEafOverwhelm) || GET_AF_BATTLE(ch, kEafHammer)) {
		SendMsgToChar("!    !\r\n", ch);
		return;
	};
	int moves = GET_MAX_MOVE(ch) / (2 + MAX(15, ch->GetSkill(ESkill::kIronwind)) / 15);
	if (GET_MAX_MOVE(ch) < moves * 2) {
		SendMsgToChar("  ...\r\n", ch);
		return;
	}
	if (!AFF_FLAGGED(ch, EAffect::kCourage) && !IS_IMMORTAL(ch) && !GET_GOD_FLAG(ch, EGf::kGodsLike)) {
		SendMsgToChar("    ...\r\n", ch);
		return;
	};
	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}

	if (vict == ch) {
		SendMsgToChar("       ... .\r\n", ch);
		return;
	}

	if (!may_kill_here(ch, vict, argument)) {
		return;
	}
	if (!check_pkill(ch, vict, arg)) {
		return;
	}

	go_iron_wind(ch, vict);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp
