#include "engine/entities/char_data.h"
#include "engine/core/handler.h"

void DoLightwalk(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	struct TimedFeat timed;

	if (ch->IsNpc() || !CanUseFeat(ch, EFeat::kLightWalk)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (ch->IsOnHorse()) {
		act("      $N3...", false, ch, nullptr, ch->get_horse(), kToChar);
		return;
	}

	if (IsAffectedBySpell(ch, ESpell::kLightWalk)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}
	if (IsTimedByFeat(ch, EFeat::kLightWalk)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	RemoveAffectFromChar(ch, ESpell::kLightWalk);

	timed.feat = EFeat::kLightWalk;
	timed.time = 24;
	ImposeTimedFeat(ch, &timed);

	SendMsgToChar(",   ,    .\r\n", ch);
	Affect<EApply> af;
	af.type = ESpell::kLightWalk;
	af.duration = CalcDuration(ch, 2, GetRealLevel(ch), 5, 2, 8);
	af.modifier = 0;
	af.location = EApply::kNone;
	af.battleflag = 0;
	if (number(1, 1000) > number(1, GetRealDex(ch) * 50)) {
		af.bitvector = 0;
		SendMsgToChar("   ...\r\n", ch);
	} else {
		af.bitvector = to_underlying(EAffect::kLightWalk);
		SendMsgToChar("    .\r\n", ch);
	}
	affect_to_char(ch, af);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :