#include "mighthit.h"

#include "gameplay/fight/pk.h"
#include "gameplay/fight/fight.h"
#include "gameplay/fight/fight_hit.h"
#include "gameplay/fight/common.h"
#include "parry.h"
#include "protect.h"

// ************************* MIGHTHIT PROCEDURES
void go_mighthit(CharData *ch, CharData *victim) {
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (ch->IsFlagged(EPrf::kIronWind)) {
		SendMsgToChar("        !\r\n", ch);
		return;
	}

	victim = TryToFindProtector(victim, ch);

	if (!ch->GetEnemy()) {
		SET_AF_BATTLE(ch, kEafHammer);
		hit(ch, victim, ESkill::kHammer, fight::kMainHand);
		if (ch->getSkillCooldown(ESkill::kHammer) > 0) {
			SetSkillCooldownInFight(ch, ESkill::kGlobalCooldown, 1);
		}
		//set_wait(ch, 2, true);
		return;
	}

	if ((victim->GetEnemy() != ch) && (ch->GetEnemy() != victim)) {
		act("$N    ,   $S.", false, ch, nullptr, victim, kToChar);
	} else {
		act("      $N2.", false, ch, nullptr, victim, kToChar);
		if (ch->GetEnemy() != victim) {
			stop_fighting(ch, 2);
			SetFighting(ch, victim);
			SetSkillCooldownInFight(ch, ESkill::kGlobalCooldown, 2);
			//set_wait(ch, 2, true);
		}
		SET_AF_BATTLE(ch, kEafHammer);
	}
}

void do_mighthit(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->GetSkill(ESkill::kHammer) < 1) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("    ?\r\n", ch);
		return;
	}

	if (!may_kill_here(ch, vict, argument))
		return;
	if (!check_pkill(ch, vict, arg))
		return;

	do_mighthit(ch, vict);
}

void do_mighthit(CharData *ch, CharData *vict) {
	if (ch->GetSkill(ESkill::kHammer) < 1) {
		log("ERROR:     %s (%d)   ", ch->get_name().c_str(), GET_MOB_VNUM(ch));
		return;
	}

	if (ch->HasCooldown(ESkill::kHammer)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};

	if (vict == ch) {
		SendMsgToChar("   .     .\r\n", ch);
		return;
	}

	if (GET_AF_BATTLE(ch, kEafTouch)) {
		if (!ch->IsNpc())
			SendMsgToChar(".     .\r\n", ch);
		return;
	}
	if (!ch->IsNpc() && !IS_IMMORTAL(ch)
		&& (GET_EQ(ch, EEquipPos::kBoths)
			|| GET_EQ(ch, EEquipPos::kWield)
			|| GET_EQ(ch, EEquipPos::kHold)
			|| GET_EQ(ch, EEquipPos::kShield)
			|| GET_EQ(ch, EEquipPos::kLight))) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	parry_override(ch);

	go_mighthit(ch, vict);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
