#include "parry.h"

#include "gameplay/fight/pk.h"
#include "gameplay/fight/fight_hit.h"
#include "gameplay/fight/common.h"

// **************** MULTYPARRY PROCEDURES
void go_multyparry(CharData *ch) {
	if (AFF_FLAGGED(ch, EAffect::kStopRight) || AFF_FLAGGED(ch, EAffect::kStopLeft) || IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	SET_AF_BATTLE(ch, kEafMultyparry);
	SendMsgToChar("    .\r\n", ch);
}

void do_multyparry(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() || !ch->GetSkill(ESkill::kMultiparry)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kMultiparry)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};
	if (!ch->GetEnemy()) {
		SendMsgToChar("      ?\r\n", ch);
		return;
	}

	ObjData *primary = GET_EQ(ch, EEquipPos::kWield), *offhand = GET_EQ(ch, EEquipPos::kHold);
	if (!(ch->IsNpc()
		|| (primary
			&& GET_OBJ_TYPE(primary) == EObjType::kWeapon
			&& offhand
			&& GET_OBJ_TYPE(offhand) == EObjType::kWeapon)
		|| IS_IMMORTAL(ch)
		|| GET_GOD_FLAG(ch, EGf::kGodsLike))) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (GET_AF_BATTLE(ch, kEafOverwhelm)) {
		SendMsgToChar("!    .\r\n", ch);
		return;
	}
	go_multyparry(ch);
}

// **************** PARRY PROCEDURES
void go_parry(CharData *ch) {
	if (AFF_FLAGGED(ch, EAffect::kStopRight) || AFF_FLAGGED(ch, EAffect::kStopLeft) || IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	SET_AF_BATTLE(ch, kEafParry);
	SendMsgToChar("    .\r\n", ch);
}

void do_parry(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() || !ch->GetSkill(ESkill::kParry)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kParry)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};

	if (!ch->GetEnemy()) {
		SendMsgToChar("      ?\r\n", ch);
		return;
	}

	if (!IS_IMMORTAL(ch) && !GET_GOD_FLAG(ch, EGf::kGodsLike)) {
		if (GET_EQ(ch, EEquipPos::kBoths)) {
			SendMsgToChar("      .\r\n", ch);
			return;
		}

		bool prim = 0, offh = 0;
		if (GET_EQ(ch, EEquipPos::kWield) && GET_OBJ_TYPE(GET_EQ(ch, EEquipPos::kWield)) == EObjType::kWeapon) {
			prim = 1;
		}
		if (GET_EQ(ch, EEquipPos::kHold) && GET_OBJ_TYPE(GET_EQ(ch, EEquipPos::kHold)) == EObjType::kWeapon) {
			offh = 1;
		}

		if (!prim && !offh) {
			SendMsgToChar("     .\r\n", ch);
			return;
		} else if (!prim || !offh) {
			SendMsgToChar("         .\r\n", ch);
			return;
		}
	}

	if (GET_AF_BATTLE(ch, kEafOverwhelm)) {
		SendMsgToChar("!    .\r\n", ch);
		return;
	}
	go_parry(ch);
}

void parry_override(CharData *ch) {
	std::string message = "";
	if (GET_AF_BATTLE(ch, kEafBlock)) {
		message = "        .";
		CLR_AF_BATTLE(ch, kEafBlock);
	}
	if (GET_AF_BATTLE(ch, kEafParry)) {
		message = "       .";
		CLR_AF_BATTLE(ch, kEafParry);
	}
	if (GET_AF_BATTLE(ch, kEafMultyparry)) {
		message = "       .";
		CLR_AF_BATTLE(ch, kEafMultyparry);
	}
	act(message.c_str(), false, ch, 0, 0, kToChar);
}


// vim: ts=4 sw=4 tw=0 noet syntax=cpp :