// Copyrights (C) 1998-2003, Forgotten Dungeon team.
// Read ours copyrights and license terms in 'license.fd'
#include <sys/types.h>
#include <stdio.h>
#include <time.h>
#include "merc.h"
#include "magic.h"
#include "interp.h"

// item type list
const struct item_type item_table [] =
{
 { ITEM_LIGHT,     "light"     },
 { ITEM_SCROLL,    "scroll"    },
 { ITEM_WAND,      "wand"      },
 { ITEM_STAFF,     "staff"     },
 { ITEM_WEAPON,    "weapon"    },
 { ITEM_TREASURE,  "treasure"  },
 { ITEM_ARMOR,     "armor"     },
 { ITEM_POTION,    "potion"    },
 { ITEM_CLOTHING,  "clothing"  },
 { ITEM_FURNITURE, "furniture" },
 { ITEM_TRASH,     "trash"     },
 { ITEM_CONTAINER, "container" },
 { ITEM_DRINK_CON, "drink"     },
 { ITEM_KEY,       "key"       },
 { ITEM_FOOD,      "food"      },
 { ITEM_MONEY,     "money"     },
 { ITEM_BOAT,      "boat"      },
 { ITEM_CORPSE_NPC,"npc_corpse"},
 { ITEM_CORPSE_PC, "pc_corpse" },
 { ITEM_FOUNTAIN,  "fountain"  },
 { ITEM_PILL,      "pill"      },
 { ITEM_PROTECT,   "protect"   },
 { ITEM_MAP,       "map"       },
 { ITEM_PORTAL,    "portal"    },
 { ITEM_WARP_STONE,"warp_stone"},
 { ITEM_ROOM_KEY,  "room_key"  },
 { ITEM_GEM,       "gem"       },
 { ITEM_JEWELRY,   "jewelry"   },
 { ITEM_JUKEBOX,   "jukebox"   },
 { ITEM_ENCHANT,   "enchanter" },
 { ITEM_SCUBA,     "scuba"     },
 { ITEM_BONUS,     "bonus"     },
 { 0,              NULL        }
};

// weapon selection table
const struct weapon_type weapon_table [] =
{
  { "sword",   OBJ_VNUM_SCHOOL_SWORD,  WEAPON_SWORD,   &gsn_sword  },
  { "mace",    OBJ_VNUM_SCHOOL_MACE,   WEAPON_MACE,    &gsn_mace   },
  { "dagger",  OBJ_VNUM_SCHOOL_DAGGER, WEAPON_DAGGER,  &gsn_dagger },
  { "axe",     OBJ_VNUM_SCHOOL_AXE,    WEAPON_AXE,     &gsn_axe    },
  { "spear",   OBJ_VNUM_SCHOOL_SPEAR,  WEAPON_SPEAR,   &gsn_spear  },
  { "staff",   OBJ_VNUM_SCHOOL_STAFF,  WEAPON_STAFF,   &gsn_staff  },
  { "flail",   OBJ_VNUM_SCHOOL_FLAIL,  WEAPON_FLAIL,   &gsn_flail  },
  { "whip",    OBJ_VNUM_SCHOOL_WHIP,   WEAPON_WHIP,    &gsn_whip   },
  { "polearm", OBJ_VNUM_SCHOOL_POLEARM,WEAPON_POLEARM, &gsn_polearm},
  { NULL,      0,                      0,              NULL        }
};

const struct weapon_type weapon_army_table [] =
{
  { "sword",   OBJ_VNUM_ARMY_SWORD,    WEAPON_SWORD,   &gsn_sword  },
  { "mace",    OBJ_VNUM_ARMY_MACE,     WEAPON_MACE,    &gsn_mace   },
  { "dagger",  OBJ_VNUM_ARMY_DAGGER,   WEAPON_DAGGER,  &gsn_dagger },
  { "axe",     OBJ_VNUM_ARMY_AXE,      WEAPON_AXE,     &gsn_axe    },
  { "staff",   OBJ_VNUM_ARMY_STAFF,    WEAPON_STAFF,   &gsn_staff  },
  { "spear",   OBJ_VNUM_ARMY_SPEAR,    WEAPON_SPEAR,   &gsn_spear  },
  { "flail",   OBJ_VNUM_ARMY_FLAIL,    WEAPON_FLAIL,   &gsn_flail  },
  { "whip",    OBJ_VNUM_ARMY_WHIP,     WEAPON_WHIP,    &gsn_whip   },
  { "polearm", OBJ_VNUM_ARMY_POLEARM,  WEAPON_POLEARM, &gsn_polearm},
  { NULL,      0,                      0,              NULL        }
};

// wiznet table and prototype for future flag setting
const struct wiznet_type wiznet_table [] =
{
 {"on",        WIZ_ON,         102, ":"  },
 {"prefix",    WIZ_PREFIX,     102, ":"  },
 {"ticks",     WIZ_TICKS,      102, ":"  },
 {"logins",    WIZ_LOGINS,     102, ":a:"},
 {"sites",     WIZ_SITES,      109, ":a:"},
 {"addr",      WIZ_ADDR,       109, ":a:"},
 {"links",     WIZ_LINKS,      102, ":a:"},
 {"newbies",   WIZ_NEWBIE,     102, ":a:"},
 {"spam",      WIZ_SPAM,       103, ":s:"},
 {"deaths",    WIZ_DEATHS,     102, ":d:"},
 {"resets",    WIZ_RESETS,     102, ":r:"},
 {"mobdeaths", WIZ_MOBDEATHS,  102, ":d:"},
 {"flags",     WIZ_FLAGS,      109, ":f:"},
 {"penalties", WIZ_PENALT,     106, ":p:"},
 {"saccing",   WIZ_SACCING,    102, ":s:"},
 {"levels",    WIZ_LEVELS,     102, ":l:"},
 {"load",      WIZ_LOAD,       109, ":w:"},
 {"restore",   WIZ_RESTORE,    104, ":w:"},
 {"snoops",    WIZ_SNOOPS,     107, ":w:"},
 {"secure",    WIZ_SECURE,     109, ":w:"},
 {"speaks",    WIZ_SPEAKS,     109, ":::"},
 {"skills",    WIZ_SKILLS,     106, ":"  },
 {"config",    WIZ_CONFIG,     106, ":"  },
 {"notes",     WIZ_NOTES,      109, ":*:"},
 {"gspeaks",   WIZ_GSPEAKS,    102, "::" },
 {NULL,        0,              0,   ""   }
};

// attack table  -- not very organized :(
const struct attack_type attack_table [MAX_DAMAGE_MESSAGE] =
{
 {   "none",      "",               -1           }, //0
 {   "slice",     " ",       DAM_SLASH    },
 {   "stab",      "",              DAM_PIERCE   },
 {   "slash",     " ",   DAM_SLASH    },
 {   "whip",      " ",        DAM_SLASH    },
 {   "claw",      " ",       DAM_SLASH    }, //5
 {   "blast",     " ",        DAM_BASH     },
 {   "pound",     " ",       DAM_BASH     },
 {   "crush",     " ",      DAM_BASH     },
 {   "grep",      "",              DAM_SLASH    },
 {   "bite",      "",               DAM_PIERCE   }, //10
 {   "pierce",    " ",     DAM_PIERCE   },
 {   "suction",   " ", DAM_BASH     },
 {   "beating",   "",               DAM_BASH     },
 {   "digestion", " ",     DAM_ACID     },
 {   "charge",    " ",       DAM_BASH     }, //15
 {   "slap",      "",              DAM_BASH     },
 {   "punch",     " ",        DAM_BASH     },
 {   "wrath",     " ",        DAM_SLASH    },
 {   "magic",     "",               DAM_ENERGY   },
 {   "divine",    " ",         DAM_HOLY     }, //20
 {   "cleave",    " ", DAM_SLASH    },
 {   "scratch",   " ",    DAM_PIERCE   },
 {   "peck",      " ",         DAM_PIERCE   },
 {   "peckb",     " ",         DAM_BASH     },
 {   "chop",      " ",   DAM_SLASH    }, //25
 {   "sting",     " ",       DAM_PIERCE   },
 {   "smash",     "   ",   DAM_BASH     },
 {   "shbite",    " ",  DAM_LIGHTNING},
 {   "flbite",    " ",      DAM_FIRE     },
 {   "frbite",    " ",DAM_COLD     }, //30
 {   "acbite",    " ",     DAM_ACID     },
 {   "chomp",     " ",   DAM_PIERCE   },
 {   "drain",     " ",   DAM_NEGATIVE },
 {   "thrust",    " ",      DAM_PIERCE   },
 {   "slime",     "",               DAM_ACID     }, //35
 {   "shock",     " ",    DAM_LIGHTNING},
 {   "thwack",    " ",       DAM_BASH     },
 {   "flame",     "",             DAM_FIRE     },
 {   "chill",     "",              DAM_COLD     },
 {   "light",     "",               DAM_LIGHT    }, //40
 {   "flash",     " ",       DAM_LIGHT    },
 {   "ray",       " ",          DAM_LIGHT    },
 {   "shoot",     "",            DAM_PIERCE   },
 {   NULL,        NULL,                   0            }  //44
};

const char * bonus_dam_types[DAM_MAX+1] =
{
 "none      ",
 "bash      ",
 "pierce    ",
 "slash     ",
 "fire      ",
 "cold      ",
 "lightning ",
 "acid      ",
 "poison    ",
 "negative  ",
 "holy      ",
 "energy    ",
 "mental    ",
 "disease   ",
 "drowning  ",
 "light     ",
 "other     ",
 "harm      ",
 "charm     ",
 "sound     ",
 ""
};

const   char *  weapon_bonus_types[WEAPON_MAX+1]=
{
 "exotic  ",
 "sword   ",
 "dagger  ",
 "spear   ",
 "mace    ",
 "axe     ",
 "flail   ",
 "whip    ",
 "polearm ",
 "staff   ",
 ""
};

// race table now loading from races.dat
// reserved space for 100 races
struct  race_type  race_table [] =
{
  { "null race", " error! ", FALSE, 0,{100,100,100,100},
    0, 0, 0, 0, 0, 0, 0, 0,
    {NULL},
    { 13, 13, 13, 13, 13 },{ 18, 18, 18, 18, 18 },{ 26, 26, 26, 26, 26 },
    SIZE_MEDIUM, 0, 0,0,
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
    "none"
  },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL },
  { NULL }, { NULL }, { NULL }, { NULL }, { NULL }
};

// Deity table.
struct  deity_choice  deity_table [MAX_DEITIES] =
{
//  Name,         Russian,  min_align, max_align, Descr, App[MAX_DEITY_APP]
  { "base deity", "base r_name!", 0, 0, "no description", 0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } },
  { NULL,         NULL,           0, 0, NULL,             0, { 0 } }
};

// Class table.
const struct class_type class_table [MAX_CLASS] =
{
 {
   "mage", "Mag",   STAT_INT, OBJ_VNUM_SCHOOL_DAGGER,
   60,  7,  8, TRUE,
   "mage basics",   "mage default"
 },
 {
   "cleric", "Cle", STAT_WIS, OBJ_VNUM_SCHOOL_MACE,
   60,  9, 10, TRUE,
   "cleric basics", "cleric default"
 },
 {
   "thief", "Thi",  STAT_DEX, OBJ_VNUM_SCHOOL_DAGGER,
   60, 11, 13, FALSE,
   "thief basics",  "thief default"
 },
 {
   "warrior", "War",STAT_STR, OBJ_VNUM_SCHOOL_SWORD,
   60, 14, 15, FALSE,
   "warrior basics","warrior default"
 }
};

const struct picture_type where_name_female[] =       
{ 
 {
  {"                      ", 
  "         {r /-\\         ", 
  "       {r /'{y\\_/{r``\\       ", 
  "{W *   {r  --{D\\___/{r--      ", 
  " {GI{r   / /\\_/{D|{r\\_/\\ \\    ", 
  " {GI{r _/ /  \\ {D|{r /  \\_\\   ", 
  " {GI{r/ _)   | {D|{r |   \\ \\{y_,", 
  "{r/{y@{r \\/   /\\\\{D-{r//\\   \\_{y=)",
  "{r\\{GI{r_/   |   {D/{r   |      ",
  " {GI{r     /  {D |{r   |      ",
  "      {r ``, {D |{r   |      ", 
  "      {r  | {D |{r  /       ", 
  "      {r  | {D |{r   \\      ",
  "      {r  / {D /{r    \\     ", 
  "      {r  | {D| {r    |     ", 
  "     {r /___/---\\__\\    ", 
  "    {D  /_/I   I\\_\\     ", 
  "                      ",
  "                      ",
  "                      "}
 },

 {
  {"     {W  \\--\\_/--/{x      ", 
  "      {W  \\_/{R+{W\\_/{x       ", 
  "         {y \\_/{x         ", 
  "      {w --{b\\___/{w-- {x     ", 
  "    {w / /\\_/{b|{w\\_/\\ \\{x    ", 
  "  {w _/ /  \\ {b|{w /  \\_\\{x   ", 
  " {r I {w ) {y  |{Y+++{y|{w   \\ \\{y_,", 
  "{r-={R+{r=-{w   /   {b /{w\\   \\_{y=)", 
  "{w\\_{rI{w/   {w|  {b /{w   |      ", 
  " {r I  {w  /  {b |{w   |      ", 
  "   {w    ``,  {b|{w   |      ", 
  "   {w     |  {b|{w   |      ", 
  "   {w     |  {b|{w   \\      ", 
  "   {w     / {b /{w    \\     ", 
  "   {w     | {b|{w     |     ", 
  "   {w   /___/---\\__\\    ", 
  "  {D    /_/I   I\\_\\     ", 
  "                      ",
  "                      ",
  "                      "}
 }, 

 {
  {"                      ", 
  "       {m   /_\\         ", 
  "       {W  |{y\\_/{W|        ", 
  "    {m   /--\\{r-{m/--\\      ", 
  " {b|{m   / /\\_/ \\_/\\ \\    ", 
  " {b|{m  / /  \\{r |{m /  \\ \\   ", 
  " {b|{m/ /'   {m|{R---{m|  / /   ", 
  "{B-{y@{B-{m     / {r/|{m \\ {y@{m/     ", 
  " {B|{m     / {R(_){m  \\  {b\\    ", 
  "      {m |__---__\\  {b``\\  ", 
  "       {g|   /   |      ", 
  "   {g    |  / \\  |      ", 
  "    {g  |  /   | |      ", 
  "    {g  | /    / )      ", 
  "   {D  |-/    /-/       ", 
  "   {D  I\\/    I\\_\\      ", 
  "                      ", 
  "                      ",
  "                      ",
  "                      "}
 }, 

 {
  {"                   {R | ", 
  "                   {R T ", 
  "         {r({b/_\\{r){R     ``='", 
  "         {w\\{y\\_/{w/{x      | ", 
  "      {b\\-\\/{r^ ^{b\\/-/{x   | ", 
  "    {b\\/ /\\_/{r|{b\\_/\\ \\/{x | ", 
  " {G+-----+{b \\___/  \\_\\{x | ", 
  " {G|{W/``\\  {G| {g|{W+++{g|  {b \\ \\{x|,", 
  " {G|     |{g/\\\\{r-{g//\\   {b\\_{y@){x", 
  " {G| {W\\,/ {G|{g \\{r---{g/ {x|    | ", 
  " {G\\     /{g  / \\  |  {x  | ", 
  " {G  \\_/ {g``,  |  /|  {x  | ", 
  "        {g| /  //    {x | ", 
  "        {g|   / |  {x   | ", 
  "        {g/ / {D\\ |/{x    | ", 
  "        {g|{D//  | |{x    | ", 
  "       _/{D)   (\\/ {x   | ", 
  "     {D /_/I   I\\_\\{x   D ",
  "                      ",
  "                      "}
  } 
}; 
 
const struct  picture_type   where_name_male[] = 
{ 
 {
  {"  {r     ,-,      {R  *  ", 
  "  {r    /{R.{r-{R.{r\\    {g   I  ", 
  "  {r   / {y\\_/{r \\   {g   I  ", 
  " {r /-/ {w\\   / {r\\-\\{g   I  ", 
  " {r| /-  {w\\ /  {r \\ \\{g  I  ", 
  " {r/  \\  {R & {r  /| |/{y @  ", 
  " {r| | |{Y#####{r| ``\\_/ {gI  ", 
  " {r| |/ /   \\ \\    {g I  ", 
  "{r/{y_ {r| ``  _ /'|  {g   I  ", 
  "{y||{r \\    |   |   {g  I  ", 
  "{r   /    |   \\    {g I  ", 
  "{r  |     |    |   {g I  ", 
  "{r  |     /    /   {g I  ", 
  "{r  |    |    |    {g I  ", 
  "{r  |    |     ``\\ {g  I  ", 
  "{r  /_  /---\\___| {g  I  ", 
  "                     ", 
  "                     " }
 }, 
 {
  {"        {y  /-\\{x           ", 
  "        {y |{B- -{y|          ", 
  "        {w -{y\\_/{w-          ", 
  "    {w  *--{r\\   /{w--*       ", 
  "{R* {w  /    {r \\ /{w   \\ \\     ", 
  "{g| {w /  /\\  {R + {w  /| | {rI   ", 
  "{g|{w/'  /  |{y====={w| ``\\{r-={R+{r=- ", 
  "{y@{w__/'  /       \\  ``\\{rI   ", 
  "{g|  {w   |        |   {r I   ", 
  " {w     \\        |        ", 
  " {w     /        \\        ", 
  " {w    |          |       ", 
  " {w    |          /       ", 
  " {w    |         |        ", 
  " {w    |          ``\\      ", 
  " {w    /_  /---\\___|      ", 
  "                        ", 
  "                        " }
 }, 
 {
  {"        {m  /-\\           ", 
  "        {m |/-\\|          ", 
  "    {m /---{D\\   /{m---\\      ", 
  "   {m /  /  {D\\_/  {m\\  \\     ", 
  "  {m /  /\\   |   /\\  \\    ", 
  " {m /  /  |  |  |  \\  )   ", 
  "{B\\{m  /'   |{R====={m|   \\ \\ {B /", 
  "{B-{y@{b-   {m / {R(){m /  \\   \\\\{y@{B_ ", 
  "{B  ``\\  {m |---/---|   {b /   ", 
  "{B    ``\\ {g/  / \\  | {b /     ", 
  "{g       |  | |  |        ", 
  "{g      /   / |  |        ", 
  "{g      /  /  |  )        ", 
  "{g     /  /   |  |        ", 
  "{g    /  /    |  \\        ", 
  "{D   (__)     (___\\       ", 
  "                        ", 
  "                        " }
 }, 
 {
  {"                        ", 
  "      {r  ({b /=\\{r )         ", 
  "      {r  ``{b|{r\\{b^{r/{b|{r'         ", 
  "   {b\\/^^-\\\\_{r|{b_//-^^\\/    ", 
  "   {b\\ {D`` {b/  {D\\_/{b  \\ {D'{b /    ", 
  " {b  |  /-\\__ __/-\\  |    ", 
  "{G=======\\{b   |   /| /\\{y\\{R^{y/ ", 
  "{r ## {G   |{b|{Y====={b| ``\\_/ {y#  ", 
  "{r ## {G   |{b /   \\ \\  {y /^{WI{y^\\", 
  "{r###### {G|{b``\\ _ /'{b|     {WI  ", 
  "{r ##    {G| {b | |  |    {W I  ", 
  " {r##   {G | {b | |  |    {W I  ", 
  " {r##   {G /{b-|' |- |>    {WI  ", 
  " {r##  {G / {b |  |  /    {W |  ", 
  "  {G  /{b | |    | |    {W |  ", 
  " {G\\/{b /__/{y=-  -={b-_``\\  {W |  ", 
  "                        ", 
  "                        "}
 } 
}; 

char *  const                   title_table     [MAX_CLASS][MAX_LEVEL+1][2] =
{
 {
 { "Man",                         "Woman" },

 { " ",              " "         },
 { "  ",  "  "   },
 { "  ", "  " },
 { "  ",      "  "      },
 { "  ",       "  "        },

 { "{C {x",             "{C {x"     },
 { "{C{x",                     "{C{x"             },
 { "{C {x",             "{C {x"     },
 { "{C {x",      "{C {x" },
 { "{C{x",                 "{C{x"                },

 { "{G {x",        "{G {x"    },
 { "{G{x",             "{G{x"     },
 { "{G {x",     "{G {x" },
 { "{G{x",                "{G{x"         },
 { "{G{x",                   "{G{x"       },

 { "{Y{x",                   "{Y{x"   },
 { "",                   ""  },
 { "{c{x",                 "{c{x" },
 { "{W{x",                  "{W{x"  },
 { "{B{x",                 "{B{x" },

 { "{r{x",                 "{r{x"                },
 { "{M {x",          "{M {x"        },
 { "{M {x",         "{M {x"       },
 { "{M {x",      "{M {x" },
 { "{M {x",       "{M {x"  },

 { "{B  {x", "{B  {x" },
 { "{B {x",        "{B {x"        },
 { "{B {x",          "{B {x"          },
 { "{B  {x", "{B  {x" },
 { "{B {x",            "{B {x"           },

 { "{R {x",          "{R {x"         },
 { "{R {x",          "{R {x"     },
 { "{R  {x",       "{R  {x"      },
 { "{R*   *{x",     "{R*   *{x"},
 { "{R<<<   >>>{x",         "{R<<<   >>>{x" },

 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },

 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },
 { "{C {Y{x",  "{C {Y{x" },

 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },

 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },
 { "{C{G {Y{G{x",  "{C{G {Y{G{x" },

 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },

 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },
 { "* {C{G {Y{G{x *",  "* {C{G {Y{G{x *" },

 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },

 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },
 { "** {C{G {Y{G{x **",  "** {C{G {Y{G{x **" },

 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },

 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },
 { "*** {C{G {Y{G{x ***",  "*** {C{G {Y{G{x ***" },

 { "<*> {C{G {Y{G{x <*>",  "<*> {C{G {Y{G{x <*>" },
 { "<*> {C{G {Y{G{x <*>",  "<*> {C{G {Y{G{x <*>" },
 { "<*> {C{G {Y{G{x <*>",  "<*> {C{G {Y{G{x <*>" },
 { "<*> {C{G {Y{G{x <*>",  "<*> {C{G {Y{G{x <*>" },
 { "<*> {C{G {Y{G{x <*>",  "<*> {C{G {Y{G{x <*>" },

 { ">*< {C{G {Y{G{x >*<",  ">*< {C{G {Y{G{x >*<" },
 { ">*< {C{G {Y{G{x >*<",  ">*< {C{G {Y{G{x >*<" },
 { ">*< {C{G {Y{G{x >*<",  ">*< {C{G {Y{G{x >*<" },
 { ">*< {C{G {Y{G{x >*<",  ">*< {C{G {Y{G{x >*<" },
 { ">*< {C{G {Y{G{x >*<",  ">*< {C{G {Y{G{x >*<" },

 { "<<< {C{G {Y{G{x >>>",  "<<< {C{G {Y{G{x >>>" },
 { "<<< {C{G {Y{G{x >>>",  "<<< {C{G {Y{G{x >>>" },
 { "<<< {C{G {Y{G{x >>>",  "<<< {C{G {Y{G{x >>>" },
 { "<<< {C{G {Y{G{x >>>",  "<<< {C{G {Y{G{x >>>" },
 { "<<< {C{G {Y{G{x >>>",  "<<< {C{G {Y{G{x >>>" },

 { "{G!!! {C  {G!!!{x", "{G!!! {C  {G!!!{x"  },
 { "{C {x",        "{C {x"     },
 { "{C {x", "{C {x"},
 { "{C{x",                "{C{x"           },
 { "{C {x",        "{C {x"      },
 { "{C{x",              "{C{x"            },
 { "{R{x",                    "{R{x"               },
 { "{R {x",          "{R {x"     },
 { "{D{x",              "{D{x"        },
 { "{D  {x",    "{D  {x"  }
 },

 {
 { "Man",                        "Woman" },

 { "",                   ""           },
 { "",              ""  },
 { "",                  ""      },
 { "",                ""        },
 { "",                  ""          },

 { "",                      ""       },
 { "",                     ""  },
 { "",                    ""     },
 { "",                  ""  },
 { "",                        ""     },

 { "",                      ""       },
 { "",                      ""       },
 { "",                 ""  },
 { "",                       ""      },
 { "",                      ""    },

 { "e",                   ""      },
 { "",                   ""   },
 { "{c{x",                 "{c{x"  },
 { "{W{x",                  "{W{x"   },
 { "{B{x",                 "{B{x"  },

 { "{r{x",                 "{r{x"         },
 { " ",           " "     },
 { " ",           " "     },
 { "",                  ""          },
 { " ",          " "  },

 { " ",              " "    },
 { " ",             " "   },
 { " ",           " " },
 { " ",              " "    },
 { " ",             " "   },

 { " ",         " "       },
 { " ",          " "        },
 { " ",      " "    },
 { " ",           " "         },
 { "Master of all Divinity",     "Mistress of all Divinity" },

 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},

 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},

 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},

 { "{C {x",     "{C {x"     },
 { "{C  {x",  "{C  {x"  },
 { "{C {x",        "{C {x"       },
 { "{C {x",         "{C {x",       },
 { "{C{x",                  "{C{x"                  },
 { "{C{x",              "{C{x"          },
 { "{R {x",     "{R {x" },
 { "{R {x",           "{R {x"        },
 { "{D{x",               "{D{x"           },
 { "{D  {x",     "{D  {x"     }
 },

 {
 { "Man",                        "Woman" },

 { " ",             " "             },
 { " ",       " "         },
 { " ",              " "                },
 { "   ","   "},
 { "  ",   "  "   },

 { "",                    ""        },
 { "",                  ""     },
 { "",                     ""         },
 { " ",             " " },
 { "",                      ""          },

 { "",                   ""          },
 { "",                   ""          },
 { " ",          " " },
 { "",                  ""      },
 { "",                        ""            },

 { "  ",         "  " },
 { "",                   ""        },
 { "{c{x",                 "{c{x"       },
 { "{W{x",                  "{W{x"        },
 { "{B{x",                 "{B{x"       },

 { "{r{x",                 "{r{x"    },
 { " ",              " "   },
 { " ",              " "   },
 { "",                    ""         },
 { " ",            " " },

 { " ",             " " },
 { " ",               " "   },
 { " ",              " "  },
 { " ",               " "   },
 { " ",             " " },

 { " ",            " "           },
 { "  ",  "  " },
 { "  ",    "  "   },
 { "  ",    "  "   },
 { " ",              " "             },

 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},

 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},

 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},

 { "{C   {x", "{C   {x" },
 { "{C  {x",    "{C  {x"   },
 { "{C {x",             "{C {x"             },
 { "{C {x",          "{C {x"    },
 { "{C {x",            "{C {x"        },
 { "{C {x",             "{C {x"         },
 { "{R {x",               "{R {x"            },
 { "{R {x",              "{R {x"           },
 { "{D{x",                  "{D{x"              },
 { "{D  {x",        "{D  {x"        }
 },

 {
 { "Man",                        "Woman" },

 { "  ",        "  " },
 { "",                     ""               },
 { "",                 ""           },
 { " ",            " " },
 { "",                     ""               },

 { "",                       ""     },
 { "",                     ""       },
 { "",               "" },
 { "",                   ""      },
 { "",                    ""       },

 { "",                      ""            },
 { "",               ""       },
 { " ",         " " },
 { "",                    ""           },
 { " ",                " "        },

 { "",                  ""    },
 { "",                  ""   },
 { "{c{x",                "{c{x"  },
 { "{W{x",                 "{W{x"   },
 { "{B{x",                "{B{x"  },

 { "{r{x",                "{r{x"     },
 { " ",             " "  },
 { "",                    ""         },
 { " ",            " " },
 { " ",             " "  },

 { "  ","  "},
 { " ",            " "                },
 { "  ",    "  "        },
 { " ",               " "              },
 { "",                   ""                       },

 { " ",              " "  },
 { " ",             " " },
 { " ",              " "  },
 { " ",              " "  },
 { " ",             " " },


 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },
 { "{C {x",      "{C {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },
 { "{C{G {x",      "{C{G {x" },

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},
 { "* {C{G {x *",  "* {C{G {x *"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},
 { "** {C{G {x **","** {C{G {x **"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},
 { "*** {C{G {x ***","*** {C{G {x ***"},

 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},
 { "<*> {C{G {x <*>","<*> {C{G {x <*>"},

 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},
 { ">*< {C{G {x >*<",">*< {C{G {x >*<"},

 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},
 { ">>> {C{G {x <<<",">>> {C{G {x <<<"},

 { "{C{x",                      "{C{x"                  },
 { "{C {x",           "{C {x"        },
 { "{C {x",               "{C {x"             },
 { "{C {x",         "{C {x" },
 { "{C {x",           "{C {x"  },
 { "{C {x"       "{C {x"    },
 { "{R {x",                  "{RR {x"             },
 { "{R {x",              "{RE {x"        },
 { "{D{x",                  "{D{x"            },
 { "{D  {x",        "{D  {x"      }
 }
};

/* Attribute bonus tables. */
const   struct  str_app_type    str_app         [37]            =
{
// hr, dr, carry, wield
 { -5, -4,   0,  0 },  // 0
 { -5, -4,   3,  1 },  // 1
 { -3, -2,   3,  2 },
 { -3, -1,  10,  3 },  // 3
 { -2, -1,  25,  4 },
 { -2, -1,  55,  5 },  // 5
 { -1,  0,  80,  6 },
 { -1,  0,  90,  7 },
 {  0,  0, 100,  8 },
 {  0,  0, 100,  9 },
 {  0,  0, 115, 10 }, // 10
 {  0,  0, 115, 11 },
 {  0,  0, 130, 12 },
 {  0,  0, 130, 13 }, // 13
 {  0,  1, 140, 14 },
 {  1,  1, 150, 15 }, // 15
 {  1,  2, 165, 16 },
 {  2,  3, 180, 22 },
 {  2,  3, 200, 25 }, // 18
 {  3,  4, 225, 30 },
 {  3,  5, 250, 35 }, // 20
 {  4,  6, 300, 40 },
 {  4,  6, 350, 45 },
 {  5,  7, 400, 50 },
 {  5,  8, 450, 55 },
 {  6,  9, 500, 60 }, // 25
 {  6, 10, 550, 65 },
 {  7, 11, 600, 70 },
 {  7, 12, 650, 75 },
 {  8, 13, 700, 80 },
 {  9, 15, 800, 90 }, // 30
 { 10, 17, 850, 95 },
 { 12, 19, 900,100 },
 { 14, 21, 950,100 },
 { 16, 23,1000,100 },
 { 20, 25,1000,120 }, // 35
 { 20, 25,1000,120 }  // 36
};



const   struct  int_app_type    int_app         [37]           =
{
// learn
 {  3 },     /*  0 */
 {  5 },     /*  1 */
 {  7 },
 {  8 },     /*  3 */
 {  9 },
 { 10 },     /*  5 */
 { 11 },
 { 12 },
 { 13 },
 { 15 },
 { 17 },     /* 10 */
 { 19 },
 { 22 },
 { 25 },
 { 28 },
 { 31 },     /* 15 */
 { 34 },
 { 37 },
 { 40 },     /* 18 */
 { 44 },
 { 49 },     /* 20 */
 { 55 },
 { 61 },
 { 68 },
 { 74 },
 { 76 },     /* 25 */
 { 81 },
 { 86 },
 { 88 },
 { 90 },
 { 92 },     /* 30 */
 { 94 },
 { 96 },
 { 98 },
 { 99 },
 { 99 },     /* 35 */
 { 99 }      /* 36 */
};

const   struct  wis_app_type    wis_app         [37]           =
{
// prac
 { 0 },      /*  0 */
 { 0 },      /*  1 */
 { 0 },
 { 0 },      /*  3 */
 { 0 },
 { 1 },      /*  5 */
 { 1 },
 { 1 },
 { 1 },
 { 1 },
 { 1 },      /* 10 */
 { 1 },
 { 1 },
 { 1 },
 { 1 },
 { 2 },      /* 15 */
 { 2 },
 { 2 },
 { 3 },      /* 18 */
 { 3 },
 { 3 },      /* 20 */
 { 3 },
 { 4 },
 { 4 },
 { 5 },
 { 6 },      /* 25 */
 { 7 },
 { 8 },
 { 9 },
 { 9 },
 { 9 },      /* 30 */
 {10 },
 {10 },
 {10 },
 {10 },
 {10 },      /* 35 */
 {10 }       /* 36 */
};

const   struct  dex_app_type    dex_app         [37]            =
{
// defence
 {   60 },   /* 0 */
 {   50 },   /* 1 */
 {   50 },
 {   40 },
 {   30 },
 {   20 },   /* 5 */
 {   10 },
 {    0 },
 {    0 },
 {    0 },
 {    0 },   /* 10 */
 {    0 },
 {    0 },
 {    0 },
 {    0 },
 { - 10 },   /* 15 */
 { - 15 },
 { - 20 },
 { - 30 },
 { - 40 },
 { - 50 },   /* 20 */
 { - 60 },
 { - 75 },
 { - 90 },
 { -105 },
 { -120 },   /* 25 */
 { -135 },
 { -170 },
 { -210 },
 { -250 },
 { -300 },   /* 30 */
 { -350 },
 { -400 },
 { -500 },
 { -600 },   /* 35 */
 { -600 }    /* 36 */
};


const   struct  con_app_type    con_app         [37]            =
{
// hp, shock
 { -4, 20 },   /*  0 */
 { -3, 25 },   /*  1 */
 { -2, 30 },
 { -2, 33 },   /*  3 */
 { -1, 35 },
 { -1, 38 },   /*  5 */
 { -1, 41 },
 {  0, 44 },
 {  0, 47 },
 {  0, 50 },
 {  0, 53 },   /* 10 */
 {  0, 56 },
 {  0, 58 },
 {  0, 61 },
 {  0, 63 },
 {  1, 65 },   /* 15 */
 {  2, 68 },
 {  3, 70 },
 {  4, 72 },   /* 18 */
 {  5, 74 },
 {  6, 76 },   /* 20 */
 {  7, 78 },
 {  8, 80 },
 {  9, 83 },
 { 10, 85 },
 { 11, 88 },   /* 25 */
 { 12, 91 },
 { 13, 94 },
 { 14, 96 },
 { 15, 98 },
 { 16, 99 },   /* 30 */
 { 18, 99 },
 { 20, 99 },
 { 20, 99 },
 { 20, 99 },
 { 22, 99 },   /* 35 */
 { 22, 99 }    /* 36 */
};

// Liquid properties.  Used in world.obj.
const struct liq_type liq_table [] =
{
//  name              showname,             color,       proof, full, thirst, food, ssize
 { "bug",             "{G {R{x",  "BUG report to Imms", { 150, 1,  0, 0,  0 } },

 { "water",           "{x",             "",         {   0, 1, 10, 0, 16 } },
 { "salt water",      " {x",     "",         {   0, 1, -2, 0,  1 } },

 { "milk",            "{W{x",         "",              {   0, 2,  9, 3, 12 } },
 { "bulyon",          "{Y{x",         "",           {   0, 2,  9, 3, 12 } },
 { "honey",           "{y{x",            "",            {   0, 2,  8, 2, 12 } },
 { "lava",            "{R{x",           "",          {   0, 2, 10, 10, 6 } },
 { "sun nectair",     "{Y {c{x","{Y {x",{   0, 1,  3, 3,  2 } },

 { "cranberry juice", "{r {x", "",            {   0, 1,  9, 2, 12 } },
 { "tomato juice",    "{R {x",   "-",      {   0, 2,  5, 4, 12 } },
 { "apple juice",     "{Y {x",   "",         {   0, 2,  9, 1, 12 } },
 { "slime mold juice","{G {x",  "",            {   0, 2, -8, 1,  2 } },
 { "grape juice",     "{m {x","",             {   0, 2,  5, 2, 12 } },
 { "orange juice",    "{Y {x",       "",  {   0, 2,  9, 3, 12 } },
 { "tree juice",      "{w   {x","", {   0, 2,  8, 2, 12 } },

 { "tea",             "{y{x",            "",         {   0, 1,  8, 0,  6 } },
 { "coffee",          "{D{x",           "",             {   0, 1,  8, 0,  6 } },
 { "cocoa",           "{y{x",          "",            {   0, 1,  8, 0,  6 } },
 { "kefir",           "{W{x",          "",              {  -8, 2,  6, 1,  8 } },

 { "root beer",       "{y {x",   "",         {  14, 2,  9, 2, 12 } },
 { "beer",            "{y{x",           "",           {   8, 1,  8, 1, 12 } },
 { "cool beer",       "{W {y{x","",           {  10, 2,  9, 3, 12 } },
 { "porter22",        " '{D22{x'",                  "",      {  12, 2,  7, 2,  3 } },
 { "beer slavutich",  " '{r {x'",      "",       {  12, 2,  7, 2,  3 } },
 { "beer premium",    " '{Y {x'",     "",   {  10, 2,  7, 2,  3 } },
 { "beer oksamit",    " '{Y {R{x'","-", {  12, 2,  7, 2,  3 } },

 { "blood",           "{r{x",          "",            {   0, 2,  9, 3, 12 } },
 { "jivchik",         "{Y{x",         "",            {  -1, 1,  7, 0,  8 } },
 { "coke",            "{r{x",           "",         {   0, 2,  9, 2, 12 } },
 { "tarhun",          "{G{x",         " ",   {   0, 2,  9, 3, 12 } },
 { "lemonade",        "{M{x",        "",            {   0, 1,  9, 2, 12 } },
 { "aquavit",         " {x",       "",         { 100, 1,  5, 0,  2 } },
 { "tarhun",          "{G{x",         " ",   {   0, 2,  9, 3, 12 } },
 { "cream soda",      "{Y {x",      " ",    {   0, 1,  9, 3, 12 } },

 { "icewine",         "{M {x",           "",            {  15, 2,  6, 1,  5 } },
 { "benedictine wine","{R  {x","",       {  20, 1,  8, 1,  5 } },
 { "elvish wine",     "{G {x","",            {  18, 2,  8, 1,  5 } },
 { "white wine",      "{w {x",     "",            {  13, 1,  8, 1,  5 } },
 { "red wine",        "{r {x",   "",           {  15, 1,  8, 1,  5 } },
 { "rose wine",       "{R {x",   "",            {  15, 1,  8, 1,  5 } },
 { "amontillado",     "{m{x",    "",           {  20, 2,  8, 1,  5 } },
 { "sherry",          "{R{x",          "",            {  30, 2,  7, 1,  5 } },
 { "cordial",         "{x",          "",         {  50, 1,  5, 0,  2 } },

 { "mead",            "{Y{x",       "",            {  30, 2,  8, 2, 12 } },
 { "ale",             "{y{x",            "",         {  14, 1,  8, 1, 12 } },
 { "dark ale",        "{D {x",     "",             {  16, 1,  8, 1, 12 } },

 { "kognak",          "{y{x",         "",        {  50, 1,  5, 0,  2 } },
 { "dwarvish vodka",  "{D {x", " ", {  70, 1,  5, 0,  2 } },
 { "champagne",       "{w{x",     "",            {  12, 1,  8, 1,  5 } },
 { "vodka",           "{x",            "",         {  70, 1,  5, 0,  2 } },
 { "whisky",          "{Y{x",          "",            {  50, 1,  5, 0,  2 } },
 { "grog",            "{r{x",           "-",      {  60, 1,  3, 0,  2 } },
 { "brandy",          "{Y{x",         "",            {  60, 1,  5, 0,  4 } },
 { "schnapps",        "{x",            "",         {  25, 1,  5, 0,  2 } },
 { "rum",             "{Y{x",            "",           {  80, 1,  4, 0,  2 } },

 { "acid",            "{G {x",  "",        {  10, 2,  9, 3, 12 } },
 { "samogon",         "{x",          "",         { 120, 1,  3, 0,  2 } },
 { "firebreather",    "{R {Y{X","",           { 120, 1,  4, 0,  2 } },
 { "absinthe",        "{g{x",         "",            { 100, 1,  4, 0,  2 } },
 { "acid",            "{G {x",          " ",{  10, 2, 9, 3, 12 } },
 { "framboise",       "{W{w{W{w{W{w{W{w{x", "",              { 120, 1, 7, 1,  5 } },
 { "dew of sorrow",   " {x",              ",  ",{ 300, 1, 9, 9,  2 } },
 { "lifewater",       "{W{C{W{C{W{C {W{x", "",           {   0, 2, 5, 3, 12 } },
 { "cocoa",           "{y",            " ",{  0, 1,  3, 4, 12 } },
 { NULL,              NULL,                         NULL,         {   0, 0,  0, 0,  0 } }
};

// The skill and spell table.
struct skill_type skill_table [] =
{
// {
//   "Skill Name",              //  
//   { mag,cle,thi,war},        //    MCTW
//   {learn,learn,learn,learn}, //  
//   spell_pointer,             //   
//   legal_targets,             //   TARGET
//   position,                  //  
//   &gsn,                      // &gsn
//   category,                  //  
//   min_mana,                  //    
//   wait_time,                 // wait_time
//   "damage msg",              //   
//   "wear off msg",            //    
//   "wear off obj msg",        // .    
//   flag,                      // 
//   "brief help"               //  
// },
 {
     "reserved",
     { 111, 111, 111, 111 },
     { 99, 99, 99, 99},
     0,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     0,
     0,
     0,
     "",
     "",
     "",
     0,
     " ,  ."
 },
 {
     "acid blast",
     { 40, 102, 49, 43 },
     { 1,  1,  2,  2},
     spell_acid_blast,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|WATER,
     20,
     12,
     " ",
     "Bug - Acid Blast",
     "Bug - Acid Blast",
     0,
     "   .    ."
 },
 {
     "aid",
     { 5, 102, 36, 102 },
     { 7,  1,  5,  1},
     spell_aid,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE,
     30,
     12,
     "aid",
     "  .",
     "BUG - aid",
     0,
     "      ."
 },
 {
     "bless",
     { 102,        7,       102,       8 },
     { 1,        1,        2,        2},
     spell_bless,
     TAR_OBJ_CHAR_DEF,
     POS_STANDING,
     NULL,
     SPELL|LIGHT,
     5,
     12,
     "bless",
     "    .",
     "   $i2 .",
     0,
     "   ,   ."
 },
 {
     "armor",
     {  7,2,10,5 },
     { 1,1,2,2},
     spell_armor,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|PROTECT,
     5,
     12,
     "armor",
     "    .",
     "BUG - armor",
     0,
     "    ."
 },
 {
     "blindness",
     {  12,        8,       17,       15 },
     { 1,        1,        2,        2},
     spell_blindness,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     &gsn_blindness,
     SPELL|WATER,
     5,
     12,
     "blind",
     "   .",
     "$i1   ",
     0,
     "    ."
 },
 {
     "burning hands",
     {  7,       102,       10,       9 },
     { 1,        1,        2,        2},
     spell_burning_hands,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|FIRE,
     15,
     12,
     " ",
     "!Burning Hands!",
     "BUG - burning hands",
     0,
     "  ."
 },
 {
     "call lightning",
     { 26,       18,       31,       22 },
     { 1,        1,        2,        2},
     spell_call_lightning,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     15,
     12,
     " ",
     "   .",
     "BUG - call lightning",
     0,
     "   .      ."
 },
 {
     "calm",
     { 48,       16,       50,       20 },
     { 1,        1,        2,        2},
     spell_calm,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     SPELL|MIND,
     30,
     12,
     "calm",
     "   .",
     "BUG - calm",
     0,
     "   ,     ."
 },
 {
     "cancellation",
     { 18,       26,       34,       34 },
     { 1,        1,        2,        2},
     spell_cancellation,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     20,
     12,
     "BUG - cancellation",
     "BUG - cancellation",
     "BUG - cancellation",
     0,
     "  .     ."
 },
 {
     "cause critical",
     { 102,        30,       102,       102 },
     { 1,        1,        2,        2},
     spell_cause_critical,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     20,
     12,
     "",
     "BUG - Cause Critical",
     "BUG - Cause Critical",
     C_NODUAL,
     "  ,   ."
 },
 {
     "cause light",
     { 102,        1,       102,       102 },
     { 1,        1,        2,        2},
     spell_cause_light,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     15,
     12,
     "",
     "BUG - Cause Light",
     "BUG - Cause Light",
     C_NODUAL,
     "  ,   ."
 },
 {
     "cause serious",
     { 102,        15,       102,       102 },
     { 1,        1,        2,        2},
     spell_cause_serious,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     17,
     12,
     "",
     "BUG - Cause Serious",
     "BUG - Cause Serious",
     C_NODUAL,
     "  ,   ."
 },
 {
     "chain lightning",
     { 33,102,39,36 },
     { 1,1,2,2},
     spell_chain_lightning,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     25,
     12,
     "",
     "BUG - Chain Lightning",
     "BUG - Chain Lightning",
     C_NODUAL,
     "      .  ."
 },
 {
     "change sex",
     { 102,102,102,102 },
     { 1,1,2,2},
     spell_change_sex,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE|MIND,
     15,
     12,
     "BUG - change sex",
     "    .",
     "BUG - Change Sex",
     0,
     "  ."
 },
 {
     "charm person",
     { 20,102,25,102 },
     { 1,1,2,2},
     spell_charm_person,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     &gsn_charm_person,
     SPELL|MIND,
     5,
     12,
     "BUG - charm",
     "    .",
     "BUG - charm",
     0,
     "  ,    ."
 },
 {
     "chill touch",
     {  4,102,6,6 },
     { 1,1,2,2},
     spell_chill_touch,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|WATER,
     15,
     12,
     " ",
     " .",
     "BUG - chill touch",
     0,
     "   .  ."
 },
 {
     "colour spray",
     { 16,102,22,20 },
     { 1,1,2,2},
     spell_colour_spray,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     15,
     12,
     " ",
     "!Colour Spray!",
     "BUG - colour spray",
     0,
     "    ()."
 },
 {
     "continual light",
     {  6,4,6,9 },
     { 1,1,2,2},
     spell_continual_light,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|AIR,
     7,
     12,
     "BUG - continual light",
     "BUG - Continual Light",
     "BUG - continual light",
     0,
     "       ."
 },
 {
     "control weather",
     { 15,19,28,22 },
     { 1,1,2,2},
     spell_control_weather,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|AIR,
     25,
     12,
     "BUG - control weather",
     "BUG - Control Weather",
     "BUG - control weather",
     0,
     "   .    ."
 },
 {
     "create food",
     { 10,5,11,12 },
     { 1,1,2,2},
     spell_create_food,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|EARTH,
     5,
     12,
     "",
     "!Create Food!",
     "",
     0,
     "  ."
 },
 {
     "create rose",
     { 16,11,10,24 },
     { 1,1,2,2 },
     spell_create_rose,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE,
     30,
     12,
     "",
     "!Create Rose!",
     "",
     0,
     " ."
 },
 {
     "create spring",
     { 14,17,23,20 },
     { 1,1,2,2},
     spell_create_spring,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|WATER,
     5,
     12,
     "",
     "!Create Spring!",
     "",
     0,
     "   ."
 },
 {
     "create water",
     { 8,3,12,11 },
     { 1,1,2,2},
     spell_create_water,
     TAR_OBJ_CHAR_DEF,
     POS_STANDING,
     NULL,
     SPELL|MAKE|WATER,
     5,
     24,
     "",
     "!Create Water!",
     "",
     0,
     "  ."
 },
 {
     "cure blindness",
     { 102,6,102,102 },
     { 1,1,2,2},
     spell_cure_blindness,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     5,
     12,
     "",
     "!Cure Blindness!",
     "",
     0,
     "  ."
 },
 {
     "cure critical",
     { 102,30,102,50 },
     { 1,1,2,2},
     spell_cure_critical,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     20,
     12,
     "",
     "!Cure Critical!",
     "",
     0,
     "  ."
 },
 {
     "cure disease",
     { 102,13,102,102 },
     { 1,1,2,2},
     spell_cure_disease,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE|WATER,
     20,
     12,
     "",
     "!Cure Disease!",
     "",
     0,
     "    ."
 },
 {
     "cure light",
     { 102,1,102,5 },
     { 1,1,2,2},
     spell_cure_light,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     10,
     12,
     "",
     "!Cure Light!",
     "",
     0,
     "  ."
 },
 {
     "cure poison",
     { 102,14,102,102 },
     { 1,1,2,2},
     spell_cure_poison,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE|WATER,
     5,
     12,
     "",
     "!Cure Poison!",
     "",
     0,
     "  ."
 },
 {
     "cure serious",
     { 102,15,102,23 },
     { 1,1,2,2},
     spell_cure_serious,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     15,
     12,
     "",
     "!Cure Serious!",
     "",
     0,
     "   ."
 },
 {
     "curse",
     { 18,18,26,22 },
     { 1,1,2,2},
     spell_curse,
     TAR_OBJ_CHAR_OFF,
     POS_FIGHTING,
     &gsn_curse,
     SPELL|DARK,
     20,
     12,
     "curse",
     "  .",
     "  $i6 .",
     0,
     "       .{/    ."
 },
 {
     "demonfire",
     { 102,34,102,102 },
     { 1,1,2,2},
     spell_demonfire,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|DARK|FIRE,
     20,
     12,
     " ",
     "!Demonfire!",
     "",
     0,
     "   ,  ."
 },
 {
     "detect evil",
     { 11,4,12,102 },
     { 1,1,2,2},
     spell_detect_evil,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|LEARN,
     5,
     12,
     "detect evil",
     "     .",
     "",
     0,
     "    ."
 },
 {
     "detect good",
     { 11,4,12,102 },
     { 1,1,2,2},
     spell_detect_good,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|LEARN,
     5,
     12,
     "detect good",
     "     .",
     "",
     0,
     "    ."
 },
 {
     "detect hidden",
     { 15,11,12,102 },
     { 1,1,2,2},
     spell_detect_hidden,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|PERCEP,
     5,
     12,
     "detect hidden",
     "   .",
     "",
     0,
     "   ."
 },
 {
     "detect magic",
     {  2,6,5,102 },
     { 1,1,2,2},
     spell_detect_magic,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|LEARN,
     5,
     12,
     "detect magic",
     "     .",
     "",
     0,
     "   ."
 },
 {
     "detect poison",
     { 15,7,9,102 },
     { 1,1,2,2},
     spell_detect_poison,
     TAR_OBJ_INV,
     POS_STANDING,
     NULL,
     SPELL|LEARN|WATER,
     5,
     12,
     "",
     "!Detect Poison!",
     "",
     0,
     "   ."
 },
 {
     "detect invis",
     {  3,8,6,102 },
     { 1,1,2,2},
     spell_detect_invis,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|LEARN|AIR,
     5,
     12,
     " ",
     "    .",
     "",
     0,
     "  ."
 },
 {
     "dispel evil",
     { 102,15,102,102 },
     { 1,1,2,2},
     spell_dispel_evil,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     15,
     12,
     " ",
     "!Dispel Evil!",
     "",
     0,
     ""
 },
 {
     "dispel good",
     { 102,15,102,102 },
     { 1,1,2,2},
     spell_dispel_good,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|DARK,
     15,
     12,
     " ",
     "!Dispel Good!",
     "",
     0,
     ""
 },
 {
     "dispel magic",
     { 16,24,30,30 },
     { 1,1,2,2},
     spell_dispel_magic,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|SPIRIT|LEARN,
     15,
     12,
     "",
     "!Dispel Magic!",
     "",
     0,
     "   ."
 },
 {
     "earthquake",
     { 102,10,102,102 },
     { 1,1,2,2},
     spell_earthquake,
     TAR_IGNORE_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|EARTH,
     15,
     12,
     "",
     "!Earthquake!",
     "",
     0,
     " ,   ."
 },
 {
     "enchant armor",
     { 16,102,102,102 },
     { 2,2,4,4 },
     spell_enchant_armor,
     TAR_OBJ_INV,
     POS_STANDING,
     NULL,
     SPELL|MAKE|PROTECT,
     100,
     24,
     "",
     "!Enchant Armor!",
     "",
     0,
     "   ."
 },
 {
     "enchant weapon",
     { 17,102,102,102 },
     { 2,2,4,4},
     spell_enchant_weapon,
     TAR_OBJ_INV,
     POS_STANDING,
     NULL,
     SPELL|MAKE,
     100,
     24,
     "",
     "!Enchant Weapon!",
     "$i1    .",
     0,
     "     ."
 },
 {
     "energy drain",
     { 19,22,26,23 },
     { 1,1,2,2},
     spell_energy_drain,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|DARK|SPIRIT,
     35,
     12,
     " ",
     "!Energy Drain!",
     "",
     0,
     " ,    .{/   ."
 },
 {
     "faerie fire",
     {  6,3,5,8 },
     { 1,1,2,2},
     spell_faerie_fire,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|FIRE,
     5,
     12,
     "faerie fire",
     "    .",
     "",
     0,
     "   ."
 },
 {
     "faerie fog",
     { 14,21,16,24 },
     { 1,1,2,2},
     spell_faerie_fog,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|FIRE|AIR,
     12,
     12,
     "faerie fog",
     "!Faerie Fog!",
     "",
     0,
     "      ."
 },
 {
     "farsight",
     { 14,16,16,102 },
     { 1,1,2,2},
     spell_farsight,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|AIR|PERCEP,
     36,
     20,
     "farsight",
     "    .",
     "   $i2  .",
     0,
     "    (  scan)."
 },
 {
     "fireball",
     { 28,102,34,32 },
     { 1,1,2,2},
     spell_fireball,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|FIRE,
     15,
     12,
     " ",
     "!Fireball!",
     "",
     0,
     "   ."
 },
 {
     "fireproof",
     { 13,12,19,18 },
     { 1,1,2,2},
     spell_fireproof,
     TAR_OBJ_HERE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|FIRE|PROTECT,
     10,
     12,
     "fireproof",
     "",
     "   $i2 .",
     0,
     "   ."
 },
 {
     "flamestrike",
     { 102,20,102,102 },
     { 1,1,2,2},
     spell_flamestrike,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|FIRE,
     20,
     12,
     " ",
     "!Flamestrike!",
     "",
     0,
     "   ."
 },
 {
     "fly",
     { 10,18,20,22 },
     { 1,1,2,2},
     spell_fly,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|AIR,
     10,
     18,
     "fly",
     "    .",
     "",
     0,
     " ."
 },
 {
     "floating disc",
     {  4,10,7,16 },
     { 1,1,2,2},
     spell_floating_disc,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|AIR,
     40,
     24,
     "",
     "!Floating disc!",
     "",
     0,
     "   ."
 },
 {
     "frenzy",
     { 102,24,102,26 },
     { 1,1,2,2},
     spell_frenzy,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|SPIRIT,
     30,
     24,
     "frenzy",
     "  .",
     "",
     0,
     "   ,     , {/   ."
 },
 {
     "gate",
     { 27,17,32,28 },
     { 1,1,2,2},
     spell_gate,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     SPELL|MIND,
     80,
     12,
     "",
     "!Gate!",
     "",
     0,
     "      ."
 },
 {
     "giant strength",
     {  11,19,22,20 },
     { 1,1,2,2},
     spell_giant_strength,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE|EARTH,
     20,
     12,
     "giant strength",
     "   .",
     "",
     0,
     " ."
 },
 {
     "harm",
     { 102,65,102,102 },
     { 1,1,2,2},
     spell_harm,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     35,
     12,
     " ",
     "!Harm!",
     "",
     C_NODUAL,
     "  ,    ."
 },
 {
     "haste",
     { 21,23,26,29 },
     { 1,1,2,2},
     spell_haste,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     30,
     12,
     "haste",
     "  .",
     "",
     0,
     "     ."
 },
 {
     "heal",
     { 102,35,102,50 },
     { 1,1,2,2},
     spell_heal,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     50,
     12,
     "",
     "!Heal!",
     "",
     0,
     " ."
 },
 {
     "heat metal",
     { 102,16,102,102 },
     { 1,1,2,2 },
     spell_heat_metal,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|MIND|FIRE,
     25,
     18,
     "",
     "!Heat Metal!",
     "",
     0 ,
     "    , {/ ,   ."
 },
 {
     "holy word",
     { 102,36,102,42 },
     { 2,2,4,4},
     spell_holy_word,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT|SPIRIT,
     200,
     24,
     " ",
     "!Holy Word!",
     "",
     0 ,
     "    ."
 },
 {
     "identify",
     { 15,16,18,102 },
     { 1,1,2,2},
     spell_identify,
     TAR_OBJ_HERE,
     POS_STANDING,
     NULL,
     SPELL|LEARN,
     12,
     24,
     "",
     "!Identify!",
     "",
     0 ,
     "   ."
 },
 {
     "infravision",
     {  9,13,10,16 },
     { 1,1,2,2},
     spell_infravision,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL,
     5,
     18,
     "infravision",
     "     .",
     "",
     0 ,
     "    ."
 },
 {
     "invisibility",
     {  5,102,9,102 },
     { 1,1,2,2},
     spell_invis,
     TAR_OBJ_CHAR_DEF,
     POS_STANDING,
     &gsn_invis,
     SPELL|AIR,
     5,
     12,
     "invis",
     "  .",
     "$i1   .",
     0,
     " ."
 },
 {
     "know person",
     {  12,9,20,102 },
     { 1,1,2,2},
     spell_know_person,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LEARN,
     9,
     12,
     "",
     "!Know person!",
     "",
     0,
     "     ."
 },
 {
     "lightning bolt",
     {  13,23,18,16 },
     { 1,1,2,2},
     spell_lightning_bolt,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     15,
     12,
     " ",
     "!Lightning Bolt!",
     "",
     0,
     "  ."
 },
 {
     "locate object",
     {  9,15,11,102 },
     { 1,1,2,2},
     spell_locate_object,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|LEARN|AIR,
     20,
     18,
     "",
     "!Locate Object!",
     "",
     0,
     "  ."
 },
 {
     "magic missile",
     {  1,102,2,2 },
     { 1,1,2,2},
     spell_magic_missile,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     15,
     12,
     " ",
     "!Magic Missile!",
     "",
     0,
     "   ."
 },
 {
     "mass healing",
     { 102,38,102,46 },
     { 2,2,4,4},
     spell_mass_healing,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR|CURATIVE,
     100,
     12,
     "",
     "!Mass Healing!",
     "",
     0,
     "       ."
 },
 {
     "mass invis",
     { 22,25,31,102 },
     { 1,1,2,2},
     spell_mass_invis,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_mass_invis,
     SPELL|AIR,
     20,
     12,
     "",
     "  .",
     "",
     0,
     "     ."
 },
 {
     "nexus",
     { 40,35,50,45 },
     { 2,2,4,4},
     spell_nexus,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|AIR,
     150,
     36,
     "",
     "!Nexus!",
     "",
     0,
     "  "
 },
 {
     "observation",
     { 40,50,45,102 },
     { 1,1,1,2},
     spell_observation,
     TAR_CHAR_ROOM,
     POS_STANDING,
     NULL,
     SPELL|LEARN|MIND,
     60,
     12,
     "",
     "!Observation!",
     "",
     0,
     "    -."
 },
 {
     "pass door",
     { 24,32,25,37 },
     { 1,1,2,2},
     spell_pass_door,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE|AIR,
     20,
     12,
     "pass door",
     "    .",
     "",
     0,
     "   ."
 },
 {
     "plague",
     { 23,17,36,26 },
     { 1,1,2,2},
     spell_plague,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     &gsn_plague,
     SPELL|WATER,
     20,
     12,
     "plague",
     "  .",
     "",
     0,
     " ."
 },
 {
     "poison",
     { 17,12,15,21 },
     { 1,1,2,2},
     spell_poison,
     TAR_OBJ_CHAR_OFF,
     POS_FIGHTING,
     &gsn_poison,
     SPELL|WATER,
     10,
     12,
     "poison",
     "   .",
     "  $i6 .",
     0,
     " -  -."
 },
 {
     "portal",
     { 35,30,45,40 },
     { 2,2,4,4},
          spell_portal,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|AIR,
     100,
     24,
     "",
     "!Portal!",
     "",
     0,
     "  ."
 },
 {
     "protection evil",
     { 12,9,17,11 },
     { 1,1,2,2},
     spell_protection_evil,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|LIGHT|PROTECT,
     5,
     12,
     "protection evil",
     "     .",
     "",
     0,
     "  "
 },
 {
     "protection good",
     { 12,9,17,11 },
     { 1,1,2,2},
     spell_protection_good,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|DARK|PROTECT,
     5,
     12,
     "protection good",
     "    .",
     "",
     0,
     "  "
 },
 {
     "ray of truth",
     { 102,35,102,102 },
     { 1,1,2,2},
     spell_ray_of_truth,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     20,
     12,
     " ",
     "!Ray of Truth!",
     "",
     0,
     "    .  ."
 },
 {
     "recharge",
     { 9,102,102,102 },
     { 1,1,2,2 },
     spell_recharge,
     TAR_OBJ_HERE,
     POS_STANDING,
     NULL,
     SPELL|MAKE,
     60,
     24,
     "",
     "!Recharge!",
     "",
     0,
     " ."
 },
 {
     "refresh",
     {  8,5,12,9 },
     { 1,1,2,2},
     spell_refresh,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|CURATIVE,
     12,
     18,
     "refresh",
     "!Refresh!",
     "",
     0,
     " "
 },
 {
     "remove curse",
     { 102,18,102,22 },
     { 1,1,2,2},
     spell_remove_curse,
     TAR_OBJ_CHAR_DEF,
     POS_STANDING,
     NULL,
     SPELL|LIGHT,
     5,
     12,
     "",
     "!Remove Curse!",
     "",
     0,
     " ."
 },
 {
     "sanctuary",
     { 36,20,42,30 },
     { 1,1,2,2},
     spell_sanctuary,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|PROTECT,
     75,
     12,
     "sanctuary",
     " Sanctuary    .",
     "",
     0,
     "     ."
 },
 {
     "shield",
     { 16,35,60,75 },
     { 1,1,2,2},
     spell_shield,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|PROTECT,
     75,
     18,
     "shield",
     ",  , .",
     "",
     0 ,
     "    ,  Armor Class"
 },
 {
     "shocking grasp",
     {  10,102,14,13 },
     { 1,1,2,2},
     spell_shocking_grasp,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|WATER,
     15,
     12,
     " ",
     "!Shocking Grasp!",
     "",
     0 ,
     ""
 },
 {
     "sleep",
     { 10,102,11,102 },
     { 1,1,2,2},
     spell_sleep,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     &gsn_sleep,
     SPELL|MIND,
     15,
     12,
     "sleep",
     "      .",
     "",
     0 ,
     " ."
 },
 {
     "slow",
     { 23,30,29,32 },
     { 1,1,2,2},
     spell_slow,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|EARTH,
     30,
     12,
     "slow",
     "   .",
     "",
     0 ,
     " ."
 },
 {
     "ensnare",
     { 55,102,102,102 },
     { 2,2,2,2},
     spell_ensnare,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|EARTH,
     65,
     12,
     "ensnare",
     "    .",
     "",
     0
 },
 {
     "stone skin",
     { 25,40,40,45 },
     { 1,1,2,2},
     spell_stone_skin,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|EARTH|PROTECT,
     12,
     18,
     "stone skin",
     "   .",
     "",
     0 ,
     "    ."
 },
 {
     "summon",
     { 24,12,29,22 },
     { 1,1,2,2},
     spell_summon,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|SPIRIT,
     50,
     12,
     "",
     "!Summon!",
     "",
     0 ,
     "       ."
 },
 {
     "teleport",
     {  13,22,25,36 },
     { 1,1,2,2},
     spell_teleport,
     TAR_CHAR_SELF,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     35,
     12,
     "",
     "!Teleport!",
     "",
     0 ,
     "  ."
 },
 {
     "ventriloquate",
     {  1,102,2,102 },
     { 1,1,2,2},
     spell_ventriloquate,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|AIR,
     5,
     12,
     "",
     "!Ventriloquate!",
     "",
     0 ,
     "   ."
 },
 {
     "weaken",
     {  11,14,16,17 },
     { 1,1,2,2},
     spell_weaken,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|SPIRIT,
     20,
     12,
     "weaken",
     " ,     .",
     "",
     0 ,
     "   ."
 },
 {
     "word of recall",
     { 32,28,40,30 },
     { 1,1,2,2},
     spell_word_of_recall,
     TAR_CHAR_SELF,
     POS_RESTING,
     NULL,
     SPELL|SPIRIT,
     5,
     12,
     "",
     "!Word of Recall!",
     "",
     0 ,
     "  ."
 },
 {
     "acid breath",
     { 56,102,102,102 },
     { 1,1,2,2},
     spell_acid_breath,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|WATER,
     100,
     24,
     " ",
     "!Acid Breath!",
     "",
     C_NODUAL ,
     "  ."
 },
 {
     "fire breath",
     { 75,102,102,102 },
     { 1,1,2,2},
     spell_fire_breath,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|FIRE,
     200,
     24,
     " ",
     "    .",
     "",
     C_NODUAL ,
     "  ."
 },
 {
     "frost breath",
     { 70,102,102,102 },
     { 1,1,2,2},
     spell_frost_breath,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|WATER,
     125,
     24,
     " ",
     "!Frost Breath!",
     "",
     C_NODUAL ,
     "  ."
 },
 {
     "gas breath",
     { 50,102,102,102 },
     { 1,1,2,2},
     spell_gas_breath,
     TAR_IGNORE_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     175,
     24,
     " ",
     "!Gas Breath!",
     "",
     C_NODUAL ,
     "  ."
 },
 {
     "lightning breath",
     { 68,102,102,102 },
     { 1,1,2,2},
     spell_lightning_breath,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|AIR,
     150,
     24,
     " ",
     "!Lightning Breath!",
     "",
     C_NODUAL ,
     " ."
 },
 {
     "sunray",
     { 45,45,60,60 },
     { 1,1,2,2},
     spell_sunray,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|LIGHT,
     20,
     12,
     " ",
     "!Sunray!",
     "",
     0,
     "   ."
 },
 {
     "spirit lash",
     {102,4,102,102 },
     { 1,1,2,2},
     spell_spirit_lash,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL|SPIRIT,
     15,
     12,
     " ",
     "!Spirit Lash!",
     "",
     0,
     ""
 },
 {
     "black cloud",
     { 28,75,102,102},
     { 2,4,0,0},
     spell_bcloud,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|AIR,
     150,
     15,
     "black cloud",
     "",
     "",
     0,
     "   ,  ."
 },
 {
     "distortion",
     { 67,102,102,102},
     { 4,0,0,0},
     spell_distortion,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MIND,
     250,
     24,
     "distortion",
     "    .",
     "",
     0,
     "    ."
 },
 {
     "oasis",
     { 25,  5,102,102},
     { 4,1,0,0},
     spell_oasis,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE,
     100,
     24,
     "oasis",
     "bug - oasis",
     "",
     0,
     "   ."
 },
 {
     "mind blast",
     { 52,102,102,102 },
     { 1,1,2,2},
     spell_mind_blast,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     150,
     24,
     " ",
     "!Mind Blast!",
     "",
     C_NODUAL ,
     " ."
 },

 {
     "mind channel",
     { 5, 25,102,102},
     { 1,4,0,0},
     spell_mind_ch,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MIND,
     100,
     24,
     "BUG mind channel",
     "BUG mind channel",
     "",
     0,
     "    ."
 },
 {
     "resurrect",
     { 102,12,102,102 },
     { 5,1,12,15},
     spell_resurrect,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MAKE|DARK,
     70,
     15,
     "",
     "!Resurrect!",
     "",
     0,
     "   ."
 },

// Spells for mega1.are from Glop/Erkenbrand.
 {
     "general purpose",
     { 102,102,102,102 },
     { 0,0,0,0 },
     spell_general_purpose,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     0,
     0,
     12,
     "",
     "!General Purpose Ammo!",
     "",
     0 ,
     ""
 },
 {
     "high explosive",
     { 102,102,102,102 },
     { 0,0,0,0 },
     spell_high_explosive,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     0,
     0,
     12,
     " ",
     "!High Explosive Ammo!",
     "",
     0 ,
     ""
 },
 {
     "regeneration",
     { 7,12,15,5 },
     { 5,6,7,4},
     spell_regeneration,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|CURATIVE,
     100,
     12,
     "regeneration",
     "    .",
     "",
     0,
     "     ."
 },
 {
     "fireshield",
     { 7,10,102,102 },
     { 3,5,0,0},
     spell_fireshield,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|FIRE|PROTECT,
     50,
     12,
     "fireshield",
     "  .",
     "",
     0,
     "      ."
 },
 {
     "nostalgia",
     {102,102,102,102},
     { 0,0,0,0},
     spell_null,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     NULL,
     0,
     0,
     0,
     "nostalgia",
     "",
     "",
      0,
     ""
 },
 {
     "vbite",
     {102,102,102,102},
     { 0,0,0,0},
     spell_null,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     NULL,
     0,
     0,
     0,
     "vbite",
     "",
     "",
      0,
     " ."
 },
 {
     "fear",
     {102,102,102,102},
     { 0,0,0,0},
     spell_null,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     NULL,
     0,
     0,
     0,
     "fear",
     "  .",
     "",
     0,
     "   ."
 },
/*
 {
     "spook",
     {35,35,35,35},
     { 2,2,2,2},
     spell_spook,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     50,
     12,
     "spook",
     "    .",
     "",
     S_CLAN,
     ""
 },
 {
     "breath of death",
     {40,40,40,40},
     { 2,2,2,2},
     spell_breath_death,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     60,
     24,
     "breath death",
     "!breath of death!",
     "",
      S_CLAN,
     ""
 },
 {
     "death eyes",
     {30,30,30,30},
     {2,2,2,2},
     spell_eyes_death,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|MIND,
     75,
     12,
     "death eyes",
     "!eyes of death!",
     "",
     S_CLAN,
     "  ."
 },
*/
 {
     "wbreath",
     {  10,7,102,102 },
     { 1,1,0,0},
     spell_wbreath,
     TAR_CHAR_DEFENSIVE,
     POS_STANDING,
     NULL,
     SPELL,
     10,
     7,
     "wbreath",
     "      .",
     "",
     0,
     "   ."
 },
 {
     "magic web",
     {45,102,102,102},
     { 2,4,0,0},
     spell_magic_web,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     NULL,
     SPELL,
     100,
     24,
     "magic web",
     "",
     "",
      0,
     "   ."
 },
 {
     "evil presence",
     {65,102,102,102},
     { 4,0,0,0},
     spell_evil_presence,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|DARK,
     150,
     24,
     "!evil presence!",
     "   {{x  .",
     "",
      0,
     "     ."
 },
 {
     "life stream",
     {102,65,102,102},
     { 0,5,0,0},
     spell_life_stream,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     SPELL|LIGHT,
     250,
     24,
     "",
     "    .",
     "",
     0,
     "   .  'evil presence'."
 },
 {
     "mummy",
     {66,66,102,102},
     { 6,6,0,0},
     spell_mummy,
     TAR_CHAR_OFFENSIVE,
     POS_STANDING,
     NULL,
     SPELL|DARK,
     666,
     36,
     "",
     "",
     " ,     .",
     0,
     "   ."
 },
 {
     "gaseous form",
     {35,102,102,102},
     { 4,0,0,0},
     spell_gaseous_form,
     TAR_CHAR_SELF,
     POS_STANDING,
     NULL,
     SPELL|MIND,
     750,
     24,
     "!BUG gaseous!",
     "   ...",
     "!BUG gaseous!",
     S_CLAN,
     "    ."
 },
 {
     "shine of heaven",
     {30,30,30,30},
     { 4,4,4,4},
     spell_shine_of_heaven,
     TAR_CHAR_DEFENSIVE,
     POS_FIGHTING,
     NULL,
     SPELL,
     30,
     24,
     " ",
     "      .",
     "!BUG shine of heaven!",
     S_CLAN,
     "  ."
 },

// {
//   "Skill Name",                       //  
//   { mag_lvl,cle_lvl,thi_lvl,war_lvl}, //    MCTW
//   {learn,learn,learn,learn},          //  
//   spell_pointer,                      //   
//   legal_targets,                      //   TARGET
//   position,                           //  
//   &gsn,                               // &gsn
//   category,                           //  
//   min_mana,                           //    
//   wait_time,                          // wait_time
//   "damage msg",                       //   
//   "wear off msg",                     //    
//   "wear off obj msg",                 // .    
//   Flag,                               // 
//   "brief help"                        //  
// },
// combat and weapons skills
 {
     "axe",
     { 1,1,1,1 },
     { 6,6,5,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_axe,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Axe!",
     "",
     0 ,
     ""
 },
 {
     "dagger",
     {  1,1,1,1 },
     { 2,3,2,2},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_dagger,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Dagger!",
     "",
     0 ,
     ""
 },
 {
     "flail",
     { 1,1,1,1 },
     { 6,3,6,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_flail,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Flail!",
     "",
     0 ,
     ""
 },
 {
     "mace",
     { 1,1,1,1 },
     { 5,2,3,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_mace,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Mace!",
     "",
     0 ,
     ""
 },
 {
     "polearm",
     { 1,1,1,1 },
     { 6,6,6,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_polearm,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Polearm!",
     "",
     0 ,
     ""
 },
 {
     "shield block",
     { 1,1,1,1 },
     { 6,4,6,2},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_shield_block,
     SKILL|PROTECT,
     0,
     0,
     "",
     "!Shield!",
     "",
     C_NODUAL ,
     ""
 },
 {
     "spear",
     {  1,1,1,1 },
     { 4,4,4,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_spear,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Spear!",
     "",
     0 ,
     ""
 },
 {
     "staff",
     {  1,1,1,1 },
     { 4,4,4,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_staff,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Staff!",
     "",
     0 ,
     ""
 },
 {
     "sword",
     { 1,1,1,1},
     { 5,6,3,2},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_sword,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!sword!",
     "",
     0 ,
     ""
 },
 {
     "whip",
     { 1,1,1,1},
     { 6,5,5,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_whip,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Whip!",
     "",
     0 ,
     ""
 },
 {
     "missile weapons",
     { 12,10,4,6},
     { 6,5 ,4,5},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_missile,
     SKILL|OFFENCE,
     0,
     24,
     "  ",
     "!missile!",
     "",
     0 ,
     ""
 },
 {
     "backstab",
     { 102,102,1,102 },
     { 0,0,4,0},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_backstab,
     SKILL|PERCEP|OFFENCE,
     0,
     24,
     "  ",
     "!Backstab!",
     "",
     0 ,
     ""
 },
 {
     "bash",
     { 102,102,102,1 },
     { 0,0,0,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_bash,
     SKILL|OFFENCE,
     0,
     24,
     "",
     "!Bash!",
     "",
     0 ,
     ""
 },
 {
     "strangle",
     { 102 ,102 ,25,102 },
     { 0,0,5,0},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_strangle,
     SKILL|OFFENCE,
     0,
     12,
     "",
     "   ",
     "",
     0 ,
     ""
 },
 {
     "berserk",
     { 102,102,102,18 },
     { 0,0,0,5},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_berserk,
     SKILL|FORTITUDE,
     0,
     24,
     "berserk",
     "  .",
     "",
     0 ,
     ""
 },
 {
     "cleave",
     { 102,102,102,38},
     { 0,0,0,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_cleave,
     SKILL|FORTITUDE,
     0,
     24,
     "",
     "!Cleave!",
     "",
     0 ,
     ""
 },
 {
     "dirt kicking",
     { 102,102,3,3 },
     { 0,0,4,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_dirt,
     SKILL|OFFENCE,
     0,
     24,
     " ",
     "    .",
     "",
     0 ,
     ""
 },
 {
     "disarm",
     { 102,102,12,11 },
     { 0,0,5,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_disarm,
     SKILL|OFFENCE,
     0,
     24,
     "",
     "!Disarm!",
     "",
     0 ,
     ""
 },
 {
     "dodge",
     { 20,22,1,13 },
     { 8,8,3,6},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_dodge,
     SKILL|PROTECT,
     0,
     0,
     "",
     "!Dodge!",
     "",
     0 ,
     ""
 },
 {
     "enhanced damage",
     { 102,102,102,1 },
     { 0,0,0,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_enhanced_damage,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Enhanced Damage!",
     "",
     0,
     ""
 },
 {
     "envenom",
     { 102,102,10,102 },
     { 0,0,4,0 },
     spell_null,
     TAR_IGNORE,
     POS_RESTING,
     &gsn_envenom,
     SKILL|WATER,
     0,
     36,
     "",
     "!Envenom!",
     "",
     0 ,
     ""
 },
 {
     "hand to hand",
     { 25,10,15,6 },
     { 8,5,6,4},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_hand_to_hand,
     SKILL|OFFENCE,
     0,
     0,
     "",
     "!Hand to Hand!",
     "",
     0,
     ""
 },
 {
     "kick",
     { 102,12,14,8 },
     { 0,4,6,3},
     spell_null,
     TAR_CHAR_OFFENSIVE,
     POS_FIGHTING,
     &gsn_kick,
     SKILL|OFFENCE,
     0,
     12,
     " ",
     "!Kick!",
     "",
     0,
     ""
 },
 {
     "parry",
     { 22,20,13,1 },
     { 8,8,6,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_parry,
     SKILL|PROTECT,
     0,
     0,
     "",
     "!Parry!",
     "",
     0 ,
     ""
 },
 {
     "pray",
     { 102,1,102,102 },
     { 0,5,0,0},
     spell_null,
     TAR_CHAR_SELF,
     POS_FIGHTING,
     &gsn_pray,
     SKILL|SPIRIT,
     0,
     12,
     "pray",
     "      .",
     "",
     0 ,
     ""
 },
 {
     "dual weapon",
     { 102,102,54,36},
     { 0,0,8,6},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_dual,
     SKILL,
     0,
     0,
     "",
     "!Dual!",
     "",
     0 ,
     ""
 },
 {
     "second dual attack",
     { 102,102,60,40},
     { 0,0,4,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_dual_sec_attack,
     SKILL,
     0,
     0,
     "",
     "!SDual!",
     "",
     0 ,
     ""
 },
 {
     "rescue",
     { 102,102,102,1 },
     { 0,0,0,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_rescue,
     SKILL|PROTECT,
     0,
     0,
     "",
     "!Rescue!",
     "",
     0 ,
     ""
 },
 {
     "trip",
     { 102,102,1,15 },
     { 0,0,3,8},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_trip,
     SKILL|OFFENCE,
     0,
     24,
     "",
     "!Trip!",
     "",
     0 ,
     ""
 },
 {
     "second attack",
     { 30,24,12,5 },
     { 10,8,4,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_second_attack,
     SKILL,
     0,
     0,
     "",
     "!Second Attack!",
     "",
     0 ,
     ""
 },
 {
     "third attack",
     { 102,102,24,12 },
     { 0,0,10,3},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_third_attack,
     SKILL,
     0,
     0,
     "",
     "!Third Attack!",
     "",
     0 ,
     ""
 },
 {
     "frame",
     { 102,102,6,102 },
     { 0,0,5,0},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_frame,
     SKILL,
     0,
     24,
     "",
     "!Frame!",
     "",
     0 ,
     ""
 },

/* non-combat skills */
 {
     "fast healing",
     { 102,102,16,6 },
     { 0,0,6,4},
     spell_null,
     TAR_IGNORE,
     POS_SLEEPING,
     &gsn_fast_healing,
     SKILL|FORTITUDE,
     0,
     0,
     "",
     "!Fast Healing!",
     "",
     0 ,
     ""
 },
 {
     "haggle",
     { 7,18,1,14 },
     { 5,8,3,6},
     spell_null,
     TAR_IGNORE,
     POS_RESTING,
     &gsn_haggle,
     SKILL,
     0,
     0,
     "",
     "!Haggle!",
     "",
     0 ,
     ""
 },
 {
     "hide",
     { 102,102,1,102 },
     { 0,0,4,0},
     spell_null,
     TAR_IGNORE,
     POS_RESTING,
     &gsn_hide,
     SKILL,
     0,
     6,
     "",
     "!Hide!",
     "",
     0 ,
     ""
 },
 {
     "lore",
     { 10,10,6,20 },
     { 4,6,4,8},
     spell_null,
     TAR_IGNORE,
     POS_RESTING,
     &gsn_lore,
     SKILL|LEARN,
     0,
     36,
     "",
     "!Lore!",
     "",
     0 ,
     ""
 },
 {
     "meditation",
     {  6,6,102,102 },
     { 5,5,0,0},
     spell_null,
     TAR_IGNORE,
     POS_SLEEPING,
     &gsn_meditation,
     SKILL|SPIRIT,
     0,
     0,
     "",
     "Meditation",
     "",
     0 ,
     ""
 },
 {
     "morph",
     { 28,102,23,102},
     { 5,0,7,0},
     spell_null,
     TAR_CHAR_SELF,
     POS_RESTING,
     NULL,
     SKILL|MAKE|MIND,
     0,
     12,
     "morph",
     "!Morph!",
     "",
     0 ,
     ""
 },
 {
     "peek",
     {  8,21,1,14 },
     { 5,7,3,6},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_peek,
     SKILL|PERCEP,
     0,
     0,
     "",
     "!Peek!",
     "",
     0 ,
     ""
 },
 {
     "pick lock",
     { 25,25,7,25 },
     { 8,8,4,8},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_pick_lock,
     SKILL|PERCEP,
     0,
     12,
     "",
     "!Pick!",
     "",
     0 ,
     ""
 },
 {
     "sneak",
     { 102,102,4,102 },
     { 0,0,4,0},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_sneak,
     SKILL,
     0,
     12,
     "sneak",
     "    .",
     "",
     0 ,
     ""
 },
 {
     "steal",
     { 102,102,5,102 },
     { 0,0,4,0},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_steal,
     SKILL|PERCEP,
     0,
     24,
     "",
     "!Steal!",
     "",
     0 ,
     ""
 },
 {
     "shock hit",
     { 102,102,20,102 },
     { 0,0,4,0},
     spell_null,
     TAR_IGNORE,
     POS_DEAD,
     &gsn_shock_hit,
     SKILL|OFFENCE,
     0,
     15,
     "  ",
     "",
     "",
     0,
     ""
 },
 {
     "deaf",
     { 102,102,102,102 },
     { 0,0,0,0},
     spell_null,
     TAR_IGNORE,
     POS_DEAD,
     NULL,
     0,
     0,
     0,
     "deaf",
     "",
     "",
     0,
     ""
 },
 {
     "scrolls",
     {  1,1,1,1 },
     { 2,3,5,8},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_scrolls,
     SKILL|LEARN,
     0,
     24,
     "",
     "!Scrolls!",
     "",
     0 ,
     ""
 },
 {
     "staves",
     {  1,1,1,1 },
     { 2,3,5,8},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_staves,
     SKILL|MAKE,
     0,
     12,
     "",
     "!Staves!",
     "",
     0 ,
     ""
 },
 {
     "wands",
     {  1,1,1,1 },
     { 2,3,5,8},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_wands,
     SKILL|MAKE,
     0,
     12,
     "",
     "!Wands!",
     "",
     0 ,
     ""
 },
 {
     "quenia",
     { 1,1,1,1 },
     { 1,2,5,8},
     spell_null,
     TAR_IGNORE,
     POS_DEAD,
     &gsn_quenia,
     SKILL|LEARN,
     0,
     12,
     "",
     "",
     "",
     0 ,
     ""
 },
 {
     "charge",
     { 48,102,102,102 },
     { 7,0,0,0 },
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_charge,
     SKILL|LEARN|MIND|SPIRIT,
     150,
     36,
     "",
     "!Charge!",
     "",
     0 ,
     ""
 },
 {
     "lash",
     { 40,19,3,5 },
     { 6,4,2,2 },
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_lash,
     SKILL|OFFENCE,
     0,
     12,
     "",
     "!Lash!",
     "",
     0 ,
     ""
 },
 {
     "recall",
     {  1,1,1,1 },
     { 2,2,2,2},
     spell_null,
     TAR_IGNORE,
     POS_STANDING,
     &gsn_recall,
     SKILL,
     0,
     12,
     "",
     "!Recall!",
     "",
     0 ,
     ""
 },
 {
     "blink",
     {  1,102,102,102 },
     { 1,0,0,0},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     &gsn_blink,
     SKILL|PROTECT|MIND,
     0,
     0,
     "",
     "!Blink!",
     "",
     0 ,
     "  -    "
 },
 {
     "spellaffect",
     { 111, 111, 111, 111 },
     { 99, 99, 99, 99},
     0,
     TAR_IGNORE,
     POS_STANDING,
     NULL,
     0,
     0,
     0,
     "",
     "",
     "",
     0,
     "Spellaffect container skill."
 },
 {
     NULL,
     { 102,102,102,102 },
     { 0,0,0,0},
     spell_null,
     TAR_IGNORE,
     POS_FIGHTING,
     NULL,
     0,
     0,
     0,
     "",
     "",
     "",
     0 ,
     "  "
 }
};

const   struct  group_type      group_table     [MAX_GROUP]     =
{

 {
   "rom basics",  { 0, 0, 0, 0 },
   { "scrolls", "staves", "wands", "recall", "word of recall" }
 },

 {
   "mage basics", { 0,-1,-1,-1 },
   { "dagger" }
 },

 {
   "cleric basics", { -1, 0,-1,-1 },
   { "mace",       "pray" }
 },

 {
   "thief basics", { -1,-1, 0,-1 },
   { "dagger", "steal" }
 },

 {
   "warrior basics", { -1,-1,-1, 0 },
   { "sword", "second attack" }
 },

 {
   "mage default", { 40,-1,-1,-1 },
   { "lore", "beguiling", "combat", "detection", "enhancement", "illusion",
     "maladictions", "protective", "transportation", "weather", "blink" }
 },

 {
   "cleric default", { -1,40,-1,-1 },
   { "flail", "attack", "creation", "curative", "benedictions",
     "detection", "healing", "maladictions", "protective", "shield block",
     "transportation", "weather" }
 },

 {
   "thief default", { -1,-1,40,-1 },
   { "mace", "sword", "backstab", "disarm", "dodge", "second attack",
     "trip", "hide", "peek", "pick lock", "sneak" }
 },

 {
   "warrior default", { -1,-1,-1,40 },
   { "weaponsmaster", "shield block", "bash", "disarm", "enhanced damage",
     "parry", "rescue", "third attack" }
 },

 {
   "weaponsmaster", { 40,40,40,20 },
   { "axe", "dagger", "flail", "mace", "polearm", "spear",
     "sword", "whip", "staff", "missile weapons"}
 },

 {
   "attack", { -1, 5,-1,-1 },
   { "demonfire", "dispel evil", "dispel good", "earthquake",
     "flamestrike", "heat metal", "ray of truth" }
 },

 {
   "beguiling", { 4,-1, 6,-1 },
   { "calm", "charm person", "sleep", "aid"}
 },

 {
   "benedictions", { -1, 4,-1, 8 },
   { "bless", "calm", "frenzy", "holy word", "remove curse" }
 },

 {
   "combat", { 5,-1,10, 9 },
   { "acid blast", "burning hands", "chain lightning", "chill touch",
     "colour spray", "fireball", "lightning bolt", "magic missile",
     "shocking grasp"  }
 },

 {
   "creation", { 4, 3, 8, 8 },
   { "continual light", "create food", "create spring", "create water",
     "create rose", "floating disc" }
 },

 {
   "curative", { -1, 4,-1,-1 },
   { "cure blindness", "cure disease", "cure poison" }
 },

 {
   "detection", { 4, 3, 6,-1 },
   { "detect evil", "detect good", "detect hidden","detect invis",
     "detect magic","detect poison", "farsight", "identify",
     "know person", "locate object", "observation" }
 },

 {
   "draconian", { 8,-1,-1,-1 },
   { "acid breath", "fire breath", "frost breath", "gas breath",
     "lightning breath"  }
 },

 {
   "enchantment", { 6,-1,-1,-1 },
   { "enchant armor", "enchant weapon", "fireproof", "recharge" }
 },

 {
   "enhancement", { 4, 7, 9, 9 },
   { "giant strength", "haste", "infravision", "refresh" }
 },

 {
   "harmful", { -1, 3,-1,-1 },
   { "cause critical", "cause light", "cause serious", "harm", "resurrect" }
 },

 {
   "healing", { -1, 3,-1, 6 },
   { "cure critical", "cure light", "cure serious", "heal",
     "mass healing", "refresh", "oasis" }
 },

 {
   "illusion",       { 3,-1, 7,-1 },
   { "invis", "mass invis", "ventriloquate" }
 },

 {
   "maladictions",      { 5, 5, 9, 9 },
   { "blindness", "change sex", "curse", "energy drain", "plague",
     "poison", "slow", "weaken", "spirit lash", "ensnare" }
 },

 {
   "protective",     { 4, 3, 7, 8 },
   { "armor", "cancellation", "dispel magic", "fireproof",
     "protection evil", "protection good", "sanctuary", "shield",
     "stone skin" }
 },

 {
   "transportation",    { 3, 4, 8, 9 },
   { "fly", "gate", "nexus", "pass door", "portal", "summon", "teleport" }
 },

 {
   "weather",     { 4, 3, 8, 8 },
   { "call lightning", "control weather", "faerie fire", "faerie fog",
     "lightning bolt", "sunray" }
 },

 {
   "regeneration",  { 5, 6, 7, 4 },
   { "regeneration" }
 },

 {
   "highmagic",  { 5, 8, -1, -1 },
   { "fireshield", "black cloud", "distortion", "magic web", "wbreath",
     "oasis", "mind channel", "evil presence", "life stream", "mummy",
     "mind blast"  }
 },

 {
   "clan",    { -1, -1, -1, -1 },
   { "peace", "nimbus"}
 }
};

const int pk_range_table[4][4] = {
{ 8, 8, 8, 8 },
{ 5, 8, 8, 8 },
{ 3, 8, 8, 8 },
{ 1, 7, 8, 8 }
};

TOURNAMENT_DATA *tournament=0;

char *GreyEq[MAX_WEAR_L+1]=
{
"{R{r{R {D{x",
"{W {D{x  {m{x",
"{g{x",
"{y{x ",
"{W {g{D{g{D{g{D{g{x {D{x",
"{D{Y 4{x- {d{x",
"{D{X  {d{y {x",
"{R  {Y{d-{C16{x {g\"{DColt{g\"{x",
"{Y {g\"{DDesert Eagle{g\"{x",
"{G {W{x",
"{D{R{D {x {y{x",
"{W {R  {Y{d-{C16{x {g\"{DColt{g\"{x",
"{W {g\"{YCamel{g\" {W {x",
"{y {x {D{R{D {Y{y{R{y{Y{x",
"{g{D{g{D{g{D{g{x {D{x",
"{R {D{x",
"{D {R{r{R{x",
""
};

char *GreyRank[]=
{
"{D{x",
"{Y||{D  {Y||{x",
"{Y**{y  {Y**{x",
"{Y****{w  {Y****{x",
"{Y<{W*{Y>{r  {Y<{W*{Y>{x",
"{Y<{W*{Y><{W*{Y><{W*{Y>{R  {Y<{W*{Y><{W*{Y><{W*{Y>{x",
"{R{W - {R{x"
};
