/*********************************************************************/
/* file: tintin.h - the include file for tintin++                    */
/*                             TINTIN ++                             */
/*          (T)he K(I)cki(N) (T)ickin D(I)kumud Clie(N)t             */
/*                    modified by Bill Reiss 1993                    */
/*                     coded by peter unold 1992                     */
/*********************************************************************/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "../recore/pcre.h"
#include <string>
#include <map>
#include <list>

#include "tintinx.h"
#include "ttobjects.h"


// for the get_arg_in_braces
#define WITH_SPACES 0
#define STOP_SPACES 1


/***********************************************/
/* Some default values you might wanna change: */
/***********************************************/
#define ALPHA 1
#define PRIORITY 0
#define CLEAN 0
#define END 1
#define DEFAULT_OPEN '{' /*character that starts an argument */
#define DEFAULT_CLOSE '}' /*character that ends an argument */
#define MAX_PATH_LENGTH 200               /* max path lenght */
#define DEFAULT_VERBATIM_CHAR '\\'        /* if an input starts with this
                                             char, it will be sent 'as is'
                                             to the MUD */
#define DEFAULT_ECHO FALSE                /* echo */         
#define DEFAULT_IGNORE FALSE              /* ignore */
#define DEFAULT_SPEEDWALK TRUE           /* speedwalk */
#define DEFAULT_PRESUB TRUE               /* presub before actions */
#define DEFAULT_TOGGLESUBS FALSE          /* turn subs on and off FALSE=ON*/

#define DEFAULT_ALIAS_MESS TRUE           /* messages for responses */
#define DEFAULT_ACTION_MESS TRUE          /* when setting/deleting aliases, */
#define DEFAULT_SUB_MESS TRUE             /* actions, etc. may be set to */
#define DEFAULT_ANTISUB_MESS TRUE         /* default either on or off */
#define DEFAULT_HIGHLIGHT_MESS TRUE       /* TRUE=ON FALSE=OFF */
#define DEFAULT_VARIABLE_MESS TRUE        /* might want to turn off these */
#define DEFAULT_GROUP_MESS TRUE
#define DEFAULT_HOTKEY_MESS TRUE

enum {
    MSG_ALIAS = 0, 
    MSG_ACTION,
    MSG_SUB, 
    MSG_ANTISUB, 
    MSG_HIGH,
    MSG_VAR, 
    MSG_GRP, 
    MSG_HOT
};

/**************************************************************************/
/* the codes below are used for highlighting text, and is set for the     */
/* codes for VT-100 terminal emulation. If you are using a different      */
/* teminal type, replace the codes below with the correct codes and       */
/* change the codes set up in highlight.c                                 */
/**************************************************************************/
#define DEFAULT_BEGIN_COLOR "["
#define DEFAULT_END_COLOR "[0m"
/*************************************************************************/
/* The text below is checked for. If it trickers then echo is turned off */
/* echo is turned back on the next time the user types a return          */
/*************************************************************************/
#define PROMPT_FOR_PW_TEXT "assword:"

#define DEFAULT_GROUP_NAME "default" 

/**************************************************************************/ 
/* The stuff below here shouldn't be modified unless you know what you're */
/* doing........                                                          */
/**************************************************************************/ 

/************************ structures *********************/
struct listnode {
  struct listnode *next;
  char *left, *right, *pr;
  char group[32];
};


struct completenode {
  struct completenode *next;
  char *strng;
};


/// ATTENTION ----------------------------------------
#undef isspace
#define isspace(c) (c < 127 && ((c >= 0x9 && c<=0xD) || c == 0x20 ))


extern int verbatim;
extern int echo;
extern int mesvar[8];
extern int acnum,subnum,hinum,antisubnum;
extern int verbose;
extern int presub;
extern int togglesubs;
extern int speedwalk;
extern char verbatim_char;    
extern BOOL bPathing;

extern struct completenode *complete_head;
extern tick_size;
extern int ticker_interrupted;
extern DWORD dwTime0;
extern HWND hwndMAIN;

extern HANDLE hConnThread;

//---------------------------------------------------------

extern std::map<int, TIMER*> TIMER_LIST;



extern BOOL bMultiAction, bMultiHighlight;
extern struct listnode *common_subs;
extern struct listnode *common_antisubs, *common_pathdirs, *common_path;
extern char vars[10][BUFFER_SIZE]; /* the %0, %1, %2,....%9 variables */
extern HANDLE hLogFile;
extern int path_length;
extern int old_more_coming,more_coming;
extern char last_line[BUFFER_SIZE];
extern int ignore;

extern SOCKET MUDSocket;

/* ------ Extern functions implemented in exe file ----- */
/* typedef BOOL (CALLBACK* DLGPROC)(HWND, UINT, WPARAM, LPARAM); */


void tintin_puts2(char *cptr);

void tintin_puts3(char *cptr); // place to output window

/* void EndApplication(); Finish programm imeidiatly ! */
void write_line_mud(char *line);
void  connect_mud(char *host, char *port);
void ShowError (char* strError);

/*==================    Internal functions  ========================*/
void show_list(struct listnode *listhead);
void show_list_action(struct listnode *listhead);
void shownode_list(struct listnode *nptr);
void shownode_list_action(struct listnode *nptr);
struct listnode *searchnode_list( struct listnode *listhead, char *cptr);
void deletenode_list(struct listnode *listhead, struct listnode *nptr);
void insertnode_list(struct listnode *listhead, char *ltext, char *rtext,char *prtext, int mode);
int count_list(struct listnode *listhead);
struct listnode *search_node_with_wild(struct listnode *listhead,char *cptr);
struct listnode *searchnode_list_begin(struct listnode *listhead, char* cptr, int mode);
void kill_list(struct listnode *nptr);
void addnode_list(struct listnode *listhead, char *ltext, char *rtext, char *prtext);

int match(char *regex, char *string);


char *mystrdup(char *s);
char *space_out(char* s);
void add_codes(char *line, char *result, char *htype, BOOL bAddTAil= TRUE);


void tintin_puts(char *cptr);

void substitute_myvars(char *arg, char *result);
int check_one_action(char *line, ACTION *action);
int check_one_action(char* line, char* action);


void parse_input(char *input);

int check_a_action(char *line, char *action);
void parse_antisub(char *arg);
void alias_command(char *arg);
BOOL show_aliases(char* left = NULL, CGROUP* pGroup= NULL);


char *get_arg_in_braces( char *s, char *arg, int flag);
void char_command( char *arg);
int is_abrev( char *s1, char *s2);
void prepare_actionalias( char *string, char *result);
void substitute_vars(char *arg, char *result);
int eval_expression(char *arg);
int conv_to_ints(char *arg);

void cleanup_session(void);
void verbatim_command(char* arg);

int is_speedwalk_dirs(char *cp);

void KillAll(int mode, char* arg);
void bell_command(void);
void cr_command(void);
void echo_command(char* arg);
void end_command(char *command);
void help_command(char *arg);
void parse_high(char *arg);
BOOL show_high(CGROUP* pGroup = NULL);
void if_command(char *line);
void ignore_command(char* arg);
void display_info(void);
void log_command(char *arg);
void loop_command(char *arg);
void map_command(char *arg);
void math_command(char *line);
void mark_command(char *arg);
void message_command(char *arg);
void pathdir_command(char *arg);
void presub_command(char* arg);
void return_command(void);
void showme_command(char *arg);
void speedwalk_command(char* arg);
void read_file(char *arg);
void parse_sub(char *arg);
void tickoff_command(void);
void tickon_command(void);
void tickset_command(void);
void ticksize_command(char *arg);
void tick_command(void);
void ticksize_command(char *arg);
void tolower_command(char *arg);
void togglesubs_command(char* arg);
void toupper_command(char *arg);
void unaction_command(char *arg);
void savepath_command(char *arg);
void unalias_command(char *arg);
void unantisubstitute_command(char *arg);
void unsubstitute_command(char *arg);
void unpath_command(void);
void var_command(char *arg);
void unvar_command(char *arg);
void check_insert_path(char *command);
void path_command(void);
void action_command(char *arg);
BOOL show_actions(char* left = NULL, CGROUP* pGroup = NULL);
void unhighlight_command(char *arg);
void script_command(char *arg);
void write_command(char *filename);
void output_command(char* arg);
void zap_command(void);
void group_command(char* arg);

void tabadd_command(char* arg);
void tabdel_command(char* arg);

void check_all_actions(char *line);
int do_one_antisub(char *line);
void do_one_sub(char *line);
void do_one_high(char *line);

void read_command(char* filename);
void connect_command(char* arg);

void drop_command();

extern int SocketFlags;
extern unsigned char State;
int do_telnet_protecol(unsigned char* cpsource, char* cpdest, int size);


void MultiactionCommand(char* arg);
void MultiHlightCommand(char* arg);
void WriteToLog(char* str, int StrSize ); 
void WriteToLog2(char* str, int StrSize );
void SetHotKey(char* arg);
void Unhotkey(char* arg, BOOL bSilent = FALSE);

struct listnode *init_list(void);
struct listnode *init_pathdir_list(void);

void newactive_session();

void status_command(char* arg);

void ParseScriptlet2(BSTR bstrScriptlet);

//-----------------------------------------------
typedef std::map <std::string, ALIAS*> ALIASLIST ;
typedef ALIASLIST::iterator ALIAS_INDEX ;
extern ALIASLIST AliasList;

typedef std::map <std::string, CGROUP*> GROUPLIST ;
typedef GROUPLIST ::iterator GROUP_INDEX ;
extern GROUPLIST  GroupList;

namespace std
{
    struct greater<ACTION*> : public binary_function<ACTION*, ACTION*, bool> {
    bool operator()(const ACTION*& x, const ACTION*& y) const{return x->m_nPriority < y->m_nPriority; };
    };
}


// typedef list<CActionPtr> ACTIONLIST;
typedef std::list<ACTION*> ACTIONLIST;
typedef ACTIONLIST::iterator ACTION_INDEX;
extern ACTIONLIST ActionList;

extern BOOL bDelayedActionDelete;

typedef std::map <std::string, VAR*> VARLIST;
typedef VARLIST::iterator VAR_INDEX ;
extern VARLIST  VarList;

typedef std::map <std::string, HLIGHT*> HLIGHTLIST ;
typedef HLIGHTLIST::iterator HLIGHT_INDEX ;
extern HLIGHTLIST HlightList;

typedef std::map <WORD, CHotKey*>::iterator HOTKEY_INDEX ;
extern std::map <WORD, CHotKey*> HotkeyList;


extern void* JMCObjRet[1000];

// --CHANGED by Anton Likhtarov for resource support
#include "ressup.h"
// --END
