#ifndef _ACT_MOVEMENT_HPP_
#define _ACT_MOVEMENT_HPP_

#include "structs/structs.h"

class CharData;    // to avoid inclusion
class ObjData;

enum EDoorScmd : int {
	SCMD_OPEN = 0,    // 
	SCMD_CLOSE = 1,   // 
	SCMD_UNLOCK = 2,  // 
	SCMD_LOCK = 3,    // 
	SCMD_PICK = 4  // 
};

enum FD_RESULT : int {
	FD_WRONG_DIR = -1,  // -1  
	FD_WRONG_DOOR_NAME = -2,  // -2      
	FD_NO_DOOR_GIVEN_DIR = -3,  // -3     
	FD_DOORNAME_EMPTY = -4, // -4   
	FD_DOORNAME_WRONG = -5   // -5   
};

void do_doorcmd(CharData *ch, ObjData *obj, int door, EDoorScmd scmd);
void do_gen_door(CharData *ch, char *argument, int cmd, int subcmd);
void do_enter(CharData *ch, char *argument, int cmd, int subcmd);
void do_stand(CharData *ch, char *argument, int cmd, int subcmd);
void do_sit(CharData *ch, char *argument, int cmd, int subcmd);
void do_rest(CharData *ch, char *argument, int cmd, int subcmd);
void do_sleep(CharData *ch, char *argument, int cmd, int subcmd);
void do_wake(CharData *ch, char *argument, int cmd, int subcmd);

int HasKey(CharData *ch, ObjVnum key);
bool HasBoat(CharData *ch);
bool ok_pick(CharData* ch, ObjVnum keynum, ObjData* obj, int door, int scmd);
bool IsCorrectDirection(CharData *ch, int dir, bool check_specials, bool show_msg);

int skip_hiding(CharData *ch, CharData *vict);
int skip_sneaking(CharData *ch, CharData *vict);
int skip_camouflage(CharData *ch, CharData *vict);

#endif // _ACT_MOVEMENT_HPP_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
