/*
 \authors Created by Sventovit
 \date 26.02.2022.
 \brief  ""
 \details  "" -    .   ,     
 .
 */

#include "act_other.h"
#include "color.h"
#include "communication/mail.h"
#include "communication/parcel.h"
#include "entities/char_data.h"
#include "entities/char_player.h"
#include "entities/player_races.h"
#include "game_fight/fight_hit.h"
#include "game_mechanics/bonus.h"
#include "game_mechanics/glory.h"
#include "game_mechanics/glory_const.h"
#include "liquid.h"
#include "structs/global_objects.h"
#include "game_magic/magic.h"

void PrintScoreBase(CharData *ch);
void PrintScoreList(CharData *ch);
void PrintScoreAll(CharData *ch);
void PrintRentableInfo(CharData *ch, std::ostringstream &out);
const char *GetPositionStr(CharData *ch);
const char *GetShortPositionStr(CharData *ch);
int CalcHitroll(CharData *ch);

/* extern */
int CalcAntiSavings(CharData *ch);
int calc_initiative(CharData *ch, bool mode);
TimeInfoData *real_time_passed(time_t t2, time_t t1);
void GetClassWeaponMod(ECharClass class_id, const ESkill skill, int *damroll, int *hitroll);

const char *ac_text[] =
	{
		"&W   ",    //  -30
		"&W   ",    //  -29
		"&W   ",    //  -28
		"&g    ",    //  -27
		"&g    ",    //  -26
		"&g    ",    //  -25
		"&g ",    //  -24
		"&g ",    //  -23
		"&g ",    //  -22
		"&g ",    //  -21
		"&g ",    //  -20
		"&g ",    //  -19
		"&g ",    //  -18
		"&g ",    //  -17
		"&g ",    //  -16
		"&G  ",    //  -15
		"&G  ",    //  -14
		"&G  ",    //  -13
		"&G  ",    //  -12
		"&G  ",    //  -11
		"&G  ",    //  -10
		"&G ",    //   -9
		"&G ",    //   -8
		"&G ",    //   -7
		"&G ",    //   -6
		"&G ",    //   -5
		"&G ",    //   -4
		"&Y   ",    //   -3
		"&Y   ",    //   -2
		"&Y   ",    //   -1
		"&Y ",    //    0
		"&Y   ",
		"&Y ",
		"&R ",
		"&R  ",
		"&R  ",    // 5
		"&R   ",
		"&r - ",
		"&r  ",
		"&r   ",
		"&r  ",    // 10
	};

void DoScore(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	skip_spaces(&argument);

	if (ch->IsNpc())
		return;

	if (utils::IsAbbr(argument, "") || utils::IsAbbr(argument, "all")) {
		PrintScoreAll(ch);
		return;
	} else if (utils::IsAbbr(argument, "") || utils::IsAbbr(argument, "list")) {
		PrintScoreList(ch);
		return;
	} else {
		PrintScoreBase(ch);
	}
}

void PrintBonusStateInfo(CharData *ch, std::ostringstream &out);

// \todo          " " 
void PrintScoreList(CharData *ch) {
	sprintf(buf, "%s", PlayerRace::GetKinNameByNum(GET_KIN(ch), GET_SEX(ch)).c_str());
	buf[0] = LOWER(buf[0]);
	sprintf(buf1, "%s", religion_name[GET_RELIGION(ch)][static_cast<int>(GET_SEX(ch))]);
	buf1[0] = LOWER(buf1[0]);
	SendMsgToChar(ch, " %s, %s, %s, %s,  %d,  %d.\r\n", ch->get_name().c_str(),
				  buf,
				  MUD::Class(ch->GetClass()).GetCName(),
				  buf1,
				  GetRealLevel(ch),
				  GetRealRemort(ch));
	SendMsgToChar(ch, " : %d, : %d(%d), : %d(%d),  %d(%d).\r\n",
				  GET_AGE(ch),
				  GET_SIZE(ch), GET_REAL_SIZE(ch),
				  GET_HEIGHT(ch), GET_REAL_HEIGHT(ch),
				  GET_WEIGHT(ch), GET_REAL_WEIGHT(ch));
	SendMsgToChar(ch, "   %d(%d) %s ,   %d(%d) %s   .\r\n",
				  GET_HIT(ch), GET_REAL_MAX_HIT(ch), GetDeclensionInNumber(GET_HIT(ch), EWhat::kOneU),
				  GET_MOVE(ch), GET_REAL_MAX_MOVE(ch), GetDeclensionInNumber(GET_MOVE(ch), EWhat::kMoveU));
	if (IS_MANA_CASTER(ch)) {
		SendMsgToChar(ch, "   %d(%d)    %d  .\r\n",
					  ch->mem_queue.stored, GET_MAX_MANA(ch), CalcManaGain(ch));
	}
	SendMsgToChar(ch, " : %d(%d), : %d(%d), : %d(%d), : %d(%d), : %d(%d), : %d(%d).\r\n",
				  ch->get_str(), GetRealStr(ch),
				  ch->get_dex(), GetRealDex(ch),
				  ch->get_con(), GetRealCon(ch),
				  ch->get_int(), GetRealInt(ch),
				  ch->get_wis(), GetRealWis(ch),
				  ch->get_cha(), GetRealCha(ch));

	HitData hit_params;
	hit_params.weapon = fight::kMainHand;
	hit_params.init(ch, ch);
	bool need_dice = false;
	int max_dam = hit_params.calc_damage(ch, need_dice); //  

	SendMsgToChar(ch, ": %d, : %d, : %d,  : %d, : %d, : %d.\r\n",
				  CalcHitroll(ch),
				  max_dam,
				  int(GET_MANAREG(ch) * ch->get_cond_penalty(P_CAST)),
				  CalcAntiSavings(ch),
				  ch->calc_morale(),
				  calc_initiative(ch, false));
	SendMsgToChar(ch, "  : .: %d, . : %d, : %d\r\n",
				  ch->add_abils.percent_magdam_add,
				  ch->add_abils.percent_physdam_add,
				  ch->add_abils.percent_exp_add);
	SendMsgToChar(ch, ": : %d, : %d, : %d, : %d, : %d, : %d, : %d, : %d.\r\n",
				  MIN(GET_RESIST(ch, EResist::kFire), 75),
				  MIN(GET_RESIST(ch, EResist::kAir), 75),
				  MIN(GET_RESIST(ch, EResist::kWater), 75),
				  MIN(GET_RESIST(ch, EResist::kEarth), 75),
				  MIN(GET_RESIST(ch, EResist::kDark), 75),
				  MIN(GET_RESIST(ch, EResist::kVitality), 75),
				  MIN(GET_RESIST(ch, EResist::kMind), 75),
				  MIN(GET_RESIST(ch, EResist::kImmunity), 75));
	SendMsgToChar(ch, " : : %d, : %d, : %d, : %d, .: %d, . %d, .: %d.\r\n",
			-CalcSaving(ch, ch, ESaving::kWill, 0),
			-CalcSaving(ch, ch, ESaving::kCritical, 0),
			-CalcSaving(ch, ch, ESaving::kStability, 0),
			-CalcSaving(ch, ch, ESaving::kReflex, 0),
			GET_MR(ch),
			GET_PR(ch),
			GET_AR(ch));
	SendMsgToChar(ch, ": : +%d%% (+%d), : +%d%% (+%d).\r\n",
				  GET_HITREG(ch),
				  hit_gain(ch),
				  GET_MOVEREG(ch),
				  move_gain(ch));
	int ac = compute_armor_class(ch) / 10;
	if (ac < 5) {
		const int mod = (1 - ch->get_cond_penalty(P_AC)) * 40;
		ac = ac + mod > 5 ? 5 : ac + mod;
	}
	SendMsgToChar(ch, ": %d, : %d,  %d.\r\n",
				  GET_ARMOUR(ch),
				  ac,
				  GET_ABSORBE(ch));
	SendMsgToChar(ch, "  :  : %ld,   %ld. : %d, : %ld, : %ld.\r\n",
				  ch->get_gold(),
				  ch->get_bank(),
				  ch->get_hryvn(),
				  GET_EXP(ch),
				  IS_IMMORTAL(ch) ? 1 : GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GET_EXP(ch));
	if (!ch->IsOnHorse())
		SendMsgToChar(ch, " : %s", GetPositionStr(ch));
	else
		SendMsgToChar(ch, " :    %s.\r\n", GET_PAD(ch->get_horse(), 5));
	if (PRF_FLAGGED(ch, EPrf::KSummonable))
		SendMsgToChar(ch, "   .\r\n");
	else
		SendMsgToChar(ch, "   .\r\n");
	SendMsgToChar(ch, ": %s, : %s.\r\n", (GET_COND(ch, FULL) > kNormCondition)? "" : "", GET_COND_M(ch, THIRST)? "" : "");
	//  ,   .
	RoomData *label_room = room_spells::FindAffectedRoom(GET_ID(ch), ESpell::kRuneLabel);
	if (label_room) {
		const int timer_room_label = room_spells::GetUniqueAffectDuration(GET_ID(ch), ESpell::kRuneLabel);
		if (timer_room_label > 0) {
			*buf2 = '\0';
			(timer_room_label + 1) / kSecsPerMudHour ? sprintf(buf2, "%d %s.", (timer_room_label + 1) / kSecsPerMudHour + 1,
															   GetDeclensionInNumber(
																   (timer_room_label + 1) / kSecsPerMudHour + 1,
																   EWhat::kHour)) : sprintf(buf2, " .");
			SendMsgToChar(ch, "     : '%s',    %s\r\n", label_room->name, buf2);
			*buf2 = '\0';
		}
	}
	if (!NAME_GOD(ch) && GetRealLevel(ch) <= kNameLevel) {
		SendMsgToChar(ch, "!       !\r\n");
		SendMsgToChar(ch, "C    ,      .\r\n");
	} else if (NAME_BAD(ch)) {
		SendMsgToChar(ch, "!    .      .\r\n");
	}
	SendMsgToChar(ch, "         %2d %-75s\r\n",
				  grouping[ch->GetClass()][static_cast<int>(GetRealRemort(ch))],
				  (std::string(
					  GetDeclensionInNumber(grouping[ch->GetClass()][static_cast<int>(GetRealRemort(
						  ch))], EWhat::kLvl)
						  + std::string("    .")).substr(0, 76).c_str()));

	SendMsgToChar(ch, "      %d .\r\n", max_group_size(ch));
	std::ostringstream out;
	out.str("");
	PrintRentableInfo(ch, out);
	PrintBonusStateInfo(ch, out);
	SendMsgToChar(out.str(), ch);
}

/*
 *    " ".
 */

const std::string &InfoStrPrefix(CharData *ch) {
	static const std::string cyan_star{KICYN " * " KNRM};
	static const std::string space_str;
	if (PRF_FLAGGED(ch, EPrf::kBlindMode)) {
		return space_str;
	} else {
		return cyan_star;
	}
}

void PrintHorseInfo(CharData *ch, std::ostringstream &out) {
	if (ch->has_horse(false)) {
		if (ch->IsOnHorse()) {
			out << InfoStrPrefix(ch) << "   " << GET_PAD(ch->get_horse(), 5) << "." << std::endl;
		} else {
			out << InfoStrPrefix(ch) << "   " << ch->get_horse()->get_name() << "." << std::endl;
		}
	}
}

void PrintRuneLabelInfo(CharData *ch, std::ostringstream &out) {
	RoomData *label_room = room_spells::FindAffectedRoom(GET_ID(ch), ESpell::kRuneLabel);
	if (label_room) {
		int timer_room_label = room_spells::GetUniqueAffectDuration(GET_ID(ch), ESpell::kRuneLabel);
		out << InfoStrPrefix(ch) << KIGRN << "      \'"
			<< label_room->name << "\' ";
		if (timer_room_label > 0) {
			out << "[  ";
			timer_room_label = (timer_room_label + 1) / kSecsPerMudHour + 1;
			if (timer_room_label > 0) {
				out << timer_room_label << " " << GetDeclensionInNumber(timer_room_label, EWhat::kHour) << "]." << std::endl;
			} else {
				out << " ]." << std::endl;
			}
		}
		out << std::endl;
	}
}

void PrintGloryInfo(CharData *ch, std::ostringstream &out) {
	auto glory = GloryConst::get_glory(GET_UNIQUE(ch));
	if (glory > 0) {
		out << InfoStrPrefix(ch) << "  "
			<< glory << " " << GetDeclensionInNumber(glory, EWhat::kPoint) << "  ." << std::endl;
	}
}

void PrintNameStatusInfo(CharData *ch, std::ostringstream &out) {
	if (!NAME_GOD(ch) && GetRealLevel(ch) <= kNameLevel) {
		out << InfoStrPrefix(ch) << KIRED << "! " << KNRM
			<< "      !" << std::endl;
		out << InfoStrPrefix(ch) << KIRED << "! " << KNRM
			<< "C    ,      ." << std::endl;
	} else if (NAME_BAD(ch)) {
		out << InfoStrPrefix(ch) << KIRED << "! " << KNRM
			<< "   .     ." << std::endl;
	}
}

void PrintSummonableInfo(CharData *ch, std::ostringstream &out) {
	if (PRF_FLAGGED(ch, EPrf::KSummonable)) {
		out << InfoStrPrefix(ch) << KIYEL << "   ." << KNRM << std::endl;
	} else {
		out << InfoStrPrefix(ch) << "   ." << std::endl;
	}
}

void PrintBonusStateInfo(CharData *ch, std::ostringstream &out) {
	if (Bonus::is_bonus_active()) {
		out << InfoStrPrefix(ch) << Bonus::active_bonus_as_string() << " "
			<< Bonus::time_to_bonus_end_as_string() << std::endl;
	}
}

void PrintExpTaxInfo(CharData *ch, std::ostringstream &out) {
	if (GET_GOD_FLAG(ch, EGf::kRemort) && CLAN(ch)) {
		out << InfoStrPrefix(ch) << "       ." << std::endl;
	}
}

void PrintBlindModeInfo(CharData *ch, std::ostringstream &out) {
	if (PRF_FLAGGED(ch, EPrf::kBlindMode)) {
		out << InfoStrPrefix(ch) << "   ." << std::endl;
	}
}

void PrintGroupMembershipInfo(CharData *ch, std::ostringstream &out) {
	if (GetRealLevel(ch) < kLvlImmortal) {
		out << InfoStrPrefix(ch) << "        "
			<< grouping[ch->GetClass()][static_cast<int>(GetRealRemort(ch))] << " "
			<< GetDeclensionInNumber(grouping[ch->GetClass()][static_cast<int>(GetRealRemort(ch))],
									 EWhat::kLvl)
			<< "    ." << std::endl;

		out << InfoStrPrefix(ch) << "      "
			<< max_group_size(ch) << " ." << std::endl;
	}
}

void PrintRentableInfo(CharData *ch, std::ostringstream &out) {
	if (NORENTABLE(ch)) {
		const time_t rent_time = NORENTABLE(ch) - time(nullptr);
		const auto minutes = rent_time > 60 ? rent_time / 60 : 0;
		out << InfoStrPrefix(ch) << KIRED << "            ";
		if (minutes) {
			out << minutes << " " << GetDeclensionInNumber(minutes, EWhat::kMinU) << "." << KNRM << std::endl;
		} else {
			out << rent_time << " " << GetDeclensionInNumber(rent_time, EWhat::kSec) << "." << KNRM << std::endl;
		}
	} else if ((ch->in_room != kNowhere) && ROOM_FLAGGED(ch->in_room, ERoomFlag::kPeaceful) && !PLR_FLAGGED(ch, EPlrFlag::kKiller)) {
		out << InfoStrPrefix(ch) << KIGRN << "     ." << KNRM << std::endl;
	}
}
// \todo    -     .
void PrinForgeInfo(CharData *ch, std::ostringstream &out) {
	if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kForge)
		&& (ch->GetSkill(ESkill::kJewelry)
		|| ch->GetSkill(ESkill::kRepair)
		|| ch->GetSkill(ESkill::kReforging))) {
		out << InfoStrPrefix(ch) << KIYEL << "       ."
			<< KNRM << std::endl;
	}
}

void PrintPostInfo(CharData *ch, std::ostringstream &out) {
	if (mail::has_mail(ch->get_uid())) {
		out << InfoStrPrefix(ch) << KIGRN << "   ,   ." << KNRM << std::endl;
	}
	if (Parcel::has_parcel(ch)) {
		out << InfoStrPrefix(ch) << KIGRN << "  ,   ." << KNRM << std::endl;
	}
}

void PrintProtectInfo(CharData *ch, std::ostringstream &out) {
	if (ch->get_protecting()) {
		out << InfoStrPrefix(ch) << "  " << GET_PAD(ch->get_protecting(), 3)
			<< "  ." << std::endl;
	}
}

//	***       ***

struct ScorePunishmentInfo {
	ScorePunishmentInfo() = delete;
	explicit ScorePunishmentInfo(CharData *ch)
		: ch{ch} {};

	void SetFInfo(Bitvector punish_flag, const Punish *punish_info) {
		flag = punish_flag;
		punish = punish_info;
	};

	CharData *ch{};
	const Punish *punish{};
	std::string msg;
	Bitvector flag{};
};

void PrintSinglePunishmentInfo(const ScorePunishmentInfo &info, std::ostringstream &out) {
	const auto current_time = time(nullptr);
	const auto hrs = (info.punish->duration - current_time)/3600;
	const auto mins = ((info.punish->duration - current_time)%3600 + 59)/60;

	out << InfoStrPrefix(info.ch) << KIRED << info.msg
		<< hrs << " " << GetDeclensionInNumber(hrs, EWhat::kHour) << " "
		<< mins << " " << GetDeclensionInNumber(mins, EWhat::kMinU);

	if (info.punish->reason != nullptr) {
		if (info.punish->reason[0] != '\0' && str_cmp(info.punish->reason, "(null)") != 0) {
			out << " [" << info.punish->reason << "]";
		}
	}
	out << "." << KNRM  << std::endl;
}

// \todo   -  ,     .     .
bool IsPunished(const ScorePunishmentInfo &info) {
	return (PLR_FLAGGED(info.ch, info.flag)
		&& info.punish->duration != 0
		&& info.punish->duration > time(nullptr));
}

/*
 *  ,        ,     
 *       .    ,  -   
 *     .
 */
void PrintPunishmentsInfo(CharData *ch, std::ostringstream &out) {

	ScorePunishmentInfo punish_info{ch};

	punish_info.SetFInfo(EPlrFlag::kHelled, &ch->player_specials->phell);
	if (IsPunished(punish_info)) {
		punish_info.msg = "      ";
		PrintSinglePunishmentInfo(punish_info, out);
	}

	punish_info.SetFInfo(EPlrFlag::kFrozen, &ch->player_specials->pfreeze);
	if (IsPunished(punish_info)) {
		punish_info.msg = "    ";
		PrintSinglePunishmentInfo(punish_info, out);
	}

	punish_info.SetFInfo(EPlrFlag::kMuted, &ch->player_specials->pmute);
	if (IsPunished(punish_info)) {
		punish_info.msg = "     ";
		PrintSinglePunishmentInfo(punish_info, out);
	}

	punish_info.SetFInfo(EPlrFlag::kDumbed, &ch->player_specials->pdumb);
	if (IsPunished(punish_info)) {
		punish_info.msg = "    ";
		PrintSinglePunishmentInfo(punish_info, out);
	}

	/*
 	*    ,    /     
 	* ,   . -,       ( ,  
 	*    -    ).
 	*/
	if (GET_GOD_FLAG(ch, EGf::kGodscurse) && GCURSE_DURATION(ch)) {
		punish_info.punish = &ch->player_specials->pgcurse;
		punish_info.msg = "    ";
		PrintSinglePunishmentInfo(punish_info, out);
	}

	/*
	 *    :  ""      :
	 *   .          unreg    
	 * ,  .
	 */
	if (!PLR_FLAGGED(ch, EPlrFlag::kRegistred) && UNREG_DURATION(ch) != 0 && UNREG_DURATION(ch) > time(nullptr)) {
		punish_info.punish = &ch->player_specials->punreg;
		punish_info.msg = "      IP  ";
		PrintSinglePunishmentInfo(punish_info, out);
	}
}

void PrintMorphInfo(CharData *ch, std::ostringstream &out) {
	if (ch->is_morphed()) {
		out << InfoStrPrefix(ch) << KIYEL << "     - "
		<< ch->get_morph_desc() << "." << KNRM << std::endl;
	}
}

/**
 *      ,    .
 * @param ch  - ,    .
 * @param table - ,    .
 * @param col -  .
 * @return -    .
 */
int PrintBaseInfoToTable(CharData *ch, table_wrapper::Table &table, std::size_t col) {
	std::size_t row{0};
	table[row][col] = std::string(": ") + PlayerRace::GetRaceNameByNum(GET_KIN(ch), GET_RACE(ch), GET_SEX(ch));
	table[++row][col] = std::string(": ") + religion_name[GET_RELIGION(ch)][static_cast<int>(GET_SEX(ch))];
	table[++row][col] = std::string(": ") + std::to_string(GetRealLevel(ch));
	table[++row][col] = std::string(": ") + std::to_string(GetRealRemort(ch));
	table[++row][col] = std::string(": ") + std::to_string(GET_AGE(ch));
	if (ch->GetLevel() < kLvlImmortal) {
		table[++row][col] = std::string(": ") + PrintNumberByDigits(GET_EXP(ch));
		table[++row][col] = std::string(": ") + PrintNumberByDigits(
			GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GET_EXP(ch));
	}
	table[++row][col] = std::string(": ") + PrintNumberByDigits(ch->get_gold());
	table[++row][col] = std::string(" : ") + PrintNumberByDigits(ch->get_bank());
	table[++row][col] = GetShortPositionStr(ch);
	table[++row][col] = std::string(": ") + (GET_COND(ch, FULL) > kNormCondition ? " :(" : "");
	table[++row][col] = std::string(": ") + (GET_COND_M(ch, THIRST) ? "!" : "");
	if (GET_COND(ch, DRUNK) >= kDrunked) {
		table[++row][col] = (IsAffectedBySpell(ch, ESpell::kAbstinent) ? "." : " .");
	}
	if (PlayerSystem::weight_dex_penalty(ch)) {
		table[++row][col] = " !";
	}

	return 1; //  
}

/**
 *      ,    .
 * @param ch  - ,    .
 * @param table - ,    .
 * @param col -  .
 * @return -    .
 */
int PrintBaseStatsToTable(CharData *ch, table_wrapper::Table &table, std::size_t col) {
	std::size_t row{0};
	table[row][col] = "";			table[row][col + 1] = std::to_string(ch->get_str()) + " (" + std::to_string(GetRealStr(ch)) + ")";
	table[++row][col] = "";		table[row][col + 1] = std::to_string(ch->get_dex()) + " (" + std::to_string(GetRealDex(ch)) + ")";
	table[++row][col] = "";	table[row][col + 1] = std::to_string(ch->get_con()) + " (" + std::to_string(GetRealCon(ch)) + ")";
	table[++row][col] = "";		table[row][col + 1] = std::to_string(ch->get_wis()) + " (" + std::to_string(GetRealWis(ch)) + ")";
	table[++row][col] = "";	table[row][col + 1] = std::to_string(ch->get_int()) + " (" + std::to_string(GetRealInt(ch)) + ")";
	table[++row][col] = "";		table[row][col + 1] = std::to_string(ch->get_cha()) + " (" + std::to_string(GetRealCha(ch)) + ")";
	table[++row][col] = "";			table[row][col + 1] = std::to_string(GET_HEIGHT(ch)) + " (" + std::to_string(GET_REAL_HEIGHT(ch)) + ")";
	table[++row][col] = "";			table[row][col + 1] = std::to_string(GET_WEIGHT(ch)) + " (" + std::to_string(GET_REAL_WEIGHT(ch)) + ")";
	table[++row][col] = "";		table[row][col + 1] = std::to_string(GET_SIZE(ch)) + " (" + std::to_string(GET_REAL_SIZE(ch)) + ")";
	table[++row][col] = "";		table[row][col + 1] = std::to_string(GET_HIT(ch)) + "(" + std::to_string(GET_REAL_MAX_HIT(ch)) + ")";
	table[++row][col] = ". ";	table[row][col + 1] = "+" + std::to_string(GET_HITREG(ch)) + "% (" + std::to_string(hit_gain(ch)) + ")";
	table[++row][col] = "";	table[row][col + 1] = std::to_string(GET_MOVE(ch)) + "(" + std::to_string(GET_REAL_MAX_MOVE(ch)) + ")";
	table[++row][col] = ". ";	table[row][col + 1] = "+" + std::to_string(GET_MOVEREG(ch)) + "% (" + std::to_string(move_gain(ch)) + ")";
	if (IS_MANA_CASTER(ch)) {
		table[++row][col] = ""; 		table[row][col + 1] = std::to_string(ch->mem_queue.stored) + "(" + std::to_string(GET_MAX_MANA(ch)) + ")";
		table[++row][col] = ". ";	table[row][col + 1] = "+" + std::to_string(CalcManaGain(ch)) + " .";
	}

	return 2; //  
}

/**
 *      ,    .
 * @param ch  - ,    .
 * @param table - ,    .
 * @param col -  .
 * @return -    .
 */
int PrintSecondaryStatsToTable(CharData *ch, table_wrapper::Table &table, std::size_t col) {
	HitData hit_params;
	hit_params.weapon = fight::kMainHand;
	hit_params.init(ch, ch);
	auto max_dam = hit_params.calc_damage(ch, false);

	std::size_t row{0};
	table[row][col] = "";		table[row][col + 1] = std::to_string(CalcHitroll(ch));
	table[++row][col] = "";	table[row][col + 1] = std::to_string(max_dam);
	table[++row][col] = "";	table[row][col + 1] = std::to_string(CalcAntiSavings(ch));
	table[++row][col] = "";	table[row][col + 1] = std::to_string(std::lround(GET_MANAREG(ch)*ch->get_cond_penalty(P_CAST)));
	table[++row][col] = "";		table[row][col + 1] = std::to_string(ch->calc_morale());
	table[++row][col] = ".  %";	table[row][col + 1] = std::to_string(ch->add_abils.percent_magdam_add);
	table[++row][col] = ".  %";	table[row][col + 1] = std::to_string(ch->add_abils.percent_physdam_add);
	table[++row][col] = "";	table[row][col + 1] = std::to_string(calc_initiative(ch, false));
	table[++row][col] = "-:";	table[row][col + 1] = " ";
	table[++row][col] = "";			table[row][col + 1] = std::to_string(-CalcSaving(ch, ch, ESaving::kWill, 0));
	table[++row][col] = "";		table[row][col + 1] = std::to_string(-CalcSaving(ch, ch, ESaving::kCritical, 0));
	table[++row][col] = "";	table[row][col + 1] = std::to_string(-CalcSaving(ch, ch, ESaving::kStability, 0));
	table[++row][col] = "";		table[row][col + 1] = std::to_string(-CalcSaving(ch, ch, ESaving::kReflex, 0));

	return 2; //  
}

/**
 *      ,     .
 * @param ch  - ,    .
 * @param table - ,    .
 * @param col -  .
 * @return -    .
 */
int PrintProtectiveStatsToTable(CharData *ch, table_wrapper::Table &table, std::size_t col) {
	std::size_t row{0};
	int ac = compute_armor_class(ch) / 10;
	if (ac < 5) {
		const int mod = (1 - ch->get_cond_penalty(P_AC)) * 40;
		ac = ac + mod > 5 ? 5 : ac + mod;
	}

	table[row][col] = "";				table[row][col + 1] = std::to_string(GET_ARMOUR(ch));
	table[++row][col] = "";			table[row][col + 1] = std::to_string(ac);
	table[++row][col] = "";		table[row][col + 1] = std::to_string(GET_ABSORBE(ch));
	table[++row][col] = ": ";	table[row][col + 1] = " ";
	table[++row][col] = "";			table[row][col + 1] = std::to_string(GET_PR(ch));
	table[++row][col] = "";		table[row][col + 1] = std::to_string(GET_MR(ch));
	table[++row][col] = " ";		table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kFire), kMaxPcResist));
	table[++row][col] = " ";		table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kWater), kMaxPcResist));
	table[++row][col] = " ";		table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kEarth), kMaxPcResist));
	table[++row][col] = " ";	table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kAir), kMaxPcResist));
	table[++row][col] = " ";		table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kDark), kMaxPcResist));
	table[++row][col] = " ";		table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kMind), kMaxPcResist));
	table[++row][col] = " ";	table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kVitality), kMaxPcResist));
	table[++row][col] = "  ";	table[row][col + 1] = std::to_string(std::min(GET_RESIST(ch, EResist::kImmunity), kMaxPcResist));

	return 2; //  
}

void PrintSelfHitrollInfo(CharData *ch, std::ostringstream &out) {
	HitData hit;
	hit.weapon = fight::AttackType::kMainHand;
	hit.init(ch, ch);
	hit.calc_base_hr(ch);
	hit.calc_stat_hr(ch);
	hit.calc_ac(ch);

	HitData hit2;
	hit2.weapon = fight::AttackType::kOffHand;
	hit2.init(ch, ch);
	hit2.calc_base_hr(ch);
	hit2.calc_stat_hr(ch);

	out << InfoStrPrefix(ch) << KICYN
		<< "RIGHT_WEAPON: hitroll=" << -hit.calc_thaco
		<< ", LEFT_WEAPON: hitroll=" << hit2.calc_thaco
		<< ", AC=" << hit.victim_ac << "." << KNRM << std::endl;
}

void PrintTesterModeInfo(CharData *ch, std::ostringstream &out) {
	if (PRF_FLAGGED(ch, EPrf::kTester)) {
		out << InfoStrPrefix(ch) << KICYN << "  ." << KNRM << std::endl;
		PrintSelfHitrollInfo(ch, out);
	}
}
/**
 *         .
 *      (    -  ).
 * @param ch - ,    .
 * @param out -   .
 */
void PrintAdditionalInfo(CharData *ch, std::ostringstream &out) {
	/* -   */
	PrintHorseInfo(ch, out);
	PrintMorphInfo(ch, out);
	PrintRuneLabelInfo(ch, out);
	PrintProtectInfo(ch, out);
	PrintBonusStateInfo(ch, out);
	PrinForgeInfo(ch, out);
	/*   */
	PrintGroupMembershipInfo(ch, out);
	PrintGloryInfo(ch, out);
	PrintExpTaxInfo(ch, out);
	PrintPostInfo(ch, out);
	/*      */
	PrintRentableInfo(ch, out);
	PrintNameStatusInfo(ch, out);
	PrintPunishmentsInfo(ch, out);
	PrintSummonableInfo(ch, out);
	PrintBlindModeInfo(ch, out);
	/*     */
	PrintTesterModeInfo(ch, out);
}

void PrintScoreAll(CharData *ch) {
	//    (,     )
	std::ostringstream out;
	out << "   " << ch->get_name() << ", " << MUD::Class(ch->GetClass()).GetName() << ".  :" << std::endl;

	//       
	table_wrapper::Table table;
	std::size_t current_column{0};
	current_column += PrintBaseInfoToTable(ch, table, current_column);
	current_column += PrintBaseStatsToTable(ch, table, current_column);
	current_column += PrintSecondaryStatsToTable(ch, table, current_column);
	PrintProtectiveStatsToTable(ch, table, current_column);
	table_wrapper::DecorateCuteTable(ch, table);
	table_wrapper::PrintTableToStream(out, table);

	PrintAdditionalInfo(ch, out);

	SendMsgToChar(out.str(), ch);
}

// \todo          " " 
void PrintScoreBase(CharData *ch) {
	std::ostringstream out;

	out << " " << ch->only_title() << " ("
		<< PlayerRace::GetKinNameByNum(GET_KIN(ch), GET_SEX(ch)) << ", "
		<< PlayerRace::GetRaceNameByNum(GET_KIN(ch), GET_RACE(ch), GET_SEX(ch)) << ", "
		<< religion_name[GET_RELIGION(ch)][static_cast<int>(GET_SEX(ch))] << ", "
		<< MUD::Class(ch->GetClass()).GetCName() << " "
		<< GetRealLevel(ch) << " )." << std::endl;

	PrintNameStatusInfo(ch, out);

	out << "  " << GET_REAL_AGE(ch) << " " << GetDeclensionInNumber(GET_REAL_AGE(ch), EWhat::kYear) << ".";
	if (age(ch)->month == 0 && age(ch)->day == 0) {
		out << KIRED << "     !" << KNRM;
	}
	out << std::endl;

	SendMsgToChar(out.str(), ch);
	//    

	sprintf(buf,
			"   %d(%d) %s ,   %d(%d) %s   .\r\n",
			GET_HIT(ch), GET_REAL_MAX_HIT(ch), GetDeclensionInNumber(GET_HIT(ch),
																	 EWhat::kOneU),
			GET_MOVE(ch), GET_REAL_MAX_MOVE(ch), GetDeclensionInNumber(GET_MOVE(ch), EWhat::kMoveU));

	if (IS_MANA_CASTER(ch)) {
		sprintf(buf + strlen(buf),
				"   %d(%d)    %d  .\r\n",
				ch->mem_queue.stored, GET_MAX_MANA(ch), CalcManaGain(ch));
	}

	sprintf(buf + strlen(buf),
			"%s  :\r\n"
			"   : %2d(%2d)"
			"   : %2d(%2d)"
			"   : %2d(%2d)"
			"   : %2d(%2d)"
			"     : %2d(%2d)"
			"  : %2d(%2d)\r\n"
			"   %3d(%3d)"
			"     %3d(%3d)"
			"      %3d(%3d)%s\r\n",
			CCICYN(ch, C_NRM), ch->get_str(), GetRealStr(ch),
			ch->get_dex(), GetRealDex(ch),
			ch->get_con(), GetRealCon(ch),
			ch->get_wis(), GetRealWis(ch),
			ch->get_int(), GetRealInt(ch),
			ch->get_cha(), GetRealCha(ch),
			GET_SIZE(ch), GET_REAL_SIZE(ch),
			GET_HEIGHT(ch), GET_REAL_HEIGHT(ch), GET_WEIGHT(ch), GET_REAL_WEIGHT(ch), CCNRM(ch, C_NRM));

	if (IS_IMMORTAL(ch)) {
		sprintf(buf + strlen(buf),
				"%s   :\r\n"
				"  AC   : %4d(%4d)"
				"  DR   : %4d(%4d)%s\r\n",
				CCIGRN(ch, C_NRM), GET_AC(ch), compute_armor_class(ch),
				GET_DR(ch), GetRealDamroll(ch), CCNRM(ch, C_NRM));
	} else {
		int ac = compute_armor_class(ch) / 10;

		if (ac < 5) {
			const int mod = (1 - ch->get_cond_penalty(P_AC)) * 40;
			ac = ac + mod > 5 ? 5 : ac + mod;
		}

		int ac_t = std::clamp(ac + 30, 0, 40);
		sprintf(buf + strlen(buf), "&G   :\r\n"
								   "    (AC)     : %4d - %s&G\r\n"
								   "  / : %4d/%d&n\r\n",
				ac, ac_text[ac_t], GET_ARMOUR(ch), GET_ABSORBE(ch));
	}
	sprintf(buf + strlen(buf), "  - %ld %s,  %d %c. ", GET_EXP(ch),
			GetDeclensionInNumber(GET_EXP(ch), EWhat::kPoint), ch->add_abils.percent_exp_add, '%');
	if (GetRealLevel(ch) < kLvlImmortal) {
		if (PRF_FLAGGED(ch, EPrf::kBlindMode)) {
			sprintf(buf + strlen(buf), "\r\n");
		}
		sprintf(buf + strlen(buf),
				"   %ld %s   .\r\n",
				GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GET_EXP(ch),
				GetDeclensionInNumber(GetExpUntilNextLvl(ch, GetRealLevel(ch) + 1) - GET_EXP(ch), EWhat::kPoint));
	} else
		sprintf(buf + strlen(buf), "\r\n");

	sprintf(buf + strlen(buf),
			"    %ld %s  %d %s",
			ch->get_gold(),
			GetDeclensionInNumber(ch->get_gold(), EWhat::kMoneyA),
			ch->get_hryvn(),
			GetDeclensionInNumber(ch->get_hryvn(), EWhat::kTorc));
	if (ch->get_bank() > 0)
		sprintf(buf + strlen(buf), " (  %ld %s   ).\r\n",
				ch->get_bank(), GetDeclensionInNumber(ch->get_bank(), EWhat::kMoneyA));
	else
		strcat(buf, ".\r\n");

	if (GetRealLevel(ch) < kLvlImmortal) {
		sprintf(buf + strlen(buf),
				"         %d %s    .\r\n",
				grouping[ch->GetClass()][static_cast<int>(GetRealRemort(ch))],
				GetDeclensionInNumber(grouping[ch->GetClass()][static_cast<int>(GetRealRemort(ch))],
									  EWhat::kLvl));
	}

	//  ,   .
	RoomData *label_room = room_spells::FindAffectedRoom(GET_ID(ch), ESpell::kRuneLabel);
	if (label_room) {
		sprintf(buf + strlen(buf),
				"&G&q      '%s'.&Q&n\r\n",
				std::string(label_room->name).c_str());
	}

	int glory = Glory::get_glory(GET_UNIQUE(ch));
	if (glory) {
	//	sprintf(buf + strlen(buf), "  %d %s .\r\n", glory, GetDeclensionInNumber(glory, EWhat::kPoint));
	}
	glory = GloryConst::get_glory(GET_UNIQUE(ch));
	if (glory) {
		sprintf(buf + strlen(buf), "  %d %s  .\r\n",
				glory, GetDeclensionInNumber(glory, EWhat::kPoint));
	}

	TimeInfoData playing_time = *real_time_passed((time(nullptr) - ch->player_data.time.logon) + ch->player_data.time.played, 0);
	sprintf(buf + strlen(buf), "  %d %s %d %s  .\r\n",
			playing_time.day, GetDeclensionInNumber(playing_time.day, EWhat::kDay),
			playing_time.hours, GetDeclensionInNumber(playing_time.hours, EWhat::kHour));
	SendMsgToChar(buf, ch);

	if (!ch->IsOnHorse())
		SendMsgToChar(ch, "%s", GetPositionStr(ch));

	strcpy(buf, CCIGRN(ch, C_NRM));
	const auto value_drunked = GET_COND(ch, DRUNK);
	if (value_drunked >= kDrunked) {
		if (IsAffectedBySpell(ch, ESpell::kAbstinent))
			strcat(buf, "   !\r\n");
		else {
			if (value_drunked >= kMortallyDrunked)
				strcat(buf, "  ,       ...\r\n");
			else if (value_drunked >= 10)
				strcat(buf, "  ,     .\r\n");
			else if (value_drunked >= 5)
				strcat(buf, " .\r\n");
			else
				strcat(buf, "  .\r\n");
		}

	}
	if (GET_COND_M(ch, FULL))
		strcat(buf, " .\r\n");
	if (GET_COND_M(ch, THIRST))
		strcat(buf, "  .\r\n");
	/*
	   strcat(buf, CCICYN(ch, C_NRM));
	   strcat(buf," :\r\n");
	   (ch)->char_specials.saved.affected_by.sprintbits(affected_bits, buf2, "\r\n");
	   strcat(buf,buf2);
	 */
	if (PRF_FLAGGED(ch, EPrf::KSummonable))
		strcat(buf, "   .\r\n");

	if (ch->has_horse(false)) {
		if (ch->IsOnHorse())
			sprintf(buf + strlen(buf), "   %s.\r\n", GET_PAD(ch->get_horse(), 5));
		else
			sprintf(buf + strlen(buf), "   %s.\r\n", GET_NAME(ch->get_horse()));
	}
	strcat(buf, CCNRM(ch, C_NRM));
	SendMsgToChar(buf, ch);
	if (NORENTABLE(ch)) {
		sprintf(buf,
				"%s          .%s\r\n",
				CCIRED(ch, C_NRM), CCNRM(ch, C_NRM));
		SendMsgToChar(buf, ch);
	} else if ((ch->in_room != kNowhere) && ROOM_FLAGGED(ch->in_room, ERoomFlag::kPeaceful) && !PLR_FLAGGED(ch, EPlrFlag::kKiller)) {
		sprintf(buf, "%s     .%s\r\n", CCIGRN(ch, C_NRM), CCNRM(ch, C_NRM));
		SendMsgToChar(buf, ch);
	}

	if (ROOM_FLAGGED(ch->in_room, ERoomFlag::kForge)
		&& (ch->GetSkill(ESkill::kJewelry) || ch->GetSkill(ESkill::kRepair) || ch->GetSkill(ESkill::kReforging))) {
		sprintf(buf,
				"%s       .%s\r\n",
				CCIGRN(ch, C_NRM),
				CCNRM(ch, C_NRM));
		SendMsgToChar(buf, ch);
	}

	if (mail::has_mail(ch->get_uid())) {
		sprintf(buf, "%s   ,   !%s\r\n", CCIGRN(ch, C_NRM), CCNRM(ch, C_NRM));
		SendMsgToChar(buf, ch);
	}

	if (Parcel::has_parcel(ch)) {
		sprintf(buf, "%s  ,   !%s\r\n", CCIGRN(ch, C_NRM), CCNRM(ch, C_NRM));
		SendMsgToChar(buf, ch);
	}

	if (PLR_FLAGGED(ch, EPlrFlag::kHelled) && HELL_DURATION(ch) && HELL_DURATION(ch) > time(nullptr)) {
		const int hrs = (HELL_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((HELL_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf,
				"      %d %s %d %s [%s].\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour), mins, GetDeclensionInNumber(mins,
																						   EWhat::kMinU),
				HELL_REASON(ch) ? HELL_REASON(ch) : "-");
		SendMsgToChar(buf, ch);
	}
	if (PLR_FLAGGED(ch, EPlrFlag::kMuted) && MUTE_DURATION(ch) != 0 && MUTE_DURATION(ch) > time(nullptr)) {
		const int hrs = (MUTE_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((MUTE_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf, "     %d %s %d %s [%s].\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour),
				mins, GetDeclensionInNumber(mins, EWhat::kMinU), MUTE_REASON(ch) ? MUTE_REASON(ch) : "-");
		SendMsgToChar(buf, ch);
	}
	if (PLR_FLAGGED(ch, EPlrFlag::kDumbed) && DUMB_DURATION(ch) != 0 && DUMB_DURATION(ch) > time(nullptr)) {
		const int hrs = (DUMB_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((DUMB_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf, "    %d %s %d %s [%s].\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour),
				mins, GetDeclensionInNumber(mins, EWhat::kMinU), DUMB_REASON(ch) ? DUMB_REASON(ch) : "-");
		SendMsgToChar(buf, ch);
	}
	if (PLR_FLAGGED(ch, EPlrFlag::kFrozen) && FREEZE_DURATION(ch) != 0 && FREEZE_DURATION(ch) > time(nullptr)) {
		const int hrs = (FREEZE_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((FREEZE_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf, "    %d %s %d %s [%s].\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour),
				mins, GetDeclensionInNumber(mins, EWhat::kMinU), FREEZE_REASON(ch) ? FREEZE_REASON(ch) : "-");
		SendMsgToChar(buf, ch);
	}

	if (!PLR_FLAGGED(ch, EPlrFlag::kRegistred) && UNREG_DURATION(ch) != 0 && UNREG_DURATION(ch) > time(nullptr)) {
		const int hrs = (UNREG_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((UNREG_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf, "      IP  %d %s %d %s [%s].\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour),
				mins, GetDeclensionInNumber(mins, EWhat::kMinU), UNREG_REASON(ch) ? UNREG_REASON(ch) : "-");
		SendMsgToChar(buf, ch);
	}

	if (GET_GOD_FLAG(ch, EGf::kGodscurse) && GCURSE_DURATION(ch)) {
		const int hrs = (GCURSE_DURATION(ch) - time(nullptr)) / 3600;
		const int mins = ((GCURSE_DURATION(ch) - time(nullptr)) % 3600 + 59) / 60;
		sprintf(buf, "    %d %s %d %s.\r\n",
				hrs, GetDeclensionInNumber(hrs, EWhat::kHour), mins, GetDeclensionInNumber(mins, EWhat::kMinU));
		SendMsgToChar(buf, ch);
	}

	if (ch->is_morphed()) {
		sprintf(buf, "     - %s.\r\n", ch->get_morph_desc().c_str());
		SendMsgToChar(buf, ch);
	}
	if (CanUseFeat(ch, EFeat::kSoulsCollector)) {
		const int souls = ch->get_souls();
		if (souls == 0) {
			sprintf(buf, "    .\r\n");
			SendMsgToChar(buf, ch);
		} else {
			if (souls == 1) {
				sprintf(buf, "      .\r\n");
				SendMsgToChar(buf, ch);
			}
			if (souls > 1 && souls < 5) {
				sprintf(buf, "  %d   .\r\n", souls);
				SendMsgToChar(buf, ch);
			}
			if (souls >= 5) {
				sprintf(buf, "  %d    .\r\n", souls);
				SendMsgToChar(buf, ch);
			}
		}
	}
	if (ch->get_ice_currency() > 0) {
		if (ch->get_ice_currency() == 1) {
			sprintf(buf, "        .\r\n");
			SendMsgToChar(buf, ch);
		} else if (ch->get_ice_currency() < 5) {
			sprintf(buf, "      %d  .\r\n", ch->get_ice_currency());
			SendMsgToChar(buf, ch);
		} else {
			sprintf(buf, "     %d  .\r\n", ch->get_ice_currency());
			SendMsgToChar(buf, ch);
		}
	}
	if (ch->get_nogata() > 0 && ROOM_FLAGGED(ch->in_room, ERoomFlag::kDominationArena)) {
		int value = ch->get_nogata();
		if (ch->get_nogata() == 1) {
			sprintf(buf, "       .\r\n");
		}
		else {
			sprintf(buf, "     %d %s.\r\n", value, GetDeclensionInNumber(value, EWhat::kNogataU));
		}
		SendMsgToChar(buf, ch);
	}
}

int CalcHitroll(CharData *ch) {
	ESkill skill = ESkill::kTwohands;
	int hr = 0;
	int max_dam = 0;
	ObjData *weapon = GET_EQ(ch, kBoths);
	if (weapon) {
		if (GET_OBJ_TYPE(weapon) == EObjType::kWeapon) {
			skill = static_cast<ESkill>(GET_OBJ_SKILL(weapon));
			if (ch->GetSkill(skill) == 0) {
				hr -= (50 - std::min(50, GetRealInt(ch))) / 3;
			} else {
				GetClassWeaponMod(ch->GetClass(), skill, &max_dam, &hr);
			}
		}
	} else {
		weapon = GET_EQ(ch, kHold);
		if (weapon) {
			if (GET_OBJ_TYPE(weapon) == EObjType::kWeapon) {
				skill = static_cast<ESkill>(GET_OBJ_SKILL(weapon));
				if (ch->GetSkill(skill) == 0) {
					hr -= (50 - std::min(50, GetRealInt(ch))) / 3;
				} else {
					GetClassWeaponMod(ch->GetClass(), skill, &max_dam, &hr);
				}
			}
		}
		weapon = GET_EQ(ch, kWield);
		if (weapon) {
			if (GET_OBJ_TYPE(weapon) == EObjType::kWeapon) {
				skill = static_cast<ESkill>(GET_OBJ_SKILL(weapon));
				if (ch->GetSkill(skill) == 0) {
					hr -= (50 - std::min(50, GetRealInt(ch))) / 3;
				} else {
					GetClassWeaponMod(ch->GetClass(), skill, &max_dam, &hr);
				}
			}
		}
	}
	if (weapon) {
		int tmphr = 0;
		HitData::CheckWeapFeats(ch, static_cast<ESkill>(weapon->get_skill()), tmphr, max_dam);
		hr -= tmphr;
	} else {
		HitData::CheckWeapFeats(ch, ESkill::kPunch, hr, max_dam);
	}
	if (CanUseFeat(ch, EFeat::kWeaponFinesse)) {
		hr += str_bonus(GetRealDex(ch), STR_TO_HIT);
	} else {
		hr += str_bonus(GetRealStr(ch), STR_TO_HIT);
	}
	hr += GET_REAL_HR(ch) - GetThac0(ch->GetClass(), GetRealLevel(ch));
	if (PRF_FLAGGED(ch, EPrf::kPerformPowerAttack)) {
		hr -= 2;
	}
	if (PRF_FLAGGED(ch, EPrf::kPerformGreatPowerAttack)) {
		hr -= 4;
	}
	if (PRF_FLAGGED(ch, EPrf::kPerformAimingAttack)) {
		hr += 2;
	}
	if (PRF_FLAGGED(ch, EPrf::kPerformGreatAimingAttack)) {
		hr += 4;
	}
	hr -= (ch->IsOnHorse() ? (10 - GET_SKILL(ch, ESkill::kRiding) / 20) : 0);
	hr *= ch->get_cond_penalty(P_HITROLL);
	return hr;
}

const char *GetPositionStr(CharData *ch) {
	switch (GET_POS(ch)) {
		case EPosition::kDead:
			return " !\r\n";
		case EPosition::kPerish:
			return "      !\r\n";
		case EPosition::kIncap:
			return "     ...\r\n";
		case EPosition::kStun:
			return "  !\r\n";
		case EPosition::kSleep:
			return " .\r\n";
		case EPosition::kRest:
			return " .\r\n";
		case EPosition::kSit:
			return " .\r\n";
		case EPosition::kFight:
			if (ch->GetEnemy()) {
				sprintf(buf1, "   %s.\r\n", GET_PAD(ch->GetEnemy(), 4));
				return buf1;
			}
			else
				return "    .\r\n";
		case EPosition::kStand:
			return " .\r\n";
		default:
			break;
	}
	return "   !!!\r\n";
}

const char *GetShortPositionStr(CharData *ch) {
	if (!ch->IsOnHorse()) {
		switch (GET_POS(ch)) {
			case EPosition::kDead: return " !";
			case EPosition::kPerish: return " !";
			case EPosition::kIncap: return "  .";
			case EPosition::kStun: return "  !";
			case EPosition::kSleep: return " .";
			case EPosition::kRest: return " .";
			case EPosition::kSit: return " .";
			case EPosition::kFight:
				if (ch->GetEnemy()) {
					return " !";
				} else {
					return "  .";
				}
			case EPosition::kStand: return " .";
			default: return "You are void...";
		}
	} else {
		return "  .";
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
