#include "obj_prototypes.h"
#include "entities/char_data.h"
#include "handler.h"
#include "house.h"
#include "liquid.h"
#include "game_fight/pk.h"
#include "utils/utils_char_obj.inl"

//    .  ,    .
const int kMaxLabelLength = 32;

void DoSign(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	char arg1[kMaxInputLength];
	char arg2[kMaxInputLength];

	char arg3[kMaxInputLength];
	char arg4[kMaxInputLength];

	ObjData *target = nullptr;
	int erase_only = 0; // 0 --   , 1 --  
	int clan = 0; //  ,  . ,  
	int no_target = 0; //    ,   

	char *objname = nullptr;
	char *labels = nullptr;

	if (ch->IsNpc())
		return;

	half_chop(argument, arg1, arg2);

	if (!strlen(arg1))
		no_target = 1;
	else {
		if (!strcmp(arg1, "")) { //   arg1 "",   arg2     
			clan = 1;
			if (strlen(arg2)) {
				half_chop(arg2, arg3, arg4); //  arg3   
				objname = str_dup(arg3);
				if (strlen(arg4))
					labels = str_dup(arg4);
				else
					erase_only = 1;
			} else {
				no_target = 1;
			}
		} else { //  ""  , ,   arg1       arg2
			if (strlen(arg1)) {
				objname = str_dup(arg1);
				if (strlen(arg2))
					labels = str_dup(arg2);
				else
					erase_only = 1;
			} else {
				no_target = 1;
			}
		}
	}

	if (no_target) {
		SendMsgToChar("  ?\r\n", ch);
	} else {
		if (!(target = get_obj_in_list_vis(ch, objname, ch->carrying))) {
			sprintf(buf, "   \'%s\'.\r\n", objname);
			SendMsgToChar(buf, ch);
		} else {
			if (erase_only) {
				target->remove_custom_label();
				act("    $o5.", false, ch, target, nullptr, kToChar);
			} else if (labels) {
				if (strlen(labels) > kMaxLabelLength)
					labels[kMaxLabelLength] = '\0';

				//  
				for (int i = 0; labels[i] != '\0'; i++)
					if (labels[i] == '~')
						labels[i] = '-';

				std::shared_ptr<custom_label> label(new custom_label());
				label->text_label = str_dup(labels);
				label->author = ch->get_idnum();
				label->author_mail = str_dup(GET_EMAIL(ch));

				const char *msg = "  $o3 ,      .";
				if (clan && ch->player_specials->clan) {
					label->clan_abbrev = str_dup(ch->player_specials->clan->GetAbbrev());
					msg = "  $o3 ,     .";
				}
				target->set_custom_label(label);
				act(msg, false, ch, target, nullptr, kToChar);
			}
		}
	}

	if (objname) {
		free(objname);
	}

	if (labels) {
		free(labels);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
