/**
 \authors Created by Sventovit
 \date 20.01.2021.
 \brief  "".
*/

#include "entities/char_data.h"
#include "handler.h"

void do_insult(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	CharData *victim;

	one_argument(argument, arg);

	if (!ch->IsNpc() && PLR_FLAGGED(ch, EPlrFlag::kDumbed)) {
		SendMsgToChar("        !\r\n", ch);
		return;
	}
	if (*arg) {
		if (!(victim = get_char_vis(ch, arg, EFind::kCharInRoom)))
			SendMsgToChar("&K      :(&n\r\n", ch);
		else {
			if (victim != ch) {
				sprintf(buf, "&K  %s.&n\r\n", GET_PAD(victim, 3));
				SendMsgToChar(buf, ch);

				switch (number(0, 2)) {
					case 0:
						if (IS_MALE(ch)) {
							if (IS_MALE(victim))
								act("&K$n $g     !&n",
									false, ch, nullptr, victim, kToVict);
							else
								act("&K$n $g,     - ,   .&n",
									false, ch, nullptr, victim, kToVict);
						} else    // Ch == Woman
						{
							if (IS_MALE(victim))
								act("&K$n $g ,   $s ... ( $e $g  ?)&n",
									false, ch, nullptr, victim, kToVict);
							else
								act("&K$n $g       -.&n",
									false, ch, nullptr, victim, kToVict);
						}
						break;
					case 1:
						act("&K$n1 -    !&n", false,
							ch, nullptr, victim, kToVict);
						break;
					default:
						act("&K$n $g    !\r\n"
							"$e $g,       .&n",
							false, ch, nullptr, victim, kToVict);
						break;
				}    // end switch

				act("&K$n $g $N1. .&n", true, ch, nullptr, victim, kToNotVict);
			} else    // ch == victim
			{
				SendMsgToChar("&K   .&n\r\n", ch);
			}
		}
	} else
		SendMsgToChar("&K ,      ?&n\r\n", ch);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
