/************************************************************************ *
*   File: constants.cpp                                 Part of Bylins    *
*  Usage: Numeric and string contants used by the MUD                     *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
*                                                                         *
*  $Author$                                                        *
*  $Date$                                           *
*  $Revision$                                                       *
************************************************************************ */

#include "constants.h"
#include "game_magic/spells.h"

const char *circlemud_version = "CircleMUD, version 3.00 beta patchlevel 16";

const MobVnum kHorseVnum = 4014;
const ObjVnum kStartBread = 125;
const ObjVnum kCreateLight = 126;
const int kHorseCost = 100;

//Experience multiplication coefficients
double exp_coefficients[] =
	{
		1.0,            //0 remorts
		1.0 / 0.9,        //1 remort
		1.0 / 0.8,        //2 remorts
		1.0 / 0.7,        //3 remorts
		1.0 / 0.6,        //4 remorts
		1.0 / 0.5,        //5 remorts
		1.0 / 0.4,        //6 remorts
		1.0 / 0.3,        //7 remorts
		1.0 / 0.2,        //8 remorts
		1.0 / 0.1,        //9 remorts
		1.0 / 0.09,        //10 remorts
		1.0 / 0.08,        //11 remorts
		1.0 / 0.07,        //12 remorts
		1.0 / 0.06,        //13 remorts
		1.0 / 0.05,        //14 remorts
		1.0 / 0.05        //15 remorts
	};


// strings corresponding to ordinals/bitvectors in structs.h **********


// (Note: strings for class definitions in class.c instead of here)


// cardinal directions
const char *dirs[] =
	{
		"north",
		"east",
		"south",
		"west",
		"up",
		"down",
		"\n"
	};

const char *DirsTo[] =
	{
		" ",
		" ",
		" ",
		" ",
		"",
		"",
		"\n"
	};

const char *DirsFrom[] =
	{
		" ",
		" ",
		" ",
		" ",
		"",
		"",
		"\n"
	};

// ROOM_x
const char *room_bits[] =
	{
		"",
		"",
		"  ",
		"",
		"",
		"",
		" ",
		" ",
		"",
		"   ",
		"",
		"",
		"*HCRSH",
		"  ",
		"* ",
		"*",            // BFS MARK
		" ",
		" ",
		" ",
		" ",
		" ",
		" ",
		" ",
		" ",
		"",
		"",
		"",
		" ",
		" ",
		"",
		"\n",
		" ",
		"   ",
		" ",
		"",
		" ",
		"*  ",
		" ",
		" ",
		" ",
		" ",
		"",
		" ",
		" ",
		"\n",
		"  ",
		" ",
		"\n",
		"\n"
	};

// EX_x
const char *exit_bits[] =
	{
		" ",
		"",
		"",
		" ",
		"",
		" ",
		" ",
		"\n"
	};

// SECT_
const char *sector_types[] =
	{
		" ",
		"",
		"",
		"",
		"",
		"",
		". ",
		". ",
		" ",
		" ",
		"",
		" ",
		" ",
		" ",
		"\n"
	};

/*
 * SEX_x
 * Not used in sprinttype() so no \n.
 */
const char *genders[] = {"",
						 "",
						 "",
						 "",
						 "\n"
};

// POS_x
const char *position_types[] = {"",
								" ",
								" ",
								" ",
								"",
								"",
								"",
								"",
								"",
								"\n"
};

// RESISTANCE_x
const char *resistance_types[] = {"   ",
								  "   ",
								  "   ",
								  "   ",
								  "   ",
								  "   ",
								  "    ",
								  "   ",
								  "\n"
};

// EPlrFlag::x
const char *player_bits[] =
	{
		"",
		"",
		"",
		"DONTSET",
		"",
		" ",
		"CSH",
		"SITEOK",
		" ",
		" ",
		"",
		"  ",
		"",
		"   ",
		"INVST",
		"CRYO",
		"HELL",
		"NAMED",
		"REGED",
		"DUMB",
		"",
		"",
		"<null>",
		"<null>",
		"<null>",
		"<null>",
		"<null>",
		"<null>",
		"*", // reserved for MOB_DELETE
		"*", // reserved for MOB_FREE
		"\n",
		"\n",
		"\n",
		"\n"
	};

// MOB_x
const char *action_bits[] = {"*",
							 "!",
							 "",
							 "",
							 "!",
							 "",
							 "",
							 "",
							 ".",
							 ".",
							 ".",
							 "",
							 "",
							 "!",
							 "!",
							 "!",
							 "!",
							 "!",
							 "",
							 "!",
							 "!",
							 ".",
							 ".",
							 "!",
							 "!",
							 "",
							 "",
							 "!",
							 "*",
							 "*",
							 "\n",
							 "",
							 "",
							 "  ",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 ".",
							 "!",
							 " ",
							 "",
							 "",
							 "!..",
							 "!",
							 "*-",
							 "*-",
							 ".",
							 "...",
							 "!.",
							 "* ",
							 "*",
							 "\n",
							 " ",
							 " ",
							 " ",
							 " ",
							 " ",
							 "! ",
							 "!",
							 " ",
							 "!",
							 "!",
							 " ",
							 " !",
							 " ",
							 "*",
							 "!",
							 " ",
							 ".",
							 "\n",
							 "\n"
};

const char *function_bits[] = {"!",
							   "!",
							   "!",
							   "!",
							   "!",
							   "!",
							   "",
							   "",
							   "",
							   "",
							   "*",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "*",
							   "*",
							   "*",
							   "*",
							   "",
							   "",
							   "",
							   "",
							   "  ",
							   "!",
							   "!",
							   "!",
							   "\n",
							   "",
							   "",
							   "",
							   " ",
							   "! ",
							   "\n",
							   "\n",
							   "\n"
};

// EPrf::x
const char *preference_bits[] = {"",
								 "",
								 "!",
								 "!",
								 ".",
								 ".",
								 ".",
								 "",
								 "!",
								 "",
								 "",
								 "!",
								 "",
								 " 1",
								 " 2",
								 "!",
								 " 1",
								 " 2",
								 "!",
								 "!",
								 "  ",
								 " ",
								 ".",
								 ".",
								 ".",
								 ".",
								 ".",
								 " ",
								 " ",
								 "",
								 "\n",
								 "",
								 "!",
								 "IAC GA",
								 "  ",
								 " ",
								 "",
								 "",
								 " ",
								 "!",
								 "!",
								 "!",
								 "!-",
								 " ",
								 "  ",
								 " ",
								 "  ",
								 "",
								 "",
								 ".",
								 ".",
								 ".",
								 ".",
								 ".",
								 ".",
								 "",
								 "",
								 " ",
								 " .",
								 "  .",
								 "",
								 "\n",
								 "!",
								 "",
								 ".",
								 " ",
								 "  ",
								 "",
								 " .",
								 "..",
								 ".",
								 ".",
								 ".",
								 ".",
								 ".IP",
								 " ",
								 " ",
								 " ",
								 " ",
								 " ",
								 " telegram",
								 " ",
								 "\n"
};

// AFF_ROOM_x
//        -  DETECT_MAGIC
const char *room_aff_visib_bits[] =
	{
		"&W...    ...&n",    // 0
		"&G...    ...&n",        // AFF_FOG
		"",    // AFF_RUNE_LABEL
		"", // AFF_FORBIDDEN
		"&Y...       ...&n", // AFF_HYPNOTIC_PATTERN
		"&K...           !&n", // AFF_EVARDS_BLACK_TENTACLES
		"&R...      !&n", // AFF_METEORSTORM
		"&W...       ...&n", // AFF_THUNDERSTORM
		"\n",
		"\n",
		"\n"
	};

//        -  DETECT_MAGIC
const char *room_aff_invis_bits[] =
	{
		"&W...    ...&n",    // 0
		"&G...      &n ...", // AFF_FOG
		"&G...       أ-  ...&n",    // AFF_RUNE_LABEL
		"&c...      ...&n", // AFF_FORBIDDEN
		"&Y...       ...&n", // AFF_HYPNOTIC_PATTERN
		"&K...           !&n", // AFF_EVARDS_BLACK_TENTACLES
		"&R...      !&n", // AFF_METEORSTORM
		"&W...       ...&n", // AFF_THUNDERSTORM
		"\n",
		"\n",
		"\n",
	};

const char *room_self_aff_invis_bits[] =
	{
		"&W...    ...&n",    // 0
		"&G...      &n ...", // AFF_FOG
		"&G...         ...&n",    // AFF_RUNE_LABEL
		"&c...      ...&n", // AFF_FORBIDDEN
		"&Y...       ...&n", // AFF_HYPNOTIC_PATTERN
		"&K...           !&n", // AFF_EVARDS_BLACK_TENTACLES
		"&R...      !&n", // AFF_METEORSTORM
		"&W...       ...&n", // AFF_THUNDERSTORM
		"\n",
		"\n",
		"\n",
	};

// CON_x
const char *connected_types[] =
	{
		// 0-9
		" ",
		"Disconnecting",
		"Get name",
		"Confirm name",
		"Get password",
		"Get new PW",
		"Confirm new PW",
		"Select sex",
		"Select class",
		"Reading MOTD",
		// 10-19
		"Main Menu",
		"Get descript.",
		"Changing PW 1",
		"Changing PW 2",
		"Changing PW 3",
		"Self-Delete 1",
		"Self-Delete 2",
		"Disconnecting",
		"Object edit",
		"Room edit",
		// 20-29
		"Zone edit",
		"Mobile edit",
		"Trigger edit",
		"Get name2",
		"Get name3",
		"Get name4",
		"Get name5",
		"Get name6",
		"Select religion",
		"Select race",
		// 30-39
		"Select lows",
		"Select keytable",
		"Get email",
		"Roll stats",
		"Recept edit",
		"Select kin",
		"ERROR",		// ,  
		"ERROR",		// ,  
		"map olc",
		"Select color",
		// 40-49
		"Board message edit",
		"House edit",
		"Generate new name",
		"Glory OLC",
		"Base stats reroll",
		"Select place of birth",
		"Clan MoD edit",
		"GloryConst OLC",
		"NamedStuff OLC",
		"Select new kin",
		// 50-57
		"Select new race",
		"Interactive console",
		" ",
		"  ",
		"sedit",
		"select new religion",
		"Verification",
		"Just connected",
		"\n"
	};

/*
 * WEAR_x - for eq list
 * Not use in sprinttype() so no \n.
 */
const char *where[] = {"< >             ",
					   "<  > ",
					   "<  >  ",
					   "< >                    ",
					   "< >                  ",
					   "< >                   ",
					   "< >                 ",
					   "< >                  ",
					   "< >                ",
					   "< >                 ",
					   "< >                  ",
					   "<>                       ",
					   "< >                 ",
					   "< >                  ",
					   "<  >        ",
					   "<  >         ",
					   "<  >             ",
					   "<  >              ",
					   "<  >             ",
					   "< >                 "
};

// WEAR_x - for stat
const char *equipment_types[] = {"  ",
								 "    ",
								 "    ",
								 "  ",
								 "  ",
								 "  ",
								 "  ",
								 "  ",
								 "",
								 " ",
								 "  ",
								 "  ",
								 "  ",
								 "  ",
								 "  ",
								 "  ",
								 "   ",
								 "   ",
								 "   ",
								 "  ",
								 "\n"
};

// ITEM_x (ordinal object types)
const char *item_types[] = {"UNDEFINED",
							"",
							"",
							"",
							"",
							"",
							" ",
							"",
							"",
							"",
							"",
							"",
							"",
							"TRASH",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							" ",
							" ",
							" ",
							"",
							"",
							" ",
							" ",
							" ",
							" ",
							" ",
							" ",
							" ",
							"\n"
};

const char *ingradient_bits[] = {"",
								 ".",
								 ".",
								 ".",
								 "",
								 "\n"
};

const char *magic_container_bits[] = {"",
									  "",
									  "",
									  "\n"
};

// ITEM_WEAR_ (wear bitvector)
const char *wear_bits[] = {"",
						   "",
						   "/",
						   "",
						   "",
						   "",
						   "",
						   "",
						   "",
						   "",
						   "",
						   "",
						   "",
						   ".",
						   ".",
						   ".",
						   "",
						   "\n"
};

// ITEM_x (extra bits)
const char *extra_bits[] = {"",
							"",
							"!",
							"!",
							"!",
							"",
							"",
							"!",
							"",
							"!",
							"",
							"  ",
							"!",
							"!",
							"*",
							"",
							"",
							"* ",
							"* ",
							"* ",
							"* ",
							"* ",
							"* ",
							"* ",
							"",
							"",
							" ",
							"* ",
							"",
							"  ",
							"\n",
							"!",
							"  ",
							"  ",
							"  1 ",
							"  2 ",
							"  3 ",
							" ",
							"  ",
							"* ",
							"*",
							"* ",
							"*  ",
							"*  ",
							"!",
							"",
							"* ",
							"*     ",
							"!",
							"*  ",
							"*    ",
							"\n",
							"\n",
							"\n"
};

// ITEM_NO_
const char *no_bits[] = {"!",
						 "!",
						 "!NEUTRAL",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "\n",
						 "!",
						 "!",
						 "!",
						 "\n",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "!",
						 "\n",
						 "!",
						 "!",
						 "!",
						 "!",
						 "\n",
						 "\n"
};

// ITEM_ANTI
const char *anti_bits[] = {"!",
						   "!",
						   "!NEUTRAL",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "\n",
						   "!",
						   "!",
						   "!",
						   "\n",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "!",
						   "\n",
						   "!",
						   "!",
						   "!",
						   "!",
						   "\n",
						   "\n"
};

const std::vector<ApplyNegative> apply_negative = {
	{"", EApply::kAc, ESaving::kNone},
	{"", EApply::kSavingWill, ESaving::kWill},
	{"", EApply::kSavingCritical, ESaving::kCritical},
	{"", EApply::kSavingStability, ESaving::kStability},
	{"", EApply::kSavingReflex, ESaving::kReflex},
};

const std::map<ESaving, std::string> saving_name = {
	{ESaving::kWill, ""},
	{ESaving::kCritical, ""},
	{ESaving::kStability, ""},
	{ESaving::kReflex, ""},
	{ESaving::kNone, ""},
};

// MAT_
const char *material_name[] = {"",
							   "",
							   "",
							   "",
							   "",
							   ".",
							   ".",
							   "",
							   "",
							   ".",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   ".",
							   "\n"
};

int material_value[] = {100,
						5,
						50,
						35,
						30,
						20,
						35,
						75,
						45,
						40,
						65,
						80,
						55,
						50,
						70,
						60,
						90,
						90,
						10
};

// CONT_x
const char *container_bits[] =
	{
		"CLOSEABLE",
		"PICKPROOF",
		"CLOSED",
		"LOCKED",
		"LOCK_BROKEN",
		"\n",
	};

/*
 *         
 * Not used in sprinttype() so no \n.
 */
const char *fullness[] =
	{
		",    ",
		",   ",
		"  ",
		",   ",
		"  ",
		""
	};

struct IntApplies int_app[] =
	{
//Ackn  SkUse  SpLv     SpCnt Impr Obser
		{10, -10, 10, 0, 2, -5},    // int = 0
		{10, -10, 10, 0, 2, -5},    // int = 1
		{10, -9, 10, 0, 2, -5},
		{14, -9, 10, 0, 2, -4},
		{18, -9, 15, 0, 2, -4},
		{22, -8, 20, 0, 3, -3},    // int = 5
		{26, -8, 25, 0, 3, -2},
		{30, -7, 30, 0, 3, -2},
		{34, -7, 40, 0, 3, -1},
		{38, -6, 50, 0, 3, -1},
		{42, -6, 60, 0, 4, 0},    // int = 10
		{46, -5, 63, 0, 4, 0},
		{50, -5, 66, 0, 4, 0},
		{53, -4, 69, 0, 4, 0},
		{57, -3, 72, 0, 5, 0},
		{60, -2, 75, 0, 5, 1},    // int = 15
		{64, -1, 78, 0, 6, 1},
		{68, 0, 81, 0, 6, 2},
		{72, 0, 84, 0, 7, 2},    // int = 18
		{76, 1, 87, 0, 7, 3},
		{80, 1, 90, 0, 8, 3},    // int = 20
		{82, 2, 92, 0, 8, 3},
		{84, 3, 94, 0, 8, 4},
		{86, 3, 96, 0, 8, 4},
		{88, 4, 98, 0, 8, 4},
		{90, 5, 100, 0, 9, 5},    // int = 25
		{91, 6, 105, 0, 9, 5},
		{92, 6, 110, 0, 9, 5},
		{93, 6, 115, 0, 9, 6},
		{94, 7, 120, 0, 9, 6},
		{95, 7, 130, 0, 10, 7},    // int = 30
		{95, 7, 135, 0, 10, 7},
		{95, 8, 140, 0, 10, 7},
		{95, 8, 145, 0, 10, 7},
		{95, 8, 150, 0, 10, 7},
		{96, 9, 150, 0, 11, 8},    // int = 35
		{96, 9, 155, 0, 11, 8},
		{96, 9, 155, 0, 11, 8},
		{96, 9, 160, 0, 11, 8},
		{96, 10, 160, 0, 11, 8},
		{97, 10, 165, 0, 12, 9},    // int = 40
		{97, 10, 165, 0, 12, 9},
		{97, 10, 170, 0, 12, 9},
		{97, 11, 170, 0, 12, 9},
		{97, 11, 175, 0, 13, 9},
		{98, 11, 175, 0, 13, 10},    // int = 45
		{98, 12, 180, 0, 13, 11},
		{98, 12, 180, 0, 14, 12},
		{99, 12, 190, 0, 14, 13},
		{99, 12, 190, 0, 14, 14},
		{100, 12, 200, 0, 15, 15},    // int = 50
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    // int = 55
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    //int = 60
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    // int = 65
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    //int = 70
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    // int = 75
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    //int = 80
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    // int 85
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    //int = 90
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},    //int = 95
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15},
		{100, 12, 200, 0, 15, 15}    //int = 100
	};

const size_t INT_APP_SIZE = sizeof(int_app) / sizeof(*int_app);

#define s0 (0)
#define s1 (1 << 0)
#define s2 (1 << 1)
#define s3 (1 << 2)
#define s4 (1 << 3)
#define s5 (1 << 4)
#define s6 (1 << 5)
#define s7 (1 << 6)

struct SizeApplies size_app[] =
	{
// AC  BASH
		{-2, -10, 5, 1},    // size = 0
		{-2, -10, 5, 1},    // size = 2
		{-2, -10, 5, 1},
		{-2, -9, 4, 1},
		{-2, -9, 4, 2},
		{-2, -8, 4, 2},        // size = 10
		{-2, -8, 4, 2},
		{-2, -7, 4, 2},
		{-2, -7, 3, 2},
		{-2, -7, 3, 3},
		{-2, -6, 3, 3},        // size = 20
		{-1, -6, 3, 3},
		{-1, -6, 3, 3},
		{-1, -5, 2, 4},
		{-1, -5, 2, 4},
		{-1, -4, 2, 4},        // size = 30
		{-1, -4, 2, 4},
		{-1, -4, 2, 5},
		{-1, -3, 1, 5},
		{-1, -3, 1, 6},
		{-1, -2, 1, 6},        // size = 40
		{0, -2, 1, 7},
		{0, -1, 1, 7},
		{0, -1, 0, 8},
		{0, 0, 0, 9},
		{0, 0, 0, 9},        // size = 50
		{0, 0, 0, 10},
		{0, 1, 0, 11},
		{0, 1, -1, 11},
		{0, 1, -1, 12},
		{0, 2, -1, 12},        // size = 60
		{1, 2, -1, 13},
		{1, 2, -1, 13},
		{1, 3, -2, 14},
		{1, 3, -2, 14},
		{1, 4, -2, 15},        // size = 70
		{2, 4, -2, 16},
		{2, 5, -2, 17},
		{2, 5, -3, 18},
		{2, 5, -3, 19},
		{3, 6, -3, 20},        // size = 80
		{3, 6, -3, 21},
		{3, 7, -3, 22},
		{3, 7, -4, 23},
		{3, 7, -4, 24},
		{4, 8, -4, 25},        // size = 90
		{4, 8, -4, 26},
		{4, 9, -4, 27},
		{5, 9, -5, 28},
		{5, 10, -5, 29},
		{5, 10, -5, 30},    // size = 100
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    // size = 110
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 120
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 130
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 140
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 150
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 160
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 170
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 180
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},    //size = 190
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30},
		{5, 10, -5, 30}        //size = 200
	};

struct ChaApplies cha_app[] =
	{
// Lead Chrm Mr Illu Dam_to_hit_rate
		{-6, 50, 0, -6, 20},    // size = 0
		{-6, 70, 0, -6, 20},    // size = 1
		{-6, 90, 0, -6, 20},
		{-6, 100, 0, -5, 20},
		{-5, 120, 0, -5, 20},
		{-4, 140, 0, -4, 20},    // size = 5
		{-3, 160, 0, -4, 20},
		{-2, 180, 0, -4, 20},
		{-1, 200, 0, -3, 20},
		{0, 220, 0, -3, 20},
		{0, 260, 0, -2, 20},    // size = 10
		{1, 300, 0, -2, 20},
		{2, 340, 0, -1, 20},
		{3, 380, 0, -1, 20},
		{4, 420, 0, 0, 20},
		{5, 460, 0, 0, 20},    // size = 15
		{5, 500, 0, 1, 20},
		{6, 550, 0, 3, 20},
		{6, 600, 0, 5, 20},
		{7, 650, 0, 7, 20},
		{7, 700, 0, 9, 20},    // size = 20
		{8, 800, 0, 11, 20},
		{8, 840, 0, 12, 20},
		{9, 880, 0, 13, 20},
		{9, 920, 0, 14, 20},
		{10, 960, 0, 15, 20},    // size = 25
		{11, 1000, 0, 16, 20},
		{12, 1200, 0, 17, 20},
		{13, 1400, 0, 18, 20},
		{14, 1600, 0, 19, 20},
		{15, 1800, 0, 20, 20},    // size = 30
		{16, 2000, 0, 21, 20},
		{17, 2100, 0, 22, 20},
		{18, 2200, 0, 23, 20},
		{19, 2400, 0, 24, 20},
		{20, 2600, 0, 25, 20},    // size = 35
		{21, 2800, 0, 26, 20},
		{22, 3000, 0, 27, 20},
		{23, 3200, 0, 28, 20},
		{24, 3400, 0, 29, 20},
		{25, 3500, 0, 30, 20},    // size = 40
		{26, 3700, 0, 31, 20},
		{27, 3900, 0, 32, 20},
		{28, 4000, 0, 33, 20},
		{29, 4100, 0, 34, 20},
		{30, 4300, 0, 35, 20},    // size = 45
		{31, 4500, 0, 36, 20},
		{32, 4600, 0, 37, 20},
		{33, 4700, 0, 38, 20},
		{34, 4900, 0, 39, 20},
		{35, 5100, 0, 40, 20},    // size = 50
		{36, 5300, 0, 41, 20},
		{37, 5400, 0, 42, 20},
		{38, 5500, 0, 43, 20},
		{39, 5700, 0, 44, 20},
		{40, 5900, 0, 45, 20},    // size = 55
		{41, 6000, 0, 46, 20},
		{42, 6100, 0, 47, 20},
		{43, 6200, 0, 48, 20},
		{44, 6400, 0, 49, 20},
		{45, 6500, 0, 50, 20},    // size = 60
		{46, 6600, 0, 51, 20},
		{47, 6700, 0, 52, 20},
		{48, 6800, 0, 53, 20},
		{49, 6900, 0, 54, 20},
		{50, 6900, 0, 55, 20},    // size = 65
		{51, 7000, 0, 56, 20},
		{52, 7100, 0, 57, 20},
		{53, 7200, 0, 58, 20},
		{54, 7300, 0, 59, 20},
		{55, 7400, 0, 60, 20},    // size = 70
		{56, 7400, 0, 61, 20},
		{57, 7500, 0, 62, 20},
		{58, 7600, 0, 63, 20},
		{59, 7700, 0, 64, 20},
		{60, 7600, 0, 65, 20},    // size = 75
		{61, 7800, 0, 66, 20},
		{62, 7800, 0, 67, 20},
		{63, 7800, 0, 68, 20},
		{64, 7900, 0, 69, 20},
		{65, 8000, 0, 70, 20},    // size = 80
		{66, 8000, 0, 71, 20},
		{67, 8100, 0, 72, 20},
		{68, 8200, 0, 73, 20},
		{69, 8300, 0, 74, 20},
		{70, 8400, 0, 75, 20},    // size = 85
		{71, 8500, 0, 76, 20},
		{72, 8600, 0, 77, 20},
		{73, 8700, 0, 78, 20},
		{74, 8900, 0, 79, 20},
		{75, 9000, 0, 80, 20},    // size = 90
		{76, 9000, 0, 81, 20},
		{77, 9100, 0, 82, 20},
		{78, 9100, 0, 83, 20},
		{79, 9100, 0, 84, 20},
		{80, 9200, 0, 85, 20},    // size = 95
		{81, 9300, 0, 86, 20},
		{82, 9400, 0, 87, 20},
		{83, 9500, 0, 88, 20},
		{84, 9600, 0, 89, 20},
		{85, 9700, 0, 90, 20}    // size = 100
	};

struct WeaponApplies weapon_app[] =
	{
// Sho   Bash  Parrying
		{1, -5, -10},        // ww = 0
		{1, -4, -10},        // ww = 1
		{1, -3, -8},
		{2, -2, -6},
		{2, -1, -4},
		{3, 0, -2},        // ww = 5
		{3, 1, 0},
		{4, 2, 2},
		{4, 3, 4},
		{5, 4, 6},
		{5, 5, 8},        // ww = 10
		{5, 6, 10},
		{6, 7, 11},
		{6, 8, 12},
		{7, 9, 13},
		{7, 10, 15},        // ww = 15
		{8, 12, 16},
		{8, 14, 17},
		{9, 16, 18},        // ww = 18
		{9, 18, 19},
		{10, 20, 20},        // ww = 20
		{11, 21, 21},
		{12, 22, 22},
		{13, 23, 23},
		{14, 24, 24},
		{15, 25, 25},        // ww = 25
		{16, 26, 26},
		{17, 27, 27},
		{18, 28, 28},
		{19, 29, 29},
		{20, 30, 30},        // ww = 30
		{22, 31, 31},
		{24, 32, 32},
		{26, 33, 33},
		{28, 34, 34},
		{30, 35, 35},        // ww = 35
		{32, 36, 36},
		{34, 37, 37},
		{36, 38, 38},
		{38, 39, 39},
		{40, 40, 40},        // ww = 40
		{41, 41, 41},
		{42, 42, 42},
		{43, 43, 43},
		{44, 44, 44},
		{45, 45, 45},        // ww = 45
		{46, 46, 46},
		{47, 47, 47},
		{48, 48, 48},
		{49, 49, 49},
		{50, 50, 50},        // ww = 50
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},           // ww = 55
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 60
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 65
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 70
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 75
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 80
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 85
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 90
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 95
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},
		{50, 50, 50},        // ww = 100
	};

namespace {

const char *tmp_npc_race_types[] =
	{
		"",
		"",
		"",
		"-",
		"",
		"",
		"-",
		"-",
		""
	};

} //namespace

// MSVS 2012 c++11 suck
const std::vector<const char *> npc_role_types(tmp_npc_race_types,
											   tmp_npc_race_types + sizeof(tmp_npc_race_types) / sizeof(const char *));

//Polud new mob races. (26/01/2009)
const char *npc_race_types[] = {"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								" ",
								"",
								"",
								" ",
								" ",
								"\n"
};
//-Polud

const char *places_of_birth[] = {"",
								 "",
								 "\n"
};

int rev_dir[] =
	{
		2,
		3,
		0,
		1,
		5,
		4
	};

#if defined(OASIS_MPROG)
// * Definitions necessary for MobProg support in OasisOLC
const char *mobprog_types[] = {
	"INFILE",
	"ACT",
	"SPEECH",
	"RAND",
	"FIGHT",
	"DEATH",
	"HITPRCNT",
	"ENTRY",
	"GREET",
	"ALL_GREET",
	"GIVE",
	"BRIBE",
	"\n"
};
#endif

int movement_loss[] =
	{
		1,            // Inside
		1,            // City
		2,            // Field
		3,            // Forest
		4,            // Hills
		6,            // Mountains
		4,            // Swimming
		1,            // Unswimable
		1,            // Flying
		5,            // Underwater
		1,            // Secret
		1, //  
		2, //  
		4, //  
		0, 0, 0, 0, 0, 0,
		3,            // Field snow
		4,            // Field water
		4,            // Forest snow
		5,            // Forest water
		5,            // Hills snow
		6,            // Hills water
		8,            // Mountains snow
		2,            // THIN ice
		2,            // NORMAL ice
		2
	};

// Not used in sprinttype().
const char *weekdays[] = {"",
						  "",
						  "",
						  "",
						  "",
						  "",
						  ""
};

const char *weekdays_poly[] = {"",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   "",
							   ""
};

// Not used in sprinttype().
const char *month_name[] = {"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							"",
							""
};
const char *month_name_real[] = {"",
								 "",
								 "",
								 "",
								 "",
								 "",
								 "",
								 "",
								 "",
								 "",
								 "",
								 ""
};

const char *month_name_poly[] = {" -      ",
								 " -    ",
								 " -   ",
								 " -    ",
								 " -  ",
								 " -    ",
								 " -  ",
								 " -   ",
								 " -   "
};

const char *month_name_o[] = {" ",
							  "  ",
							  "  ",
							  "  ",
							  "  ",
							  " ",
							  " ",
							  " ",
							  " ",
							  " ",
							  " ",
							  " ",
							  "  ",
							  " ",
							  "  ",
							  "  ",
							  "  "
};

const char *weapon_affects[] = {"",
								"",
								".",
								".",
								".",
								".",
								"",
								"",
								"",
								"",
								"",
								"..",
								"..",
								"",
								".",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								"",
								".",
								"",
								"",
								"",
								".",
								"",
								"",
								"\n",
								".",
								"",
								"",
								".",
								".",
								".",
								".",
								".",
								".",
								".",
								".",
								".",
								".",
								"",
								"",
								".",
								"\n",
								"\n",
								"\n"
};

const char *pray_metter[] = {"- ",
							 "- ",
							 "- ",
							 "- ",
							 "* -",
							 "* -",
							 "* -",
							 "* -",
							 "\n"
};

const char *pray_whom[] = {"",
						   "",
						   "",
						   "",
						   "-",
						   "-",
						   "-",
						   "-",
						   "\n"
};

// Fields : whom location modifier bitvector battleflag
std::vector<PrayAffect> pray_affect =
	{
		{0, EApply::kNone, 0, to_underlying(EAffect::kInfravision), 0},    // 
		{1, EApply::kHpRegen, 50, 0, 0},    // 
		{2, EApply::kStr, 1, 0, 0},    // 
		{3, EApply::kDex, 1, 0, 0},    // 
		{4, EApply::kMorale, 5, 0, 0},    //  
		{5, EApply::kInt, 1, 0, 0},    //  
		{6, EApply::kHitroll, 2, 0, 0},    //  
		{7, EApply::kDamroll, 1, 0, 0}    //  
	};

//   
int mana[] = {0,        // Wiz= 0
			  100,            // Wiz= 1
			  250,            // Wiz= 2
			  500,            // Wiz= 3
			  750,            // Wiz= 4
			  1000,            // Wiz= 5
			  1250,            // Wiz= 6
			  1500,            // Wiz= 7
			  1750,            // Wiz= 8
			  2000,            // Wiz= 9
			  2250,            // Wiz=10
			  2500,            // Wiz=11
			  2750,            // Wiz=12
			  3000,            // Wiz=13
			  3250,            // Wiz=14
			  3500,            // Wiz=15
			  3650,            // Wiz=16
			  3900,            // Wiz=17
			  4400,            // Wiz=18
			  4900,            // Wiz=19
			  5400,            // Wiz=20
			  5900,            // Wiz=21
			  6400,            // Wiz=22
			  6900,            // Wiz=23
			  7400,            // Wiz=24
			  7900,            // Wiz=25
			  8400,            // Wiz=26
			  8900,            // Wiz=27
			  9400,            // Wiz=28
			  9900,            // Wiz=29
			  10400,            // Wiz=30
			  10900,            // Wiz=31
			  11400,            // Wiz=32
			  11900,            // Wiz=33
			  12400,            // Wiz=34
			  12900,            // Wiz=35
			  13400,            // Wiz=36
			  13900,            // Wiz=37
			  14400,            // Wiz=38
			  14900,            // Wiz=39
			  15400,            // Wiz=40
			  15900,            // Wiz=41
			  16400,            // Wiz=42
			  16900,            // Wiz=43
			  17400,            // Wiz=44
			  17900,            // Wiz=45
			  18400,            // Wiz=46
			  18900,            // Wiz=47
			  19400,            // Wiz=48
			  19900,            // Wiz=49
			  25000        // Wiz=50
};

//          
int mana_gain_cs[] = {2,    // Int= 0
					  3,            // Int= 1
					  3,            // Int= 2
					  4,            // Int= 3
					  4,            // Int= 4
					  5,            // Int= 5
					  5,            // Int= 6
					  6,            // Int= 7
					  6,            // Int= 8
					  7,            // Int= 9
					  7,            // Int=10
					  8,            // Int=11
					  8,            // Int=12
					  9,            // Int=13
					  9,            // Int=14
					  10,            // Int=15
					  11,            // Int=16
					  12,            // Int=17
					  13,            // Int=18
					  14,            // Int=19
					  15,            // Int=20
					  16,            // Int=21
					  17,            // Int=22
					  18,            // Int=23
					  19,            // Int=24
					  20,            // Int=25
					  22,            // Int=26
					  24,            // Int=27
					  26,            // Int=28
					  27,            // Int=29
					  29,            // Int=30
					  31,            // Int=31
					  33,            // Int=32
					  35,            // Int=33
					  37,            // Int=34
					  39,            // Int=35
					  41,            // Int=36
					  44,            // Int=37
					  47,            // Int=38
					  50,            // Int=39
					  53,            // Int=40
					  56,            // Int=41
					  59,            // Int=42
					  62,            // Int=43
					  65,            // Int=44
					  68,            // Int=45
					  71,            // Int=46
					  74,            // Int=47
					  77,            // Int=48
					  80,            // Int=49
					  83            // Int=50
};

//         
int mana_cost_cs[][9] = {
	//	1   2    3    4    5    6    7    8    9
	{9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  0
	{1143, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  1
	{1000, 9999, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  2
	{950, 1250, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  3
	{880, 990, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  4
	{830, 900, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  5
	{780, 850, 9999, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  6
	{710, 660, 1000, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  7
	{560, 600, 770, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  8
	{500, 600, 700, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev  9
	{450, 550, 640, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev 10
	{390, 460, 540, 9999, 9999, 9999, 9999, 9999, 9999},    // Lev 11
	{360, 430, 500, 1000, 9999, 9999, 9999, 9999, 9999},    // Lev 12
	{330, 400, 470, 800, 9999, 9999, 9999, 9999, 9999},    // Lev 13
	{300, 350, 410, 700, 9999, 9999, 9999, 9999, 9999},    // Lev 14
	{280, 330, 390, 560, 9999, 9999, 9999, 9999, 9999},    // Lev 15
	{250, 300, 350, 500, 1000, 9999, 9999, 9999, 9999},    // Lev 16
	{230, 270, 320, 450, 630, 9999, 9999, 9999, 9999},    // Lev 17
	{200, 240, 280, 400, 560, 9999, 9999, 9999, 9999},    // Lev 18
	{190, 220, 260, 370, 520, 1000, 9999, 9999, 9999},    // Lev 19
	{180, 210, 250, 360, 500, 620, 9999, 9999, 9999},    // Lev 20
	{160, 190, 230, 320, 450, 560, 9999, 9999, 9999},    // Lev 21
	{160, 190, 220, 310, 440, 550, 9999, 9999, 9999},    // Lev 22
	{150, 180, 210, 300, 430, 530, 9999, 9999, 9999},    // Lev 23
	{150, 180, 210, 300, 410, 510, 1000, 9999, 9999},    // Lev 24
	{140, 170, 200, 290, 400, 500, 750, 9999, 9999},    // Lev 25
	{130, 160, 180, 260, 370, 460, 600, 9999, 9999},    // Lev 26
	{120, 150, 170, 240, 340, 430, 550, 1000, 9999},    // Lev 27
	{120, 140, 160, 230, 320, 410, 490, 750, 9999},    // Lev 28
	{110, 130, 160, 220, 310, 390, 470, 670, 9999},    // Lev 29
	{100, 120, 140, 200, 280, 350, 420, 600, 1300},    // Lev 30
	{1, 1, 1, 1, 1, 1, 1, 1, 1},    // Lev 31
	{1, 1, 1, 1, 1, 1, 1, 1, 1},    // Lev 32
	{1, 1, 1, 1, 1, 1, 1, 1, 1},    // Lev 33
	{1, 1, 1, 1, 1, 1, 1, 1, 1}    // Lev 34
};

// Weapon attack texts
struct AttackHitType attack_hit_text[] =
	{
		{"", ""},    // 0
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},    // 5
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},    // 10
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},
		{"", ""},
		{"*", "*"},
		{"*", "*"},
		{"*", "*"}
	};

const char *godslike_bits[] =
	{
		"GODSLIKE",
		"GODSCURSE",
		"HIGHGOD",
		"REMORT",
		"DEMIGOD",
		"PERSLOG",
		"TESTER",
		"\n"
	};

const char *weapon_class[] = {"",
							  " ",
							  " ",
							  "",
							  "  ",
							  " ",
							  "",
							  " ",
							  "  "
};

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
