#ifndef __ZONE_TABLE_HPP__
#define __ZONE_TABLE_HPP__

#include "structs/structs.h"

#include <vector>

struct ZoneCategory {
	char *name = nullptr;            // type name //
	int ingr_qty = 0;        // quantity of ingredient types //
	int *ingr_types = nullptr;    // types of ingredients, which are loaded in zones of this type //
};

extern struct ZoneCategory *zone_types;

// zone definition structure. for the 'zone-table'
class ZoneData {
 public:
	ZoneData();

	ZoneData(const ZoneData &) = delete;
	ZoneData(ZoneData &&) = default;

	ZoneData &operator=(const ZoneData &) = delete;
	ZoneData &operator=(ZoneData &&) = default;

	~ZoneData();

	char *name;        //  
	char *comment;
	char *author;
	int traffic;
	int level;    // level of this zone (is used in ingredient loading)
	int type;    // the surface type of this zone (is used in ingredient loading)

	int lifespan;        // how long between resets (minutes)
	int age;        // current age of this zone (minutes)
	RoomVnum top;        // upper limit for rooms in this zone
	RoomRnum FirstRoomVnum;
	RoomRnum LastRoomVnum;
	/**
	 * Conditions for reset.
	 *
	 * Values:
	 *   0: Don't reset, and don't update age.
	 *   1: Reset if no PC's are located in zone.
	 *   2: Just reset.
	 *   3: Multi reset.
	 */
	int reset_mode;

	ZoneVnum vnum;    // virtual number of this zone
	//  
	char *location;
	//  
	char *description;
	struct reset_com *cmd;    // command table for reset

	int typeA_count;
	int *typeA_list;    //   ,     
	int typeB_count;
	int *
		typeB_list;    //   ,   ,          
	bool *typeB_flag;    // ,      
	int under_construction;    //    
	bool locked;
	bool reset_idle;    //   ,     
	bool used;        //   -    
	unsigned long long activity;    //     
	// <= 1 -   (), >= 2 -      - 
	int group;
	//     
	int mob_level;
	//    
	bool is_town;
	//    ,  ,    
	int count_reset;
};

using ZoneTable = std::vector<ZoneData>;
extern ZoneTable &zone_table;

#endif // __ZONE_TABLE_HPP__

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :

