/*
	-  (abilities)   .
*/

#ifndef BYLINS_SRC_ABILITIES_ABILITIES_CONSTANTS_H_
#define BYLINS_SRC_ABILITIES_ABILITIES_CONSTANTS_H_

#include "structs/structs.h"

namespace abilities {

///  
enum class EAbility {
	kUndefined,
	kScirmisher,
	kTactician,
	kCutting,
	kThrowWeapon,
	kShadowThrower,
	kShadowDagger,
	kShadowSpear,
	kShadowClub,
	kDoubleThrower,
	kTripleThrower,
	kPowerThrow,
	kDeadlyThrow,
	kTurnUndead
};

///    
enum class EAbilityMsg {
	kBasicMsgTry,
	kKillMsgToDamager,
	kKillMsgToVictim,
	kKillMsgToOnlookers,
	kMissMsgToDamager,
	kMissMsgToVictim,
	kMissMsgToOnlookers,
	kDmgMsgToDamager,
	kDmgMsgToVictim,
	kDmgMsgToOnlookers,
	kDmgGodMsgToDamager,
	kDmgGodMsgToVictim,
	kDmgGodMsgToOnlookers,
	kDenyMsgHaveNoAbility,
	kDenyMsgNoVictim,
	kDenyMsgOnHorse,
	kDenyMsgAbilityCooldown,
	kDenyMsgActorIsVictim,
	kDenyMsgHaveNoWeapon,
	kDenyMsgWrongWeapon,
	kDenyMsgWrongVictim,
	kDenyMsgWrongPosition,
	kDenyMsgIsNotAbleToAct
};

///  /  ( ,      ..)
enum class ECirumstance {
	kDarkRoom,
	kMetalEquipment,
	kDrawingAttention,		//   ,  ,    .
	kAmbushAttack,			//       .
	kVictimSits,
	kVictimBashed,			//   ,  POS_FIGHTING.
	kVictimAwareness,		//    "".
	kVictimAwake,
	kVictimHold,
	kVictimSleep,
	kRoomInside,
	kRoomCity,
	kRoomForest,
	kRoomHills,
	kRoomMountain,
	kWeatherRaining,
	kWeatherLighting
};

const int kNoviceSkillThreshold = 75;
const int kMinDegree = 0;
const int kMaxDegree = 10;
const double kSkillWeight = 1.0;
const double kNoviceSkillWeight = 0.75;
const double kParameterWeight = 3.0;
const double kSaveWeight = 1.0;

const int kMainDiceSize = 100;
const int kDmgDiceSize = 5;
const int kDmgDicepoolSkillDivider = 5;
const int kDefaultDifficulty = 0;
const int kMinAbilityDifficulty = -150;
const int kMaxAbilityDifficulty = 150;
const int kSuccessThreshold = 0;
const int kDefaultCritfailThreshold = 95;
const int kDefaultCritsuccessThreshold = 6;
const int kDefaultMvPPenalty = 30;
const int kDefaultPvPPenalty = 12;
const int kMaxFailDegree = -10;
const int kMaxSuccessDegree = 10;
const int kDegreeDivider = 10;
const int kSkillRatingDivider = 2;
const int kStatRatingDivider = 2;
const int kCircumstanceFactor = 5;
constexpr int kMinimalFailResult = kSuccessThreshold - 1;

const int kMinRollBonus = -200;
const int kMaxRollBonus = 200;

}; // namespace abilities

template<>
const std::string &NAME_BY_ITEM<abilities::EAbility>(abilities::EAbility item);
template<>
abilities::EAbility ITEM_BY_NAME<abilities::EAbility>(const std::string &name);

template<>
const std::string &NAME_BY_ITEM<abilities::EAbilityMsg>(abilities::EAbilityMsg item);
template<>
abilities::EAbilityMsg ITEM_BY_NAME<abilities::EAbilityMsg>(const std::string &name);

template<>
const std::string &NAME_BY_ITEM<abilities::ECirumstance>(abilities::ECirumstance item);
template<>
abilities::ECirumstance ITEM_BY_NAME<abilities::ECirumstance>(const std::string &name);

#endif // BYLINS_SRC_ABILITIES_ABILITIES_CONSTANTS_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
