#include "common.h"

#include "game_skills/parry.h"
#include "handler.h"

int IsHaveNoExtraAttack(CharData *ch) {
	std::string message = "";
	parry_override(ch);
	if (ch->GetExtraVictim()) {
		switch (ch->get_extra_attack_mode()) {
			case kExtraAttackBash: message = ".    $N3.";
				break;
			case kExtraAttackKick: message = ".    $N3.";
				break;
			case kExtraAttackChopoff: message = ".    $N3.";
				break;
			case kExtraAttackDisarm: message = ".    $N3.";
				break;
			case kExtraAttackThrow: message = ".      $N3.";
				break;
			case kExtraAttackCut: message = ".       $N1.";
				break;
			default: return false;
		}
	} else {
		return true;
	};

	act(message.c_str(), false, ch, nullptr, ch->GetExtraVictim(), kToChar);
	return false;
}

void SetWait(CharData *ch, int waittime, int victim_in_room) {
	if (!IS_IMMORTAL(ch) && (!victim_in_room || (ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())))) {
		SetWaitState(ch, waittime * kBattleRound);
	}
}

void SetSkillCooldown(CharData *ch, ESkill skill, int pulses) {
	if (ch->getSkillCooldownInPulses(skill) < pulses) {
		ch->setSkillCooldown(skill, pulses * kBattleRound);
	}
}

void SetSkillCooldownInFight(CharData *ch, ESkill skill, int pulses) {
	if (ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())) {
		SetSkillCooldown(ch, skill, pulses);
	} else {
		SetWaitState(ch, kBattleRound / 6);
	}
}

CharData *FindVictim(CharData *ch, char *argument) {
	one_argument(argument, arg);
	CharData *victim = get_char_vis(ch, arg, EFind::kCharInRoom);
	if (!victim) {
		if (!*arg && ch->GetEnemy() && ch->isInSameRoom(ch->GetEnemy())) {
			victim = ch->GetEnemy();
		}
	}
	return victim;
}
