// Part of Bylins http://www.mud.ru

#ifndef _FIGHT_H_
#define _FIGHT_H_

#include "fight_constants.h"
#include "entities/char_data.h"
#include "structs/structs.h"
#include "conf.h"
#include "sysdep.h"

/**
 *        :
 * Damage obj(SkillDmg(SKILL_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SkillDmg {
	explicit SkillDmg(ESkill id) : skill_id(id) {};
	ESkill skill_id;
};

/**
 *        :
 * Damage obj(SpellDmg(SPELL_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SpellDmg {
	explicit SpellDmg(ESpell spell_id) : spell_id(spell_id) {};
	ESpell spell_id;
};

/**
 *          (   messages):
 * Damage obj(SimpleDmg(TYPE_NUM), dam, FightSystem::UNDEF_DMG|PHYS_DMG|MAGE_DMG)
 * obj.process(ch, victim);
 */
struct SimpleDmg {
	SimpleDmg(int num) : msg_num(num) {};
	int msg_num;
};

/**
 *  ,  :
 *   dam -  
 *   msg_num -    skill_num/spell_num/hit_type
 *   dmg_type - UNDEF_DMG/PHYS_DMG/MAGE_DMG
 *   :
 *   ch_start_pos -        ( )
 *   victim_start_pos -        (/ )
 */
class Damage {
 public:
	//    
	Damage() { zero_init(); };

	// 
	Damage(SkillDmg obj, int in_dam, fight::DmgType in_dmg_type, ObjData *wielded_obj) {
		zero_init();
		skill_id = obj.skill_id;
		dam = in_dam;
		dmg_type = in_dmg_type;
		wielded = wielded_obj;
	};

	// 
	Damage(SpellDmg obj, int in_dam, fight::DmgType in_dmg_type) {
		zero_init();
		spell_id = obj.spell_id;
		dam = in_dam;
		dmg_type = in_dmg_type;
	};

	//  
	Damage(SimpleDmg obj, int in_dam, fight::DmgType in_dmg_type) {
		zero_init();
		msg_num = obj.msg_num;
		dam = in_dam;
		dmg_type = in_dmg_type;
	};

	int Process(CharData *ch, CharData *victim);

	//  
	int dam;
	// flags[CRIT_HIT] = true, dam_critic = 0 -  
	// flags[CRIT_HIT] = true, dam_critic > 0 -   
	int dam_critic;
	//   (//)
	int dmg_type;
	// .   HitData
	ESkill skill_id;
	//  ,  >= 0
	ESpell spell_id;
	//    .
	// ,   ,    .
	//   -     .
	EElement element;
	// .   HitData,     -1
	int hit_type;
	//       messages
	//      process
	int msg_num;
	//    HitType
	std::bitset<fight::kHitFlagsNum> flags;
	//      (   =  )
	EPosition ch_start_pos;
	//      (   =  )
	EPosition victim_start_pos;
	//    
	ObjData *wielded;

 private:
	//       
	void zero_init();
	//  msg_num, ch_start_pos, victim_start_pos
	//    process,    
	void post_init(CharData *ch, CharData *victim);
	void post_init_shields(CharData *victim);
	// process()
	bool magic_shields_dam(CharData *ch, CharData *victim);
	void armor_dam_reduce(CharData *victim);
	bool dam_absorb(CharData *ch, CharData *victim);
	void process_death(CharData *ch, CharData *victim);
	void send_critical_message(CharData *ch, CharData *victim);
	void dam_message(CharData *ch, CharData *victim) const;

	//     
	int fs_damage;
	//     ,     
	//   flags   
	std::string brief_shields_;
};

// fight.cpp

void SetFighting(CharData *ch, CharData *vict);
inline void set_fighting(const CharData::shared_ptr &ch, CharData *victim) { SetFighting(ch.get(), victim); }

void stop_fighting(CharData *ch, int switch_others);
void perform_violence();
int calc_initiative(CharData *ch, bool mode);

// fight_hit.cpp

int compute_armor_class(CharData *ch);
bool check_mighthit_weapon(CharData *ch);
void GetClassWeaponMod(ECharClass class_id, const ESkill skill, int *damroll, int *hitroll);

// fight_stuff.cpp

void die(CharData *ch, CharData *killer);
void raw_kill(CharData *ch, CharData *killer);

void alterate_object(ObjData *obj, int dam, int chance);
void alt_equip(CharData *ch, int pos, int dam, int chance);

void char_dam_message(int dam, CharData *ch, CharData *victim, bool mayflee);
void TestSelfHitroll(CharData *ch);

int calc_leadership(CharData *ch);

#endif

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
