/* ************************************************************************
*   File: pk.h                                          Part of Bylins    *
*  Usage: header file: constants and fn prototypes for           *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
*                                                                         *
*  $Author$                                                        *
*  $Date$                                           *
*  $Revision$                                                       *
************************************************************************ */

#ifndef _PVP_H_
#define _PVP_H_

#include "entities/char_data.h"

#include <string>

class ObjData;    // forward declaration to avoid inclusion of obj.hpp and any dependencies of that header.

//*************************************************************************
//        

//  :
//   1.   may_kill_here()
//           (  ,   ..)
//   2.   check_pkill()
//           
//         
//   3.   pk_agro_action()   
//   4.   pk_thiefs_action()  
//   5.   pk_revenge_action()   

//     
struct PK_Memory_type {
	long unique;        // unique 
	long kill_num;        //      unique
	long kill_at;        //     ( spamm)
	long revenge_num;    //       unique
	long battle_exp;    //   
	long thief_exp;        //    
	long clan_exp;        //   -
	struct PK_Memory_type *next;
};

const short MAX_REVENGE = 2;    //     

#define        PK_ACTION_NO        1    //  
#define        PK_ACTION_FIGHT     2    //    
#define        PK_ACTION_REVENGE    4    //   
#define        PK_ACTION_KILL        8    // 

// agressor   victim
//  -   (. )
int pk_action_type(CharData *agressor, CharData *victim);

//    ch     victim
// true - 
// false -  
int may_kill_here(CharData *ch, CharData *victim, char *argument);

//     
bool check_agrobd(CharData *ch);

//      
bool need_full_alias(CharData *ch, CharData *opponent);

//,    arg   ch
int name_cmp(CharData *ch, const char *arg);

//   
int check_pkill(CharData *ch, CharData *opponent, const char *arg);
int check_pkill(CharData *ch, CharData *opponent, const std::string &arg);

// agressor    victim
bool pk_agro_action(CharData *agressor, CharData *victim);

// thief    victim,    
void pk_thiefs_action(CharData *thief, CharData *victim);

// killer  victim
void pk_revenge_action(CharData *killer, CharData *victim);

//   
void pk_free_list(CharData *ch);

//    
int pk_count(CharData *ch);

//    ( )
int pk_player_count(CharData *ch);

//*************************************************************************
//     

void aura(CharData *ch, int lvl, CharData *victim, char *s);
const char *CCPK(CharData *ch, int lvl, CharData *victim);
inline const char *CCPK(CharData *ch, int lvl, const CharData::shared_ptr &victim) {
	return CCPK(ch, lvl, victim.get());
}
void pk_list_sprintf(CharData *ch, char *buff);
void do_revenge(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/);

//*************************************************************************
//   /  
void save_pkills(CharData *ch, FILE *saved);

//*************************************************************************
bool has_clan_members_in_group(CharData *ch);

//       
//bool check_charmise(CharacterData * ch, CharacterData * victim, char * argument);

//Polud
void pkPortal(CharData *ch);

// 
namespace bloody {
//    
void update();
// 
void remove_obj(const ObjData *obj);

//   obj  ch  victim
//ch   NULL ()
//victim   null (   , , ..)
// true,    ,  false   
bool handle_transfer(CharData *ch, CharData *victim, ObjData *obj, ObjData *container = nullptr);
//     
void handle_corpse(ObjData *corpse, CharData *ch, CharData *killer);
bool is_bloody(const ObjData *obj);
}

//      
//      ObjectData,     ITEM_BLOODY     bloody_map
struct BloodyInfo {
	long owner_unique; //   
	long kill_at; //  
	ObjData *object; // 
	//- ID     ,               id   
	//  O(n)
	//-   ObjectData       bloody_map.      shared_ptr'    
	BloodyInfo(const long _owner_unique = 0, const long _kill_at = 0, ObjData *_object = 0) :
		owner_unique(_owner_unique), kill_at(_kill_at), object(_object) {}
};

typedef std::map<const ObjData *, BloodyInfo> BloodyInfoMap;

#endif // _PVP_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
