//  $RCSfile$     $Date$     $Revision$
//  Part of Bylins http://www.mud.ru
//              

#ifndef BIRTH_PLACES_HPP_INCLUDED
#define BIRTH_PLACES_HPP_INCLUDED

// ,      ,   .
const int kDefaultLoadroom = 4056;
const int kBirthplaceUndefined = -1;
#define BIRTH_PLACES_FILE "birthplaces.xml"
#define BIRTH_PLACE_NAME_UNDEFINED "Undefined:   - "
#define BIRTH_PLACE_MAIN_TAG "birthplaces"
#define BIRTH_PLACE_ERROR_STR "...birth places reading fail"

#include "conf.h"
#include "sysdep.h"
#include "structs/structs.h"
#include "third_party_libs/pugixml/pugixml.h"

#include <vector>

class Birthplaces;

typedef std::shared_ptr<Birthplaces> BirthPlacePtr;
typedef std::vector<BirthPlacePtr> BirthPlaceListType;

class Birthplaces {
 public:
	//static void Load(const char *PathToFile);               //   
	static void Load(pugi::xml_node XMLBirthPlaceList);
	static int GetLoadRoom(short Id);                       //      ID
	static std::string GetMenuStr(short Id);                //      ID
	static std::vector<int> GetItemList(short Id);          //      ID
	static std::string ShowMenu(std::vector<int> BPList);   //      
	static short ParseSelect(char *arg);                    //        (description)
	static bool CheckId(short Id);                          //      ID
	static int GetIdByRoom(int room_vnum);                  //  ID   
	static std::string GetRentHelp(short Id);               //       ID

	//    .
	//   ,   
	short Id() const { return this->_Id; }
	std::string Name() { return this->_Name; }
	std::string Description() { return this->_Description; }
	std::string MenuStr() { return this->_MenuStr; }
	int LoadRoom() { return this->_LoadRoom; }
	std::vector<int> ItemsList() const { return this->_ItemsList; }
	std::string RentHelp() { return this->_RentHelp; }

 private:
	short _Id;                                  //  -  
	std::string _Name;                          //  
	std::string _Description;                   //    
	std::string _MenuStr;                       //   
	int _LoadRoom;                              //   
	std::vector<int> _ItemsList;                //  ,        
	std::string
		_RentHelp;                      // ,   -      

	static BirthPlaceListType BirthPlaceList;   //       
	static void LoadBirthPlace(pugi::xml_node BirthPlaceNode);  //     
	static BirthPlacePtr GetBirthPlaceById(short Id);           //        ID
};

#endif // BIRTH_PLACES_HPP_INCLUDED

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
