#include "entities/char_data.h"
#include "structs/global_objects.h"

void DoCampfire(CharData *ch, char * /*argument*/, int/* cmd*/, int/* subcmd*/) {
	int percent, prob;
	if (!ch->GetSkill(ESkill::kCampfire)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	if (ch->IsOnHorse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (AFF_FLAGGED(ch, EAffect::kBlind)) {
		SendMsgToChar("   !\r\n", ch);
		return;
	}

	if (world[ch->in_room]->fires) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	if (SECT(ch->in_room) == ESector::kInside ||
		SECT(ch->in_room) == ESector::kCity ||
		SECT(ch->in_room) == ESector::kWaterSwim ||
		SECT(ch->in_room) == ESector::kWaterNoswim ||
		SECT(ch->in_room) == ESector::kOnlyFlying ||
		SECT(ch->in_room) == ESector::kUnderwater || SECT(ch->in_room) == ESector::kSecret) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (!check_moves(ch, kFireMoves))
		return;

	percent = number(1, MUD::Skills()[ESkill::kCampfire].difficulty);
	prob = CalcCurrentSkill(ch, ESkill::kCampfire, nullptr);
	if (percent > prob) {
		SendMsgToChar("   ,      .\r\n", ch);
		return;
	} else {
		world[ch->in_room]->fires = std::max(0, (prob - percent) / 5) + 1;
		SendMsgToChar("     .\n\r", ch);
		act("$n $g .",
			false, ch, nullptr, nullptr, kToRoom | kToArenaListen);
		ImproveSkill(ch, ESkill::kCampfire, true, nullptr);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
