#include "chopoff.h"

#include "game_fight/pk.h"
#include "game_fight/common.h"
#include "game_fight/fight_hit.h"
#include "game_fight/fight_start.h"
#include "utils/random.h"
#include "color.h"
#include "structs/global_objects.h"

// ************************* CHOPOFF PROCEDURES
void go_chopoff(CharData *ch, CharData *vict) {
	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (PRF_FLAGS(ch).get(EPrf::kIronWind)) {
		SendMsgToChar("        !\r\n", ch);
		return;
	}

	if (ch->IsHorsePrevents())
		return;

	if ((GET_POS(vict) < EPosition::kFight)) {
		if (number(1, 100) < ch->GetSkill(ESkill::kChopoff)) {
			SendMsgToChar("   ,   .\r\n", ch);
			ch->setSkillCooldown(ESkill::kChopoff, kBattleRound / 6);
			return;
		}
	}

	if (!pk_agro_action(ch, vict))
		return;

	int percent = number(1, MUD::Skill(ESkill::kChopoff).difficulty);
	int prob = CalcCurrentSkill(ch, ESkill::kChopoff, vict);

	if (IsAffectedBySpell(ch, ESpell::kWeb)) {
		prob /= 3;
	}
	if (GET_GOD_FLAG(ch, EGf::kGodsLike)
		|| AFF_FLAGGED(vict, EAffect::kHold)
		|| GET_GOD_FLAG(vict, EGf::kGodscurse)) {
		prob = percent;
	}

	if (GET_GOD_FLAG(ch, EGf::kGodscurse) ||
		GET_GOD_FLAG(vict, EGf::kGodsLike) ||
		vict->IsOnHorse() || GET_POS(vict) < EPosition::kFight || MOB_FLAGGED(vict, EMobFlag::kNoUndercut) || IS_IMMORTAL(
		vict))
		prob = 0;

	bool success = percent <= prob;
	TrainSkill(ch, ESkill::kChopoff, success, vict);
	SendSkillBalanceMsg(ch, MUD::Skill(ESkill::kChopoff).name, percent, prob, success);
	if (!success) {
		sprintf(buf, "%s   $N3,   ...%s", CCWHT(ch, C_NRM), CCNRM(ch, C_NRM));
		act(buf, false, ch, nullptr, vict, kToChar);
		act("$n $u  ,  $g $g.", false, ch, nullptr, vict, kToVict);
		act("$n $u  $N3,  $g $g.", true, ch, nullptr, vict, kToNotVict | kToArenaListen);
		GET_POS(ch) = EPosition::kSit;
		prob = 3;
		if (CanUseFeat(ch, EFeat::kEvasion)) {
			Affect<EApply> af;
			af.type = ESpell::kExpedient;
			af.location = EApply::kPhysicResist;
			af.modifier = 50;
			af.duration = CalcDuration(ch, 3, 0, 0, 0, 0);
			af.battleflag = kAfBattledec | kAfPulsedec;
			ImposeAffect(ch, af, false, false, false, false);
			af.location = EApply::kAffectResist;
			ImposeAffect(ch, af, false, false, false, false);
			af.location = EApply::kMagicResist;
			ImposeAffect(ch, af, false, false, false, false);
			SendMsgToChar(ch, "%s   ,    %s.%s\r\n", CCIGRN(ch, C_NRM), GET_PAD(vict, 1), CCNRM(ch, C_NRM));
			act("$n $u  ,    .", false, ch, nullptr, vict, kToVict);
			act("$n $u  ,    $N1.", true, ch, nullptr, vict, kToNotVict | kToArenaListen);
		}
	} else {
		if (IS_HORSE(vict) && vict->get_master()->IsOnHorse()) {
			CharData *tch = vict->get_master();
			act("$n  $q $N3,  $S .", true, ch, nullptr, vict, kToNotVict | kToArenaListen);
			SendMsgToChar(ch, "%s  ,  %s .%s\r\n",
					CCIBLU(ch, C_NRM), GET_PAD(vict, 3), CCNRM(ch, C_NRM));
			percent = number(1, MUD::Skill(ESkill::kRiding).difficulty);
			prob = GET_SKILL(tch, ESkill::kRiding);
			if (percent < prob) {
				SendMsgToChar(tch, "      .\r\n");
			} else {
				vict->drop_from_horse();
				SetWait(vict, 1, false); //   
			}
		} else {
			SendMsgToChar(ch, "%s  ,   %s  .%s\r\n",
					CCIBLU(ch, C_NRM), GET_PAD(vict, 3), CCNRM(ch, C_NRM));
			act("$n  $q ,   .", false, ch, nullptr, vict, kToVict);
			act("$n  $q $N3,  $S  .", true, ch, nullptr, vict, kToNotVict | kToArenaListen);
			SetWait(vict, 3, false);
			if (ch->isInSameRoom(vict)) {
				GET_POS(vict) = EPosition::kSit;
			}
		}
		prob = 1;
	}
	appear(ch);
	if (!success) {
		SetWait(ch, prob, false);
		if (vict->IsNpc() && CAN_SEE(vict, ch) && vict->have_mind()) {
			hit(vict, ch, ESkill::kUndefined, AFF_FLAGGED(vict, EAffect::kStopRight) ? fight::kOffHand : fight::kMainHand);
		}
	} else {
		SetSkillCooldownInFight(ch, ESkill::kChopoff, prob);
		SetSkillCooldownInFight(ch, ESkill::kGlobalCooldown, 1);
	}
}

void do_chopoff(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->GetSkill(ESkill::kChopoff) < 1) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kChopoff)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};

	if (ch->IsOnHorse()) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}

	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("   ?\r\n", ch);
		return;
	}

	if (vict == ch) {
		SendMsgToChar("    <>.\r\n", ch);
		return;
	}

	if (!may_kill_here(ch, vict, argument))
		return;
	if (!check_pkill(ch, vict, arg))
		return;

	if (IS_IMPL(ch) || !ch->GetEnemy())
		go_chopoff(ch, vict);
	else if (IsHaveNoExtraAttack(ch)) {
		if (!ch->IsNpc())
			act(".    $N3.", false, ch, nullptr, vict, kToChar);
		ch->SetExtraAttack(kExtraAttackChopoff, vict);
	}
}
