#include "kick.h"

#include "game_fight/pk.h"
#include "game_fight/fight.h"
#include "game_fight/fight_hit.h"
#include "game_fight/common.h"
#include "protect.h"
#include "structs/global_objects.h"

// ******************  KICK PROCEDURES
void go_kick(CharData *ch, CharData *vict) {
	const char *to_char = nullptr, *to_vict = nullptr, *to_room = nullptr;

	if (IsUnableToAct(ch)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kKick)) {
		SendMsgToChar("     ,  .\r\n", ch);
		return;
	};

	vict = TryToFindProtector(vict, ch);

	bool success = false;
//	if (PRF_FLAGGED(ch, EPrf::kTester)) {
	SkillRollResult result = MakeSkillTest(ch, ESkill::kKick, vict);
	success = result.success;
/*	} else {
		int percent = ((10 - (compute_armor_class(vict) / 10)) * 2) + number(1, MUD::Skill(ESkill::kKick).difficulty);
		int prob = CalcCurrentSkill(ch, ESkill::kKick, vict);
		if (GET_GOD_FLAG(vict, EGf::kGodscurse) || AFF_FLAGGED(vict, EAffect::kHold)) {
			prob = percent;
		}
		if (GET_GOD_FLAG(ch, EGf::kGodscurse) || (!ch->IsOnHorse() && vict->IsOnHorse())) {
			prob = 0;
		}
		if (IsAffectedBySpell(ch, ESpell::kWeb)) {
			prob /= 3;
		}
		success = percent <= prob;
		SendSkillBalanceMsg(ch, MUD::Skill(ESkill::kKick).name, percent, prob, success);
	}
*/
	TrainSkill(ch, ESkill::kKick, success, vict);
	int cooldown = 2;
	if (!success) {
		Damage dmg(SkillDmg(ESkill::kKick), fight::kZeroDmg, fight::kPhysDmg, nullptr);
		dmg.Process(ch, vict);
		cooldown = 2;
	} else {
	int dam =str_bonus(GetRealStr(ch), STR_TO_DAM) + GetRealDamroll(ch) + GetRealLevel(ch);
	int skill_modi =std::max(0, ch->GetSkill(ESkill::kKick) * 2 / 5);
	int nice = number(1, 200) <= number(0, number(0, ch->calc_morale()));
	int bottom = (nice? skill_modi / 4 : 0);
	skill_modi = number(bottom, skill_modi);
	dam += dam * skill_modi / 100;
	int weight_modi = 5 * (20 + (GET_EQ(ch, EEquipPos::kFeet) ? GET_OBJ_WEIGHT(GET_EQ(ch, EEquipPos::kFeet)) : 0));
	dam = dam * weight_modi / 100;
	dam = number(dam * 2  /5, dam);
		if (ch->IsOnHorse() && (ch->GetSkill(ESkill::kRiding) >= 150) && (ch->GetSkill(ESkill::kKick) >= 150)) {
			Affect<EApply> af;
			af.location = EApply::kNone;
			af.type = ESpell::kBattle;
			af.modifier = 0;
			af.battleflag = 0;
			float modi = ((ch->GetSkill(ESkill::kKick) + GetRealStr(ch) * 5)
				+ (GET_EQ(ch, EEquipPos::kFeet) ? GET_OBJ_WEIGHT(GET_EQ(ch, EEquipPos::kFeet)) : 0) * 3) / float(GET_SIZE(vict));
			if (number(1, 1000) < modi * 10) {
				switch (number(0, (ch->GetSkill(ESkill::kKick) - 150) / 10)) {
					case 0:
					case 1:
						if (!AFF_FLAGGED(vict, EAffect::kStopRight)) {
							to_char = "     $N2,    .";
							to_vict = "   $n1    .";
							to_room = "  $n1   $N2,   $Q .";
							af.type = ESpell::kBattle;
							af.bitvector = to_underlying(EAffect::kStopRight);
							af.duration = CalcDuration(vict, 3 + GetRealRemort(ch) / 4, 0, 0, 0, 0);
							af.battleflag = kAfBattledec | kAfPulsedec;
						} else if (!AFF_FLAGGED(vict, EAffect::kStopLeft)) {
							to_char = "     $N2,    .";
							to_vict = "   $n1    .";
							to_room = "  $n1   $N2,    .";
							af.bitvector = to_underlying(EAffect::kStopLeft);
							af.duration = CalcDuration(vict, 3 + GetRealRemort(ch) / 4, 0, 0, 0, 0);
							af.battleflag = kAfBattledec | kAfPulsedec;
						} else {
							to_char = "     $N2, $M     .";
							to_vict = "   $n1    .";
							to_room = "  $n1   $N2, $M    .";
							af.bitvector = to_underlying(EAffect::kStopFight);
							af.duration = CalcDuration(vict, 3 + GetRealRemort(ch) / 4, 0, 0, 0, 0);
							af.battleflag = kAfBattledec | kAfPulsedec;
						}
						break;
					case 2:
					case 3:
						to_char = "   ,   $N3 .";
						to_vict = "   $n1     ,   .";
						to_room = "     $N3, $n $q $S .";
						af.type = ESpell::kBattle;
						af.bitvector = to_underlying(EAffect::kSilence);
						af.duration = CalcDuration(vict, 3 + GetRealRemort(ch) / 5, 0, 0, 0, 0);
						af.battleflag = kAfBattledec | kAfPulsedec;
						dam *= 2;
						break;
					default:
						if (!MOB_FLAGGED(vict, EMobFlag::kNoBash)) {
							SetWaitState(vict, number(2, 5) * kBattleRound);
							if (GET_POS(vict) > EPosition::kSit) {
								GET_POS(vict) = EPosition::kSit;
							}
							to_char = "      $N2,  $S  !";
							to_vict = "   $n1    ,    .";
							to_room = "  $n1    $N2,  $S  !";
						}
						dam *= 3;
						break;
				}
			} else if (number(1, 1000) < (ch->GetSkill(ESkill::kRiding) / 2)) {
				dam *= 2;
				if (!ch->IsNpc())
					SendMsgToChar("   .\r\n", ch);
			}

			if (to_char) {
				if (!ch->IsNpc()) {
					sprintf(buf, "&G&q%s&Q&n", to_char);
					act(buf, false, ch, nullptr, vict, kToChar);
					sprintf(buf, "%s", to_room);
					act(buf, true, ch, nullptr, vict, kToNotVict | kToArenaListen);
				}
			}
			if (to_vict) {
				if (!vict->IsNpc()) {
					sprintf(buf, "&R&q%s&Q&n", to_vict);
					act(buf, false, ch, nullptr, vict, kToVict);
				}
			}
			ImposeAffect(vict, af, true, false, true, false);
		}

		if (GET_AF_BATTLE(vict, kEafAwake)) {
			dam >>= (2 - (ch->IsOnHorse() ? 1 : 0));
		}
		if (result.CritLuck && !ch->IsOnHorse()) {
			dam *= 2;
			if (!MOB_FLAGGED(vict, EMobFlag::kNoBash)) {
				if (GET_POS(vict) > EPosition::kSit) {
					GET_POS(vict) = EPosition::kSit;
					SetWaitState(vict, 2 * kBattleRound);
					to_char = "$N   !";
					to_vict = "  $n1    .";
					to_room = "  $n1  $N1  !";
					if (!ch->IsNpc()) {
						sprintf(buf, "&G&q%s&Q&n", to_char);
						act(buf, false, ch, nullptr, vict, kToChar);
						sprintf(buf, "%s", to_room);
						act(buf, true, ch, nullptr, vict, kToNotVict | kToArenaListen);
					}
					if (!vict->IsNpc()) {
						sprintf(buf, "&R&q%s&Q&n", to_vict);
						act(buf, false, ch, nullptr, vict, kToVict);
					}
				}
			}
		}
		Damage dmg(SkillDmg(ESkill::kKick), dam, fight::kPhysDmg, nullptr);
		dmg.Process(ch, vict);
		cooldown = 2;
	}
	SetSkillCooldownInFight(ch, ESkill::kKick, cooldown);
	SetSkillCooldownInFight(ch, ESkill::kGlobalCooldown, 1);
}

void do_kick(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->GetSkill(ESkill::kKick) < 1) {
		SendMsgToChar("   .\r\n", ch);
		return;
	}
	if (ch->HasCooldown(ESkill::kKick)) {
		SendMsgToChar("   .\r\n", ch);
		return;
	};

	CharData *vict = FindVictim(ch, argument);
	if (!vict) {
		SendMsgToChar("       ?\r\n", ch);
		return;
	}

	if (vict == ch) {
		SendMsgToChar("   ! ,    ...\r\n", ch);
		return;
	}

	if (!may_kill_here(ch, vict, argument))
		return;
	if (!check_pkill(ch, vict, arg))
		return;

	if (IS_IMPL(ch) || !ch->GetEnemy()) {
		go_kick(ch, vict);
	} else if (IsHaveNoExtraAttack(ch)) {
		act(".    $N3.", false, ch, nullptr, vict, kToChar);
		ch->SetExtraAttack(kExtraAttackKick, vict);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
