#include "pick.h"

#include "entities/char_data.h"
#include "structs/global_objects.h"

PickProbabilityInformation get_pick_probability(CharData *ch, int lock_complexity) {
	//          -10  ,   
	const int allowed_difference = 10;
	const bool skill_train_allowed = (lock_complexity > ch->GetSkill(ESkill::kPickLock)) &&
		(ch->GetSkill(ESkill::kPickLock) + allowed_difference >= lock_complexity);

	//        
	const int skill = CalcCurrentSkill(ch, ESkill::kPickLock, nullptr);
	const int prob_diff = number(1, MUD::Skill(ESkill::kPickLock).difficulty);

	//      (  )
	const int min_chance = 50;
	const int restriction_percent = std::clamp(skill - prob_diff, min_chance, 100);
	const bool complexity_restriction = number(1, 100) > restriction_percent ? true : false;

	//      
	const int skill_difference = static_cast<int>(ch->GetSkill(ESkill::kPickLock)) - static_cast<int>(lock_complexity);

	//   
	int pick_probability_percent = 0;
	if (skill_difference < -10) {
		//    
		pick_probability_percent = 0;
	} else if (skill_difference < 0) {
		//     -10  -1 -> 10%  
		pick_probability_percent = 10;
	} else if (skill_difference < 20) {
		//   ,   
		pick_probability_percent = 30;
	} else {
		//     -   
		pick_probability_percent = 60;
	}

	//    
	int brake_probability = 0;
	if (skill_difference < -20) {
		//    .   
		brake_probability = 0;
	} else if (skill_difference < -10) {
		//     -20  -11 -> 50%   
		brake_probability = 50;
	} else if (skill_difference < -5) {
		//     -10  -6 -> 6%   
		brake_probability = 6;
	} else if (skill_difference < 0) {
		//     -5  -1 -> 3%   
		brake_probability = 3;
	} else {
		//    ->   
		brake_probability = 0;
	}

	//          
	std::string pick_text;
	//     -  ,    
	if (skill_train_allowed) {
		pick_text = "  .";
	} else {
		if (lock_complexity > skill) {
			//    
			pick_text = "      .";
		} else {
			pick_text = " .  .";
		}
	}

	const PickProbabilityInformation pbi {
		pick_text,
		static_cast<unsigned short>(pick_probability_percent),
		static_cast<unsigned short>(brake_probability),
		skill_train_allowed && !complexity_restriction
	};

	if (!ch->IsNpc()) {
		std::stringstream text_info;
		text_info << std::boolalpha << " : " << pbi.unlock_probability << "%,   : " << pbi.brake_lock_probability << "%,   : " << pbi.skill_train_allowed << "\r\n";
		text_info << std::boolalpha << " : " << lock_complexity << ",      : " << skill_difference << "\r\n";
		text_info << std::boolalpha << "   (  ): " << skill_train_allowed << ",     : "  << complexity_restriction << "\r\n";
		ch->send_to_TC(true, true, true, text_info.str().c_str());
	}

	return pbi;
}


// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
