#include "warcry.h"

#include "handler.h"
#include "color.h"
#include "game_magic/magic_utils.h"
#include "game_magic/spells_info.h"
#include "structs/global_objects.h"

void do_warcry(CharData *ch, char *argument, int/* cmd*/, int/* subcmd*/) {
	if (ch->IsNpc() && AFF_FLAGGED(ch, EAffect::kCharmed))
		return;

	if (!ch->GetSkill(ESkill::kWarcry)) {
		SendMsgToChar("    .\r\n", ch);
		return;
	}

	if (AFF_FLAGGED(ch, EAffect::kSilence) || AFF_FLAGGED(ch, EAffect::kStrangled)) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}
	
	std::string wc_name(argument);
	//   ,    "warcry of ..."
	wc_name.erase(std::find_if_not(wc_name.rbegin(), wc_name.rend(), isspace).base(), wc_name.end());
	wc_name.erase(wc_name.begin(), std::find_if_not(wc_name.begin(), wc_name.end(), isspace));

	if (wc_name.empty()) {
		sprintf(buf, "  :\r\n");
		auto cnt{0};;
		for (auto spell_id = ESpell::kFirst; spell_id <= ESpell::kLast; ++spell_id) {
			const char *realname = MUD::Spell(spell_id).GetCName();

			if (realname
				&& MUD::Spell(spell_id).IsFlagged(kMagWarcry)
				&& ch->GetSkill(ESkill::kWarcry) >= MUD::Spell(spell_id).GetManaChange()) {
				if (!IS_SET(GET_SPELL_TYPE(ch, spell_id), ESpellType::kKnow | ESpellType::kTemp))
					continue;
				sprintf(buf + strlen(buf), "%s%2d%s) %s%s%s\r\n",
						KGRN, cnt++, KNRM, MUD::Spell(spell_id).IsViolent() ? KIRED : KIGRN, realname, KNRM);
			}
		}
		SendMsgToChar(buf, ch);
		return;
	}

	if (wc_name.length() > 3 && wc_name.substr(0, 3) == "of ") {
		wc_name = "warcry of " + wc_name.substr(3, std::string::npos);
	} else {
		wc_name = " " + wc_name;
	}

	auto spell_id = FixNameAndFindSpellId(wc_name);

	if (spell_id == ESpell::kUndefined
		|| (ch->GetSkill(ESkill::kWarcry) < MUD::Spell(spell_id).GetManaChange())
		|| !IS_SET(GET_SPELL_TYPE(ch, spell_id), ESpellType::kKnow | ESpellType::kTemp)) {
		SendMsgToChar("     ?\r\n", ch);
		return;
	}

	//          
	//        -    
	//      -    !!
	//         1 

	if (!MUD::Spell(spell_id).AllowTarget(kTarIgnore)) {
		std::stringstream str_log;
		str_log << "  #" << spell_id << ",   !";
		mudlog(str_log.str(), BRF, kLvlGod, SYSLOG, true);
		SendMsgToChar("    .   .\r\n", ch);
		return;
	}

	struct TimedSkill timed;
	timed.skill = ESkill::kWarcry;
	timed.time = IsTimedBySkill(ch, ESkill::kWarcry) + kHoursPerWarcry;

	if (timed.time > kHoursPerDay) {
		SendMsgToChar("     .\r\n", ch);
		return;
	}

	if (GET_MOVE(ch) < MUD::Spell(spell_id).GetMaxMana()) {
		SendMsgToChar("      .\r\n", ch);
		return;
	}

	SaySpell(ch, spell_id, nullptr, nullptr);

	if (CallMagic(ch, nullptr, nullptr, nullptr, spell_id, GetRealLevel(ch)) >= 0) {
		if (!IS_IMMORTAL(ch)) {
			if (ch->get_wait() <= 0) {
				SetWaitState(ch, kBattleRound);
			}
			ImposeTimedSkill(ch, &timed);
			GET_MOVE(ch) -= MUD::Spell(spell_id).GetMaxMana();
		}
		TrainSkill(ch, ESkill::kWarcry, true, nullptr);
	}
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
