/* ************************************************************************
*   File: genchar.cpp                                   Part of Bylins    *
*  Usage: functions for character generation                              *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
*                                                                         *
*  $Author$                                                        *
*  $Date$                                           *
*  $Revision$                                                       *
************************************************************************ */

#include "genchar.h"

#include "conf.h"
#include "sysdep.h"
#include "structs/structs.h"
#include "comm.h"
#include "utils/logger.h"
#include "utils/utils.h"
#include "game_magic/spells.h"
#include "entities/char_data.h"
#include "entities/char_player.h"
#include "db.h"
#include "structs/global_objects.h"

const char *genchar_help =
	"\r\n      .    , \r\n"
	"  ,       .\r\n"
	"  ' '    ,   \r\n"
	"   .  ,  \r\n"
	"  ,  - .\r\n"
	"  ,         0,  \r\n"
	"     .\r\n";

const char *default_race[] = {
	"", //
	"", //
	"", //
	"  ", //
	"", //
	"  ", // 
	"", // 
	"", //
	"  ", //
	"", //
	"", //
	"", //
	"  ", // 
	"" //
};

int CalcBasseStatsSum(CharData *ch) {
	return ch->get_str() + ch->get_dex() + ch->get_int() + ch->get_wis() + ch->get_con() + ch->get_cha();
}

void genchar_disp_menu(CharData *ch) {
	char buf[kMaxStringLength];

	const auto &ch_class = MUD::Class(ch->GetClass());
	sprintf(buf,
			"\r\n              -      +\r\n"
			"       : () %2d ()        [%2d - %2d]\r\n"
			"   : () %2d ()        [%2d - %2d]\r\n"
			"         : () %2d ()        [%2d - %2d]\r\n"
			"   : () %2d ()        [%2d - %2d]\r\n"
			"   : () %2d ()        [%2d - %2d]\r\n"
			"    : () %2d ()        [%2d - %2d]\r\n"
			"\r\n"
			"   : %3d \r\n"
			"\r\n"
			"  )  ( .   ' ')\r\n"
			"  ) &W  (  )&n\r\n",
			ch->GetInbornStr(),
				ch_class.GetBaseStatGenMin(EBaseStat::kStr), ch_class.GetBaseStatGenMax(EBaseStat::kStr),
			ch->GetInbornDex(),
				ch_class.GetBaseStatGenMin(EBaseStat::kDex), ch_class.GetBaseStatGenMax(EBaseStat::kDex),
			ch->GetInbornInt(),
				ch_class.GetBaseStatGenMin(EBaseStat::kInt), ch_class.GetBaseStatGenMax(EBaseStat::kInt),
			ch->GetInbornWis(),
				ch_class.GetBaseStatGenMin(EBaseStat::kWis), ch_class.GetBaseStatGenMax(EBaseStat::kWis),
			ch->GetInbornCon(),
				ch_class.GetBaseStatGenMin(EBaseStat::kCon), ch_class.GetBaseStatGenMax(EBaseStat::kCon),
			ch->GetInbornCha(),
				ch_class.GetBaseStatGenMin(EBaseStat::kCha), ch_class.GetBaseStatGenMax(EBaseStat::kCha),
			kBaseStatsSum - CalcBasseStatsSum(ch));
	SendMsgToChar(buf, ch);
	if (kBaseStatsSum == CalcBasseStatsSum(ch))
		SendMsgToChar("  )  \r\n", ch);
	SendMsgToChar("  : ", ch);
}

int genchar_parse(CharData *ch, char *arg) {
	const auto &ch_class = MUD::Class(ch->GetClass());
	switch (*arg) {
		case '':
		case '': ch->set_str(std::max(ch->GetInbornStr() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kStr)));
			break;
		case '':
		case '': ch->set_dex(std::max(ch->GetInbornDex() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kDex)));
			break;
		case '':
		case '': ch->set_int(std::max(ch->GetInbornInt() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kInt)));
			break;
		case '':
		case '': ch->set_wis(std::max(ch->GetInbornWis() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kWis)));
			break;
		case '':
		case '': ch->set_con(std::max(ch->GetInbornCon() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kCon)));
			break;
		case '':
		case '': ch->set_cha(std::max(ch->GetInbornCha() - 1, ch_class.GetBaseStatGenMin(EBaseStat::kCha)));
			break;
		case '':
		case '': ch->set_str(std::min(ch->GetInbornStr() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kStr)));
			break;
		case '':
		case '': ch->set_dex(std::min(ch->GetInbornDex() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kDex)));
			break;
		case '':
		case '': ch->set_int(std::min(ch->GetInbornInt() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kInt)));
			break;
		case '':
		case '': ch->set_wis(std::min(ch->GetInbornWis() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kWis)));
			break;
		case '':
		case '': ch->set_con(std::min(ch->GetInbornCon() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kCon)));
			break;
		case '':
		case '': ch->set_cha(std::min(ch->GetInbornCha() + 1, ch_class.GetBaseStatGenMax(EBaseStat::kCha)));
			break;
		case '':
		case '': SendMsgToChar(genchar_help, ch);
			break;
		case '':
		case '':
			if (CalcBasseStatsSum(ch) != kBaseStatsSum)
				break;
			//       
			ch->set_start_stat(G_STR, ch->GetInbornStr());
			ch->set_start_stat(G_DEX, ch->GetInbornDex());
			ch->set_start_stat(G_INT, ch->GetInbornInt());
			ch->set_start_stat(G_WIS, ch->GetInbornWis());
			ch->set_start_stat(G_CON, ch->GetInbornCon());
			ch->set_start_stat(G_CHA, ch->GetInbornCha());
			return kGencharExit;
		case '':
		case '': {
			const auto &tmp_class = MUD::Class(ch->GetClass());
			ch->set_str(tmp_class.GetBaseStatGenAuto(EBaseStat::kStr));
			ch->set_dex(tmp_class.GetBaseStatGenAuto(EBaseStat::kDex));
			ch->set_int(tmp_class.GetBaseStatGenAuto(EBaseStat::kInt));
			ch->set_wis(tmp_class.GetBaseStatGenAuto(EBaseStat::kWis));
			ch->set_con(tmp_class.GetBaseStatGenAuto(EBaseStat::kCon));
			ch->set_cha(tmp_class.GetBaseStatGenAuto(EBaseStat::kCha));
			ch->set_start_stat(G_STR, ch->GetInbornStr());
			ch->set_start_stat(G_DEX, ch->GetInbornDex());
			ch->set_start_stat(G_INT, ch->GetInbornInt());
			ch->set_start_stat(G_WIS, ch->GetInbornWis());
			ch->set_start_stat(G_CON, ch->GetInbornCon());
			ch->set_start_stat(G_CHA, ch->GetInbornCha());
			return kGencharExit;
		}
		default: break;
	}
	return kGencharContinue;
}

void SetStartAbils(CharData *ch) {
	const auto &tmp_class = MUD::Class(ch->GetClass());
	ch->set_str(tmp_class.GetBaseStatGenMin(EBaseStat::kStr));
	ch->set_dex(tmp_class.GetBaseStatGenMin(EBaseStat::kDex));
	ch->set_con(tmp_class.GetBaseStatGenMin(EBaseStat::kCon));
	ch->set_int(tmp_class.GetBaseStatGenMin(EBaseStat::kInt));
	ch->set_wis(tmp_class.GetBaseStatGenMin(EBaseStat::kWis));
	ch->set_cha(tmp_class.GetBaseStatGenMin(EBaseStat::kCha));
	switch (ch->GetClass()) {
		case ECharClass::kSorcerer: ch->set_cha(10);
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 170) : number(120, 180);
			break;
		case ECharClass::kConjurer:
		case ECharClass::kWizard:
		case ECharClass::kCharmer:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 170) : number(150, 180);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 150) : number(120, 180);
			break;
		case ECharClass::kNecromancer:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 170) : number(150, 180);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 150) : number(120, 180);
			break;
		case ECharClass::kThief:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 190);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 170) : number(120, 180);
			break;
		case ECharClass::kWarrior: ch->set_cha(10);
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(165, 180) : number(170, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(160, 180) : number(170, 200);
			break;
		case ECharClass::kAssasine: ch->set_cha(12);
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 180) : number(150, 200);
			break;
		case ECharClass::kGuard: ch->set_cha(12);
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(140, 170) : number(160, 200);
			break;
		case ECharClass::kPaladine:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(140, 175) : number(140, 190);
			break;
		case ECharClass::kRanger:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 180) : number(120, 200);
			break;
		case ECharClass::kVigilant:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(160, 180) : number(170, 200);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(170, 200);
			break;
		case ECharClass::kMerchant:
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 170) : number(150, 190);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 180) : number(120, 200);
			break;
		case ECharClass::kMagus: ch->set_cha(12);
			GET_HEIGHT(ch) = IS_FEMALE(ch) ? number(150, 180) : number(150, 190);
			GET_WEIGHT(ch) = IS_FEMALE(ch) ? number(120, 170) : number(120, 180);
			for (auto spell_id = ESpell::kFirst; spell_id <= ESpell::kLast; ++spell_id) {
				GET_SPELL_TYPE(ch, spell_id) = ESpellType::kRunes;
			}
			break;
		default: 
			log("SYSERROR : ATTEMPT STORE ABILITIES FOR UNKNOWN CLASS (Player %s)", GET_NAME(ch));
			break;
	}
}

//      .
//        .
// name -    
// sex -  (kMale  kFemale)
// caseNum -   (0 - 5)
//  0 -  (? ?)
//  1 -  (? ?)
//  2 -  (? ?)
//  3 -  (? ?)
//  4 -  (? ?)
//  5 -  ( ?  ?)
// result - 
void GetCase(const char *name, const EGender sex, int caseNum, char *result) {
	size_t len = strlen(name);

	if (strchr("", name[len - 1]) != nullptr
		&& sex == EGender::kMale) {
		strcpy(result, name);
		if (caseNum == 1)
			strcat(result, ""); // 
		else if (caseNum == 2)
			strcat(result, ""); // 
		else if (caseNum == 3)
			strcat(result, ""); // 
		else if (caseNum == 4)
			strcat(result, ""); // , 
		else if (caseNum == 5)
			strcat(result, ""); // 
	} else if (name[len - 1] == '') {
		strncpy(result, name, len - 1);
		result[len - 1] = '\0';
		if (caseNum == 1)
			strcat(result, ""); // , 
		else if (caseNum == 2)
			strcat(result, ""); // , 
		else if (caseNum == 3)
			strcat(result, ""); // , 
		else if (caseNum == 4)
			strcat(result, ""); // , 
		else if (caseNum == 5)
			strcat(result, ""); // , 
		else
			strcat(result, ""); // , 
	} else if (name[len - 1] == ''
		&& sex == EGender::kMale) {
		strncpy(result, name, len - 1);
		result[len - 1] = '\0';
		if (caseNum == 1)
			strcat(result, ""); // 
		else if (caseNum == 2)
			strcat(result, ""); // 
		else if (caseNum == 3)
			strcat(result, ""); // 
		else if (caseNum == 4)
			strcat(result, ""); // 
		else if (caseNum == 5)
			strcat(result, ""); // 
		else
			strcat(result, ""); // 
	} else if (name[len - 1] == '') {
		strncpy(result, name, len - 1);
		result[len - 1] = '\0';
		if (caseNum == 1) {
			if (strchr("", name[len - 2]) != nullptr)
				strcat(result, ""); // , 
			else
				strcat(result, ""); // 
		} else if (caseNum == 2)
			strcat(result, ""); // , 
		else if (caseNum == 3)
			strcat(result, ""); // , 
		else if (caseNum == 4) {
			if (strchr("", name[len - 2]) != nullptr)
				strcat(result, ""); // , 
			else
				strcat(result, ""); // , 
		} else if (caseNum == 5)
			strcat(result, ""); // , 
		else
			strcat(result, ""); // , 
	} else {
		//     ,   (,   )
		strcpy(result, name);
	}
	CAP(result);
}

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
