// Copyright (c) 2013 Krodo
// Part of Bylins http://www.mud.ru

#ifndef MOB_STAT_HPP_INCLUDED
#define MOB_STAT_HPP_INCLUDED

#include "conf.h"
#include <unordered_map>
#include <array>
#include <list>
#include <string>
#include <game_classes/classes_constants.h>

#include "sysdep.h"
#include "structs/structs.h"

///    /       
namespace mob_stat {

/// . -      
const int kMaxGroupSize = 20;
///   mob_stat.xml ()
const int kSavePeriod = 27;
/// 0 -   , 1..MAX_GROUP_SIZE -   
using KillStat = std::array<int, kMaxGroupSize + 1>;

struct MobMonthKillStat {
	MobMonthKillStat() : month(0), year(0) {
		kills.fill(0);
	};
	int month;			//  (1..12)
	int year;			//  ()
	KillStat kills{};	//      
};

struct MobKillStat {
	static const time_t default_date;

	MobKillStat() : date(0) {}
	explicit MobKillStat(const time_t d) : date(d) {}

	time_t date;
	std::list<MobMonthKillStat> stats;
};

using MobStatRegister = std::unordered_map<MobVnum, MobKillStat>;

extern MobStatRegister mob_stat_register;

///  mob_stat.xml
void Load();
///  mob_stat.xml
void Save();
///     show stats
void ShowStats(CharData *ch);
///    
/// \param members  = 0 - . KillStatType
void AddMob(CharData *mob, int members);
//     
void GetLastMobKill(CharData *mob, std::string &result);
time_t GetMobKilllastTime(MobVnum vnum);
///       (show mobstat ZoneVnum)
void ShowZoneMobKillsStat(CharData *ch, ZoneVnum zone_vnum, int months);
///        ZoneVnum
void ClearZoneStat(ZoneVnum zone_vnum);
///  -   months  (0 = )
MobMonthKillStat SumStat(const std::list<MobMonthKillStat> &mob_stat, int months);
//     vnum
std::string PrintMobName(int mob_vnum, unsigned int len);

} // namespace mob_stat

namespace char_stat {

///   -  ''
extern int mobs_killed;
///   -  ''
extern int players_killed;
///     -  ''
void AddClassExp(ECharClass class_id, int exp);
///     -  ''
void PrintClassesExpStat(std::ostringstream &out);
///        
void LogClassesExpStat();

} // namespace char_stat

#endif // MOB_STAT_HPP_INCLUDED

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
