/**
\authors Created by Sventovit
\date 28.01.2022.
\brief     ,     .
\details     ,     .  ,   
     ,    - .     
     .
*/

#ifndef BYLINS_SRC_UTILS_OBJECTS_FILTER_H_
#define BYLINS_SRC_UTILS_OBJECTS_FILTER_H_

#include "entities/entities_constants.h"
#include "game_skills/skills.h"

#include <string>
#include <vector>

class CharData;
struct ExchangeItem;
class ObjData;

//       -  
struct ParseFilter {
	enum { CLAN, EXCHANGE };

	ParseFilter(int type) : type(-1), state(-1), wear(EWearFlag::kUndefined), wear_message(-1),
							weap_class{}, weap_message(-1), cost(-1), cost_sign('\0'), rent(-1), rent_sign('\0'),
							new_timesign('\0'), new_timedown(time(nullptr)), new_timeup(time(nullptr)),
							filter_type(type) {};

	bool init_type(const char *str);
	bool init_state(const char *str);
	bool init_wear(const char *str);
	bool init_cost(const char *str);
	bool init_rent(const char *str);
	bool init_remorts(const char *str);
	bool init_weap_class(const char *str);
	bool init_affect(char *str, size_t str_len);
	bool init_realtime(const char *str);
	size_t affects_cnt() const;
	bool check(ObjData *obj, CharData *ch);
	bool check(ExchangeItem *exch_obj);
	std::string print() const;

	std::string name;      //  
	std::string owner;     //   ()
	int type;              //  
	int state;             // 
	EWearFlag wear;              //  
	int wear_message;      //    
	ESkill weap_class;        //  
	int weap_message;      //   
	int cost;              //  
	char cost_sign;        //   +/-
	int rent;             //   
	char rent_sign;        //   +/-
	int filter_remorts_count = -1;
	int remorts[2] = {-1,-1}; //  
	char remorts_sign[2] = "\0"; //  
	char new_timesign;       //   < > =
	time_t new_timedown;   //   
	time_t new_timeup;       //   
	int filter_type;       // CLAN/EXCHANGE

	std::vector<int> affect_apply; //  apply_types
	std::vector<int> affect_weap;  //  weapon_affects
	std::vector<int> affect_extra; //  extra_bits

	std::string show_obj_aff(ObjData *obj);

 private:
	bool check_name(ObjData *obj, CharData *ch = nullptr) const;
	bool check_type(ObjData *obj) const;
	bool check_state(ObjData *obj) const;
	bool check_wear(ObjData *obj) const;
	bool check_weap_class(ObjData *obj) const;
	bool check_cost(int obj_price) const;
	bool check_rent(int obj_price) const;
	bool check_remorts(ObjData *obj) const;
	bool check_affect_weap(ObjData *obj) const;
	bool check_affect_apply(ObjData *obj) const;
	bool check_affect_extra(ObjData *obj) const;
	bool check_owner(ExchangeItem *exch_obj) const;
	bool check_realtime(ExchangeItem *exch_obj) const;
};

#endif //BYLINS_SRC_UTILS_OBJECTS_FILTER_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
