// $RCSfile$     $Date$     $$
// Copyright (c) 2008 Krodo
// Part of Bylins http://www.mud.ru

#include "random.h"
#include "utils/utils.h"

#include <random>

namespace Random {
class NormalRand {
 public:
	NormalRand() :
		_rng(_rd()) {}

	int number(int from, int to);
	// 
	double NormalDistributionNumber(double mean, double sigma);
	bool BernoulliTrial(double prob);

 private:
	std::random_device _rd;
	std::mt19937 _rng;
};

NormalRand rnd;

int NormalRand::number(int from, int to) {
	std::uniform_int_distribution<> dist(from, to);
	return dist(_rng);
}

//      
//  mean -   sigma - 
double NormalRand::NormalDistributionNumber(double mean, double sigma) {
	std::normal_distribution<double> NormalDistribution(mean, sigma);
	return NormalDistribution(_rng);
}

bool NormalRand::BernoulliTrial(double p) {
	std::binomial_distribution<> dist(p);
	return dist(_rng);
}
} // namespace Random

//   ,          

// *       from  to.
int number(int from, int to) {
	if (from > to) {
		int tmp = from;
		from = to;
		to = tmp;
	}

	return Random::rnd.number(from, to);
}

// *   .
int RollDices(int number, int size) {
	if (size <= 0 || number <= 0)
		return 0;

	int sum = 0;

	while (number--)
		sum += Random::rnd.number(1, size);

	return sum;
}

bool BernoulliTrial(double p) {
	return Random::rnd.BernoulliTrial(p);
}

/**
*         
   ,   ,        .
     .     
  ,   mean,   .    
   meam,    ,         .
       ,    .
*/
int GaussIntNumber(double mean, double sigma, int min_val, int max_val) {
	double dresult = 0.0;
	int iresult = 0;

	//        
	dresult = Random::rnd.NormalDistributionNumber(mean, sigma);
	//(dresult < mean) ? (iresult = ceil(dresult)) : iresult = floor(dresult);
	//
	iresult = ((dresult < mean) ? ceil(dresult) : floor(dresult));
	//    
	return MAX(MIN(iresult, max_val), min_val);
}


// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
