/*
 \authors Created by Sventovit
 \date 18.02.2022.
 \brief -  .
 \details   .   ,        :  
     ,    ,     : ,
 "" ,  " "  "",  ,   ,   ,  
  .   -         
    . ,   -       
 .

    ,    FT_EMPTY2_STYLE     libfort  ,
     .  -      
   .        ( ,    
    ,       ).

   ,         escape-  telnet.
   - , 9    .  - 
         ( ,       
  telnet, ).
 */

#ifndef BYLINS_SRC_UTILS_TABLE_WRAPPER_H_
#define BYLINS_SRC_UTILS_TABLE_WRAPPER_H_

#include "third_party_libs/libfort/fort.hpp"

class CharData;

namespace table_wrapper {

/**
 *    .
 */
using Color = fort::color;

/**
 *    .
 *  : kRight, kLeft, kCenter.
 */
using TextAlign = fort::text_align;

/**
 *   ,  unicode .
 */
class Table : public fort::char_table {
 public:
	void SetColumnAlign(std::size_t column_index, TextAlign align) {
		this->column(column_index).set_cell_text_align(align);
	};
};

[[maybe_unused]] const auto kHeader			{fort::header};
[[maybe_unused]] const auto kEndRow			{fort::endr};
[[maybe_unused]] const auto kSeparator		{fort::separator};

namespace align {
[[maybe_unused]] const auto kRight			{fort::text_align::right};
[[maybe_unused]] const auto kLeft			{fort::text_align::left};
[[maybe_unused]] const auto kCenter			{fort::text_align::center};
}

namespace color {
[[maybe_unused]] const auto kDefaultColor	{fort::color::default_color};
[[maybe_unused]] const auto kBlack			{fort::color::black};
[[maybe_unused]] const auto kRed			{fort::color::red};
[[maybe_unused]] const auto kGreen			{fort::color::green};
[[maybe_unused]] const auto kYellow			{fort::color::yellow};
[[maybe_unused]] const auto kBlue			{fort::color::blue};
[[maybe_unused]] const auto kMagenta		{fort::color::magenta};
[[maybe_unused]] const auto kCyan			{fort::color::cyan};
[[maybe_unused]] const auto kLightGray		{fort::color::light_gray};
[[maybe_unused]] const auto kDarkGray		{fort::color::dark_gray};
[[maybe_unused]] const auto kLightRed		{fort::color::light_red};
[[maybe_unused]] const auto kLightGreen		{fort::color::light_green};
[[maybe_unused]] const auto kLightYellow	{fort::color::light_yellow};
[[maybe_unused]] const auto kLightBlue		{fort::color::light_blue};
[[maybe_unused]] const auto kLightMagenta	{fort::color::light_magenta};
[[maybe_unused]] const auto kLightCyan		{fort::color::light_cyan};
[[maybe_unused]] const auto kLightWhite		{fort::color::light_whyte};
}


/**
 *   ,  ,    .
 * @param ch - ,    .
 * @param table -  .
 */
void DecorateSimpleTable(CharData *ch, Table &table);

/**
 *      (   ).
 * @param ch - ,    .
 * @param table -  .
 */
void DecorateNoBorderTable(CharData *ch, Table &table);

/**
 *    -    .
 * @param ch - ,    .
 * @param table -  .
 */
void DecorateServiceTable(CharData *ch, Table &table);

/**
 *  ""  -    ..
 * @param ch - ,    .
 * @param table -  .
 */
void DecorateCuteTable(CharData *ch, Table &table);

/**
 *     "".
 *   ,   ,    .
 * @param ch - ,    .
 * @param table -  .
 * @param color -   .
 */
void DecorateZebraTable(CharData *ch, Table &table, Color color);

/**
 *     "".
 *   ,   ,    .
 * @param ch - ,    .
 * @param table -  .
 * @param color -   .
 */
void DecorateZebraTextTable(CharData *ch, Table &table, Color color);

/**
 *    .     .
 *  @param ch - ,   .
 *  @param table -  .
 */
void PrintTableToChar(CharData *ch, Table &table);

/**
 *      .     .
 *  @param ch - ,   .
 *  @param table -  .
 *  @param out -  .
 */
void PrintTableToStream(std::ostringstream &out, Table &table);

} // table_wrapper

#endif //BYLINS_SRC_UTILS_TABLE_WRAPPER_H_

// vim: ts=4 sw=4 tw=0 noet syntax=cpp :
